/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.util.BitSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.vecmath.Point4f;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.shape.Shape;
import org.jmol.shapesurface.Isosurface;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;

public class MolecularOrbital
extends Isosurface {
    private String moTranslucency = null;
    private Float moTranslucentLevel = null;
    private Point4f moPlane = null;
    private Float moCutoff = null;
    private Float moResolution = null;
    private Float moScale = null;
    private Integer moColorPos = null;
    private Integer moColorNeg = null;
    private boolean moIsPositiveOnly = false;
    private int moFill = 1073742046;
    private int moMesh = 1073742018;
    private int moDots = 1073742042;
    private int moFrontOnly = 0x40000088;
    private String moTitleFormat = null;
    private boolean moDebug;
    private int myColorPt;
    private String strID;
    private int moNumber;
    private Map<String, Map<String, Object>> htModels;
    private Map<String, Object> thisModel;

    public void initShape() {
        super.initShape();
        this.myType = "molecularOrbital";
        super.setProperty("thisID", "mo", null);
    }

    public void setProperty(String string, Object object, BitSet bitSet) {
        int n;
        if ("init" == string) {
            this.myColorPt = 0;
            this.moDebug = false;
            int n2 = (Integer)object;
            this.strID = this.getId(n2);
            Logger.info("MO init " + this.strID);
            super.setProperty("init", null, null);
            super.setProperty("modelIndex", n2, null);
            if (this.htModels == null) {
                this.htModels = new Hashtable<String, Map<String, Object>>();
            }
            if (!this.htModels.containsKey(this.strID)) {
                this.htModels.put(this.strID, new Hashtable());
            }
            this.thisModel = this.htModels.get(this.strID);
            this.moNumber = !this.thisModel.containsKey("moNumber") ? 0 : (Integer)this.thisModel.get("moNumber");
            return;
        }
        if ("cutoff" == string) {
            this.thisModel.put("moCutoff", object);
            this.thisModel.put("moIsPositiveOnly", Boolean.FALSE);
            return;
        }
        if ("scale" == string) {
            this.thisModel.put("moScale", object);
            return;
        }
        if ("cutoffPositive" == string) {
            this.thisModel.put("moCutoff", object);
            this.thisModel.put("moIsPositiveOnly", Boolean.TRUE);
            return;
        }
        if ("resolution" == string) {
            this.thisModel.put("moResolution", object);
            return;
        }
        if ("titleFormat" == string) {
            this.moTitleFormat = (String)object;
            return;
        }
        if ("color" == string) {
            if (!(object instanceof Integer)) {
                return;
            }
            this.thisModel.remove("moTranslucency");
            super.setProperty("color", object, bitSet);
            string = "colorRGB";
            this.myColorPt = 0;
        }
        if ("colorRGB" == string) {
            this.moColorPos = (Integer)object;
            if (this.myColorPt++ == 0) {
                this.moColorNeg = this.moColorPos;
            }
            this.thisModel.put("moColorNeg", this.moColorNeg);
            this.thisModel.put("moColorPos", this.moColorPos);
            return;
        }
        if ("plane" == string) {
            if (object == null) {
                this.thisModel.remove("moPlane");
            } else {
                this.thisModel.put("moPlane", object);
            }
            return;
        }
        if ("molecularOrbital" == string) {
            this.moNumber = (Integer)object;
            this.thisModel.put("moNumber", object);
            this.setOrbital(this.moNumber);
            return;
        }
        if ("translucentLevel" == string) {
            if (this.thisModel == null) {
                if (this.currentMesh == null) {
                    return;
                }
                this.thisModel = this.htModels.get(this.currentMesh.thisID);
            }
            this.thisModel.put("moTranslucentLevel", object);
        }
        if ("delete" == string) {
            this.htModels.remove(this.strID);
            this.moNumber = 0;
        }
        if ("token" == string) {
            n = (Integer)object;
            switch (n) {
                case 1073742042: 
                case 1113198595: {
                    this.moDots = n;
                    break;
                }
                case 1073741938: 
                case 1073742046: {
                    this.moFill = n;
                    break;
                }
                case 1073742018: 
                case 0x400000E4: {
                    this.moMesh = n;
                    break;
                }
                case 0x40000088: 
                case 1073742058: {
                    this.moFrontOnly = n;
                }
            }
        }
        if ("translucency" == string) {
            if (this.thisModel == null) {
                if (this.currentMesh == null) {
                    return;
                }
                this.thisModel = this.htModels.get(this.currentMesh.thisID);
            }
            this.thisModel.put("moTranslucency", object);
        }
        if (string == "deleteModelAtoms") {
            n = ((int[])((Object[])object)[2])[0];
            Hashtable<String, Map<String, Object>> hashtable = new Hashtable<String, Map<String, Object>>();
            int n3 = this.meshCount;
            while (--n3 >= 0) {
                if (this.meshes[n3] == null) continue;
                if (this.meshes[n3].modelIndex == n) {
                    --this.meshCount;
                    if (this.meshes[n3] == this.currentMesh) {
                        this.currentMesh = null;
                        this.thisModel = null;
                    }
                    this.meshes = (IsosurfaceMesh[])ArrayUtil.deleteElements(this.meshes, n3, 1);
                    continue;
                }
                Map<String, Object> map = this.htModels.get(this.meshes[n3].thisID);
                if (this.meshes[n3].modelIndex > n) {
                    --this.meshes[n3].modelIndex;
                    this.meshes[n3].thisID = this.getId(this.meshes[n3].modelIndex);
                }
                hashtable.put(this.meshes[n3].thisID, map);
            }
            this.htModels = hashtable;
            return;
        }
        super.setProperty(string, object, bitSet);
    }

    private String getId(int n) {
        return "mo_model" + this.viewer.getModelNumber(n);
    }

    public Object getProperty(String string, int n) {
        if (string == "list") {
            String string2 = (String)super.getProperty("list", n);
            if (string2.length() > 1) {
                string2 = string2 + "cutoff = " + super.getProperty("cutoff", 0) + "\n";
            }
            return this.viewer.getMoInfo(-1) + "\n" + string2;
        }
        if (string == "moNumber") {
            return this.moNumber;
        }
        if (string == "showMO") {
            int n2;
            boolean bl;
            boolean bl2;
            StringBuffer stringBuffer = new StringBuffer();
            List list = (List)this.sg.getMoData().get("mos");
            int n3 = list == null ? 0 : list.size();
            int n4 = n;
            int n5 = this.moNumber;
            boolean bl3 = bl2 = n4 == Integer.MIN_VALUE;
            if (n4 == Integer.MAX_VALUE) {
                n4 = n5;
            }
            if (n3 == 0 || bl2 && n5 == 0) {
                return "";
            }
            boolean bl4 = bl = n4 != 0;
            if (n5 == 0) {
                n4 = 0;
            }
            boolean bl5 = false;
            int n6 = n4 > 0 ? 1 : n3;
            for (int i = n2 = n6 == 1 && n5 > 0 ? n5 : 1; i <= n3; ++i) {
                if (n4 != 0 && n4 != i && (bl || i != n5)) continue;
                if (!bl) {
                    Parameters parameters = this.sg.getParams();
                    super.setProperty("init", parameters, null);
                    this.setOrbital(i);
                }
                this.jvxlData.moleculeXml = this.viewer.getModelCml(this.viewer.getModelUndeletedAtomsBitSet(this.thisMesh.modelIndex), 100, true);
                if (!bl5) {
                    stringBuffer.append(JvxlCoder.jvxlGetFile(this.jvxlData, null, null, "HEADERONLY", true, n6, null, null));
                    bl5 = true;
                }
                stringBuffer.append(JvxlCoder.jvxlGetFile(this.jvxlData, null, this.jvxlData.title, null, false, 1, this.thisMesh.getState("mo"), this.thisMesh.scriptCommand == null ? "" : this.thisMesh.scriptCommand));
                if (!bl) {
                    super.setProperty("delete", "mo_show", null);
                }
                if (n6 == 1) break;
            }
            stringBuffer.append(JvxlCoder.jvxlGetFile(this.jvxlData, null, null, "TRAILERONLY", true, 0, null, null));
            return stringBuffer.toString();
        }
        return super.getProperty(string, n);
    }

    protected void clearSg() {
    }

    private boolean getSettings(String string) {
        this.thisModel = this.htModels.get(string);
        if (this.thisModel == null || this.thisModel.get("moNumber") == null) {
            return false;
        }
        this.moTranslucency = (String)this.thisModel.get("moTranslucency");
        this.moTranslucentLevel = (Float)this.thisModel.get("moTranslucentLevel");
        this.moPlane = (Point4f)this.thisModel.get("moPlane");
        this.moCutoff = (Float)this.thisModel.get("moCutoff");
        if (this.moCutoff == null) {
            this.moCutoff = (Float)this.sg.getMoData().get("defaultCutoff");
        }
        if (this.moCutoff == null) {
            this.moCutoff = new Float(0.05f);
        }
        this.thisModel.put("moCutoff", new Float(this.moCutoff.floatValue()));
        this.moResolution = (Float)this.thisModel.get("moResolution");
        this.moScale = (Float)this.thisModel.get("moScale");
        this.moColorPos = (Integer)this.thisModel.get("moColorPos");
        this.moColorNeg = (Integer)this.thisModel.get("moColorNeg");
        this.moNumber = (Integer)this.thisModel.get("moNumber");
        Object object = this.thisModel.get("moIsPositiveOnly");
        this.moIsPositiveOnly = object != null && (Boolean)object != false;
        return true;
    }

    private void setOrbital(int n) {
        super.setProperty("reset", this.strID, null);
        if (this.moDebug) {
            super.setProperty("debug", Boolean.TRUE, null);
        }
        this.getSettings(this.strID);
        if (this.moScale != null) {
            super.setProperty("scale", this.moScale, null);
        }
        if (this.moResolution != null) {
            super.setProperty("resolution", this.moResolution, null);
        }
        if (this.moPlane != null) {
            super.setProperty("plane", this.moPlane, null);
            if (this.moCutoff != null) {
                super.setProperty("red", new Float(-this.moCutoff.floatValue()), null);
                super.setProperty("blue", this.moCutoff, null);
            }
        } else {
            if (this.moCutoff != null) {
                super.setProperty(this.moIsPositiveOnly ? "cutoffPositive" : "cutoff", this.moCutoff, null);
            }
            if (this.moColorNeg != null) {
                super.setProperty("colorRGB", this.moColorNeg, null);
            }
            if (this.moColorPos != null) {
                super.setProperty("colorRGB", this.moColorPos, null);
            }
        }
        super.setProperty("title", this.moTitleFormat, null);
        super.setProperty("fileName", this.viewer.getFileName(), null);
        super.setProperty("molecularOrbital", n, null);
        if (this.moPlane != null && this.moColorNeg != null) {
            super.setProperty("colorRGB", this.moColorNeg, null);
        }
        if (this.moPlane != null && this.moColorPos != null) {
            super.setProperty("colorRGB", this.moColorPos, null);
        }
        this.currentMesh.isColorSolid = false;
        if (this.moTranslucentLevel != null) {
            super.setProperty("translucenctLevel", this.moTranslucentLevel, null);
        }
        if (this.moTranslucency != null) {
            super.setProperty("translucency", this.moTranslucency, null);
        }
        super.setProperty("token", this.moFill, null);
        super.setProperty("token", this.moMesh, null);
        super.setProperty("token", this.moDots, null);
        super.setProperty("token", this.moFrontOnly, null);
        this.thisModel.put("mesh", this.currentMesh);
    }

    public String getShapeState() {
        if (this.htModels == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < this.modelCount; ++i) {
            stringBuffer.append(this.getMoState(i));
        }
        return stringBuffer.toString();
    }

    private String getMoState(int n) {
        this.strID = this.getId(n);
        if (!this.getSettings(this.strID)) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (this.modelCount > 1) {
            MolecularOrbital.appendCmd(stringBuffer, "frame " + this.viewer.getModelNumber(n));
        }
        if (this.moCutoff != null) {
            MolecularOrbital.appendCmd(stringBuffer, "mo cutoff " + (this.sg.getIsPositiveOnly() ? "+" : "") + this.moCutoff);
        }
        if (this.moScale != null) {
            MolecularOrbital.appendCmd(stringBuffer, "mo scale " + this.moScale);
        }
        if (this.moResolution != null) {
            MolecularOrbital.appendCmd(stringBuffer, "mo resolution " + this.moResolution);
        }
        if (this.moPlane != null) {
            MolecularOrbital.appendCmd(stringBuffer, "mo plane {" + this.moPlane.x + " " + this.moPlane.y + " " + this.moPlane.z + " " + this.moPlane.w + "}");
        }
        if (this.moTitleFormat != null) {
            MolecularOrbital.appendCmd(stringBuffer, "mo titleFormat " + Escape.escape(this.moTitleFormat));
        }
        if (this.moColorNeg != null) {
            MolecularOrbital.appendCmd(stringBuffer, "mo color " + Escape.escapeColor(this.moColorNeg) + (this.moColorNeg.equals(this.moColorPos) ? "" : " " + Escape.escapeColor(this.moColorPos)));
        }
        MolecularOrbital.appendCmd(stringBuffer, "mo " + this.moNumber);
        if (this.moTranslucency != null) {
            MolecularOrbital.appendCmd(stringBuffer, "mo translucent " + this.moTranslucentLevel);
        }
        MolecularOrbital.appendCmd(stringBuffer, ((IsosurfaceMesh)this.thisModel.get("mesh")).getState("mo"));
        return stringBuffer.toString();
    }

    public void merge(Shape shape) {
        Map<String, Map<String, Object>> map;
        MolecularOrbital molecularOrbital = (MolecularOrbital)shape;
        this.moCutoff = molecularOrbital.moCutoff;
        this.moScale = molecularOrbital.moScale;
        this.moResolution = molecularOrbital.moResolution;
        this.moPlane = molecularOrbital.moPlane;
        this.moTitleFormat = molecularOrbital.moTitleFormat;
        this.moColorNeg = molecularOrbital.moColorNeg;
        this.moColorPos = molecularOrbital.moColorPos;
        this.moTranslucency = molecularOrbital.moTranslucency;
        if (this.htModels == null) {
            this.htModels = new Hashtable<String, Map<String, Object>>();
        }
        if ((map = molecularOrbital.htModels) != null) {
            for (Map.Entry<String, Map<String, Object>> entry : map.entrySet()) {
                String string = entry.getKey();
                this.htModels.put(string, entry.getValue());
            }
        }
        super.merge(shape);
    }
}

