/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.ArrayList;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Map;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.modelset.Atom;
import org.jmol.util.BitSetUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;

class PointGroup {
    private static final int[] axesMaxN = new int[]{15, 0, 0, 1, 3, 1, 10, 0, 1, 0, 6, 0, 1, 0, 0, 0, 15, 10, 6, 6, 10, 0, 1};
    private static final int[] nUnique = new int[]{1, 0, 0, 2, 2, 4, 2, 0, 4, 0, 4, 0, 4, 0, 0, 0, 1, 2, 2, 4, 2, 0, 4};
    private static final int s3 = 3;
    private static final int s4 = 4;
    private static final int s5 = 5;
    private static final int s6 = 6;
    private static final int s8 = 8;
    private static final int s10 = 10;
    private static final int s12 = 12;
    private static final int firstProper = 14;
    private static final int c2 = 16;
    private static final int c3 = 17;
    private static final int c4 = 18;
    private static final int c5 = 19;
    private static final int c6 = 20;
    private static final int c8 = 22;
    private static final int maxAxis = axesMaxN.length;
    private int[] nAxes = new int[maxAxis];
    private Operation[][] axes = new Operation[maxAxis][];
    private int nAtoms;
    private float radius;
    private float distanceTolerance = 0.2f;
    private float linearTolerance = 8.0f;
    private float cosTolerance = 0.99f;
    private String name = "C_1?";
    private Operation principalAxis;
    private Operation principalPlane;
    private final Vector3f vTemp = new Vector3f();
    private int centerAtomIndex = -1;
    private boolean haveInversionCenter;
    private final Point3f center = new Point3f();
    private Point3f[] atoms;
    private int[] elements;
    private static final int ATOM_COUNT_MAX = 100;
    int maxElement = 0;
    int[] eCounts;
    static final int OPERATION_PLANE = 0;
    static final int OPERATION_PROPER_AXIS = 1;
    static final int OPERATION_IMPROPER_AXIS = 2;
    static final int OPERATION_INVERSION_CENTER = 3;
    static final String[] typeNames = new String[]{"plane", "proper axis", "improper axis", "center of inversion"};
    int nOps = 0;
    String drawInfo;
    String drawType = "";
    int drawIndex;
    Map<String, Object> info;
    String textInfo;

    String getName() {
        return this.name;
    }

    static PointGroup getPointGroup(PointGroup pointGroup, Atom[] atomArray, BitSet bitSet, boolean bl, float f, float f2) {
        PointGroup pointGroup2 = new PointGroup();
        return pointGroup2.set(pointGroup, atomArray, bitSet, bl, f, f2) ? pointGroup2 : pointGroup;
    }

    private PointGroup() {
    }

    private boolean isEqual(PointGroup pointGroup) {
        if (pointGroup == null) {
            return false;
        }
        if (this.linearTolerance != pointGroup.linearTolerance || this.distanceTolerance != pointGroup.distanceTolerance || this.nAtoms != pointGroup.nAtoms) {
            return false;
        }
        for (int i = 0; i < this.nAtoms; ++i) {
            if (this.elements[i] == pointGroup.elements[i] && this.atoms[i].distance(pointGroup.atoms[i]) == 0.0f) continue;
            return false;
        }
        return true;
    }

    private boolean set(PointGroup pointGroup, Atom[] atomArray, BitSet bitSet, boolean bl, float f, float f2) {
        int n;
        this.distanceTolerance = f;
        this.linearTolerance = f2;
        this.cosTolerance = (float)Math.cos((double)(f2 / 180.0f) * Math.PI);
        if (!this.getAtomsAndElements(atomArray, bitSet)) {
            Logger.error("Too many atoms for point group calculation");
            this.name = "point group not determined -- atomCount > 100 -- select fewer atoms and try again.";
            return true;
        }
        this.getElementCounts();
        if (bl) {
            Point3f[] point3fArray = new Point3f[this.atoms.length];
            n = this.atoms.length;
            while (--n >= 0) {
                point3fArray[n] = new Point3f(this.atoms[n]);
                Vector3f vector3f = ((Atom)this.atoms[n]).getVibrationVector();
                if (vector3f == null) continue;
                point3fArray[n].add(vector3f);
            }
            this.atoms = point3fArray;
        }
        if (this.isEqual(pointGroup)) {
            return false;
        }
        this.findInversionCenter();
        if (this.isLinear(this.atoms)) {
            this.name = this.haveInversionCenter ? "D(infinity)h" : "C(infinity)v";
            this.vTemp.sub(this.atoms[1], this.atoms[0]);
            this.addAxis(16, this.vTemp);
            this.principalAxis = this.axes[16][0];
            if (this.haveInversionCenter) {
                this.axes[0] = new Operation[1];
                int n2 = this.nAxes[0];
                this.nAxes[0] = n2 + 1;
                Operation operation = new Operation(this.vTemp);
                this.axes[0][n2] = operation;
                this.principalPlane = operation;
            }
            return true;
        }
        this.axes[0] = new Operation[15];
        int n3 = 0;
        this.findCAxes();
        n3 = this.findPlanes();
        this.findAdditionalAxes(n3);
        n = this.getHighestOrder();
        if (this.nAxes[17] > 1) {
            this.name = this.nAxes[19] > 1 ? (this.haveInversionCenter ? "Ih" : "I") : (this.nAxes[18] > 1 ? (this.haveInversionCenter ? "Oh" : "O") : (n3 > 0 ? (this.haveInversionCenter ? "Th" : "Td") : "T"));
        } else if (n < 2) {
            if (n3 == 1) {
                this.name = "Cs";
                return true;
            }
            if (this.haveInversionCenter) {
                this.name = "Ci";
                return true;
            }
            this.name = "C1";
        } else if (n % 2 == 1 && this.nAxes[16] > 0 || n % 2 == 0 && this.nAxes[16] > 1) {
            this.principalAxis = this.setPrincipalAxis(n, n3);
            if (n3 == 0) {
                this.name = n < 14 ? "S" + n : "D" + (n - 14);
            } else {
                n = n < 14 ? (n /= 2) : (n -= 14);
                this.name = n3 == n ? "D" + n + "d" : "D" + n + "h";
            }
        } else if (n3 == 0) {
            this.principalAxis = this.axes[n][0];
            this.name = n < 14 ? "S" + n : "C" + (n - 14);
        } else if (n3 == n - 14) {
            this.principalAxis = this.axes[n][0];
            this.name = "C" + n3 + "v";
        } else {
            this.principalAxis = this.axes[n < 14 ? n + 14 : n][0];
            this.principalPlane = this.axes[0][0];
            n = n < 14 ? (n /= 2) : (n -= 14);
            this.name = "C" + n + "h";
        }
        return true;
    }

    private Operation setPrincipalAxis(int n, int n2) {
        Operation operation = this.setPrincipalPlane(n, n2);
        if (n2 == 0 && n < 14 || this.nAxes[n] == 1) {
            if (n2 > 0 && n < 14) {
                n = 14 + n / 2;
            }
            return this.axes[n][0];
        }
        if (operation == null) {
            return null;
        }
        for (int i = 0; i < this.nAxes[16]; ++i) {
            if (!this.isParallel(operation.normalOrAxis, this.axes[16][i].normalOrAxis)) continue;
            if (i != 0) {
                Operation operation2 = this.axes[16][0];
                this.axes[16][0] = this.axes[16][i];
                this.axes[16][i] = operation2;
            }
            return this.axes[16][0];
        }
        return null;
    }

    private Operation setPrincipalPlane(int n, int n2) {
        if (n2 == 1) {
            this.principalPlane = this.axes[0][0];
            return this.principalPlane;
        }
        if (n2 == 0 || n2 == n - 14) {
            return null;
        }
        for (int i = 0; i < n2; ++i) {
            int n3 = 0;
            for (int j = 0; j < n2; ++j) {
                if (!this.isPerpendicular(this.axes[0][i].normalOrAxis, this.axes[0][j].normalOrAxis) || ++n3 <= 2) continue;
                if (i != 0) {
                    Operation operation = this.axes[0][0];
                    this.axes[0][0] = this.axes[0][i];
                    this.axes[0][i] = operation;
                }
                this.principalPlane = this.axes[0][0];
                return this.principalPlane;
            }
        }
        return null;
    }

    private boolean getAtomsAndElements(Atom[] atomArray, BitSet bitSet) {
        int n = BitSetUtil.cardinalityOf(bitSet);
        if (n > 100) {
            return false;
        }
        this.atoms = new Point3f[n];
        Point3f[] point3fArray = this.atoms;
        this.elements = new int[n];
        if (n == 0) {
            return true;
        }
        this.nAtoms = 0;
        int n2 = bitSet.nextSetBit(0);
        while (n2 >= 0) {
            point3fArray[this.nAtoms] = new Point3f(atomArray[n2]);
            int n3 = 1 + Math.max(3, atomArray[n2].getCovalentBondCount());
            this.elements[this.nAtoms] = atomArray[n2].getElementNumber() * n3;
            this.center.add(point3fArray[this.nAtoms++]);
            n2 = bitSet.nextSetBit(n2 + 1);
        }
        this.center.scale(1.0f / (float)this.nAtoms);
        n2 = this.nAtoms;
        while (--n2 >= 0) {
            float f = this.center.distance(point3fArray[n2]);
            if (f < this.distanceTolerance) {
                this.centerAtomIndex = n2;
            }
            this.radius = Math.max(this.radius, f);
        }
        return true;
    }

    private void findInversionCenter() {
        this.haveInversionCenter = this.checkOperation(null, this.center, -1);
        if (this.haveInversionCenter) {
            this.axes[1] = new Operation[1];
            this.axes[1][0] = new Operation();
        }
    }

    private boolean checkOperation(Quaternion quaternion, Point3f point3f, int n) {
        Point3f point3f2 = new Point3f();
        int n2 = 0;
        boolean bl = n < 14;
        int n3 = this.atoms.length;
        block0: while (--n3 >= 0 && n2 < this.atoms.length) {
            if (n3 == this.centerAtomIndex) {
                ++n2;
                continue;
            }
            Point3f point3f3 = this.atoms[n3];
            int n4 = this.elements[n3];
            if (quaternion != null) {
                point3f2.set(point3f3);
                point3f2.sub(point3f);
                quaternion.transform(point3f2, point3f2);
                point3f2.add(point3f);
            } else {
                point3f2.set(point3f3);
            }
            if (bl) {
                this.vTemp.sub(point3f, point3f2);
                point3f2.scaleAdd(2.0f, this.vTemp, point3f2);
            }
            if ((quaternion != null || bl) && point3f2.distance(point3f3) < this.distanceTolerance) {
                ++n2;
                continue;
            }
            int n5 = this.atoms.length;
            while (--n5 >= 0) {
                Point3f point3f4;
                if (n5 == n3 || this.elements[n5] != n4 || !(point3f2.distance(point3f4 = this.atoms[n5]) < this.distanceTolerance)) continue;
                ++n2;
                continue block0;
            }
        }
        return n2 == this.atoms.length;
    }

    private boolean isLinear(Point3f[] point3fArray) {
        Vector3f vector3f = null;
        if (point3fArray.length < 2) {
            return false;
        }
        int n = point3fArray.length;
        while (--n >= 0) {
            if (n == this.centerAtomIndex) continue;
            if (vector3f == null) {
                vector3f = new Vector3f();
                vector3f.sub(point3fArray[n], this.center);
                vector3f.normalize();
                this.vTemp.set(vector3f);
                continue;
            }
            this.vTemp.sub(point3fArray[n], this.center);
            this.vTemp.normalize();
            if (this.isParallel(vector3f, this.vTemp)) continue;
            return false;
        }
        return true;
    }

    private boolean isParallel(Vector3f vector3f, Vector3f vector3f2) {
        return Math.abs(vector3f.dot(vector3f2)) >= this.cosTolerance;
    }

    private boolean isPerpendicular(Vector3f vector3f, Vector3f vector3f2) {
        return Math.abs(vector3f.dot(vector3f2)) <= 1.0f - this.cosTolerance;
    }

    private void getElementCounts() {
        int n = this.atoms.length;
        while (--n >= 0) {
            int n2 = this.elements[n];
            if (n2 <= this.maxElement) continue;
            this.maxElement = n2;
        }
        this.eCounts = new int[++this.maxElement];
        n = this.atoms.length;
        while (--n >= 0) {
            int n3 = this.elements[n];
            this.eCounts[n3] = this.eCounts[n3] + 1;
        }
    }

    private int findCAxes() {
        int n;
        int n2;
        int n3;
        int n4;
        int n5;
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        Point3f point3f = new Point3f();
        int n6 = this.atoms.length;
        while (--n6 >= 0) {
            if (n6 == this.centerAtomIndex) continue;
            Point3f point3f2 = this.atoms[n6];
            n5 = this.elements[n6];
            n4 = this.atoms.length;
            while (--n4 > n6) {
                float f;
                boolean bl;
                Point3f point3f3 = this.atoms[n4];
                if (this.elements[n4] != n5) continue;
                point3f.add(point3f2, point3f3);
                point3f.scale(0.5f);
                vector3f.sub(point3f2, this.center);
                vector3f2.sub(point3f3, this.center);
                vector3f.normalize();
                vector3f2.normalize();
                if (this.isParallel(vector3f, vector3f2)) {
                    this.getAllAxes(vector3f);
                    continue;
                }
                if (this.nAxes[16] < axesMaxN[16]) {
                    vector3f3.set(point3f);
                    this.getAllAxes(vector3f3);
                }
                if (!(bl = (f = (float)(Math.PI * 2 / (double)vector3f.angle(vector3f2))) - (float)(n3 = (int)(f + 0.01f)) <= 0.02f) || (n3 += 14) >= maxAxis || this.nAxes[n3] >= axesMaxN[n3]) continue;
                vector3f3.cross(vector3f, vector3f2);
                this.checkAxisOrder(n3, vector3f3, this.center);
            }
        }
        Vector3f[] vector3fArray = new Vector3f[this.nAxes[16] * 2];
        for (n2 = 0; n2 < vector3fArray.length; ++n2) {
            vector3fArray[n2] = new Vector3f();
        }
        n2 = 0;
        for (n5 = 0; n5 < this.nAxes[16]; ++n5) {
            vector3fArray[n2++].set(this.axes[16][n5].normalOrAxis);
            vector3fArray[n2].set(this.axes[16][n5].normalOrAxis);
            vector3fArray[n2++].scale(-1.0f);
        }
        n5 = vector3fArray.length;
        while (--n5 >= 2) {
            n4 = n5;
            while (--n4 >= 1) {
                int n7 = n4;
                while (--n7 >= 0) {
                    vector3f3.set(vector3fArray[n5]);
                    vector3f3.add(vector3fArray[n4]);
                    vector3f3.add(vector3fArray[n7]);
                    if ((double)vector3f3.length() < 1.0) continue;
                    this.checkAxisOrder(17, vector3f3, this.center);
                }
            }
        }
        n5 = Integer.MAX_VALUE;
        n4 = -1;
        for (n = 0; n < this.maxElement; ++n) {
            if (this.eCounts[n] >= n5 || this.eCounts[n] <= 2) continue;
            n5 = this.eCounts[n];
            n4 = n;
        }
        block8: for (n = 0; n < this.atoms.length - 2; ++n) {
            if (this.elements[n] != n4) continue;
            for (int i = n + 1; i < this.atoms.length - 1; ++i) {
                if (this.elements[i] != n4) continue;
                for (n3 = i + 1; n3 < this.atoms.length; ++n3) {
                    if (this.elements[n3] != n4) continue;
                    vector3f.sub(this.atoms[n], this.atoms[i]);
                    vector3f2.sub(this.atoms[n], this.atoms[n3]);
                    vector3f.normalize();
                    vector3f2.normalize();
                    vector3f3.cross(vector3f, vector3f2);
                    this.getAllAxes(vector3f3);
                    point3f.set(this.atoms[n]);
                    point3f.add(this.atoms[i]);
                    point3f.add(this.atoms[n3]);
                    vector3f.set(point3f);
                    vector3f.normalize();
                    if (!this.isParallel(vector3f, vector3f3)) {
                        this.getAllAxes(vector3f);
                    }
                    if (this.nAxes[19] == axesMaxN[19]) break block8;
                }
            }
        }
        vector3fArray = new Vector3f[this.maxElement];
        n = this.atoms.length;
        while (--n >= 0) {
            int n8 = this.elements[n];
            if (vector3fArray[n8] == null) {
                vector3fArray[n8] = new Vector3f();
            } else if (this.haveInversionCenter) continue;
            vector3fArray[n8].add(this.atoms[n]);
        }
        if (!this.haveInversionCenter) {
            for (n = 0; n < this.maxElement; ++n) {
                if (vector3fArray[n] == null) continue;
                vector3fArray[n].scale(1.0f / (float)this.eCounts[n]);
            }
        }
        for (n = 0; n < this.maxElement; ++n) {
            if (vector3fArray[n] == null) continue;
            for (int i = 0; i < this.maxElement; ++i) {
                if (n == i || vector3fArray[i] == null) continue;
                if (this.haveInversionCenter) {
                    vector3f.cross(vector3fArray[n], vector3fArray[i]);
                } else {
                    vector3f.set(vector3fArray[n]);
                    vector3f.sub(vector3fArray[i]);
                }
                this.checkAxisOrder(16, vector3f, this.center);
            }
        }
        return this.getHighestOrder();
    }

    private void getAllAxes(Vector3f vector3f) {
        for (int i = 16; i < maxAxis; ++i) {
            if (this.nAxes[i] >= axesMaxN[i]) continue;
            this.checkAxisOrder(i, vector3f, this.center);
        }
    }

    private int getHighestOrder() {
        int n = 0;
        n = 14;
        while (--n > 1 && this.nAxes[n] == 0) {
        }
        if (n > 1) {
            return n + 14 < maxAxis && this.nAxes[n + 14] > 0 ? n + 14 : n;
        }
        n = maxAxis;
        while (--n > 1 && this.nAxes[n] == 0) {
        }
        return n;
    }

    private boolean checkAxisOrder(int n, Vector3f vector3f, Point3f point3f) {
        switch (n) {
            case 22: {
                if (this.nAxes[17] > 0) {
                    return false;
                }
            }
            case 18: 
            case 20: {
                if (this.nAxes[19] <= 0) break;
                return false;
            }
            case 17: {
                if (this.nAxes[22] <= 0) break;
                return false;
            }
            case 19: {
                if (this.nAxes[18] <= 0 && this.nAxes[20] <= 0 && this.nAxes[22] <= 0) break;
                return false;
            }
        }
        vector3f.normalize();
        if (this.haveAxis(n, vector3f)) {
            return false;
        }
        Quaternion quaternion = new Quaternion(vector3f, (n < 14 ? 180 : 0) + 360 / (n % 14));
        if (!this.checkOperation(quaternion, point3f, n)) {
            return false;
        }
        this.addAxis(n, vector3f);
        switch (n) {
            case 16: {
                this.checkAxisOrder(4, vector3f, point3f);
                break;
            }
            case 17: {
                this.checkAxisOrder(3, vector3f, point3f);
                if (!this.haveInversionCenter) break;
                this.addAxis(6, vector3f);
                break;
            }
            case 18: {
                this.addAxis(16, vector3f);
                this.checkAxisOrder(4, vector3f, point3f);
                this.checkAxisOrder(8, vector3f, point3f);
                break;
            }
            case 19: {
                this.checkAxisOrder(5, vector3f, point3f);
                if (!this.haveInversionCenter) break;
                this.addAxis(10, vector3f);
                break;
            }
            case 20: {
                this.addAxis(16, vector3f);
                this.addAxis(17, vector3f);
                this.checkAxisOrder(3, vector3f, point3f);
                this.checkAxisOrder(6, vector3f, point3f);
                this.checkAxisOrder(12, vector3f, point3f);
                break;
            }
            case 22: {
                this.addAxis(16, vector3f);
                this.addAxis(18, vector3f);
            }
        }
        return true;
    }

    private void addAxis(int n, Vector3f vector3f) {
        if (this.haveAxis(n, vector3f)) {
            return;
        }
        if (this.axes[n] == null) {
            this.axes[n] = new Operation[axesMaxN[n]];
        }
        int n2 = n;
        int n3 = this.nAxes[n2];
        this.nAxes[n2] = n3 + 1;
        this.axes[n][n3] = new Operation(vector3f, n);
    }

    private boolean haveAxis(int n, Vector3f vector3f) {
        if (this.nAxes[n] == axesMaxN[n]) {
            return true;
        }
        if (this.nAxes[n] > 0) {
            int n2 = this.nAxes[n];
            while (--n2 >= 0) {
                if (!this.isParallel(vector3f, this.axes[n][n2].normalOrAxis)) continue;
                return true;
            }
        }
        return false;
    }

    private int findPlanes() {
        Point3f point3f = new Point3f();
        Vector3f vector3f = new Vector3f();
        Vector3f vector3f2 = new Vector3f();
        Vector3f vector3f3 = new Vector3f();
        int n = 0;
        boolean bl = this.getHighestOrder() > 1;
        int n2 = this.atoms.length;
        while (--n2 >= 0) {
            if (n2 == this.centerAtomIndex) continue;
            Point3f point3f2 = this.atoms[n2];
            int n3 = this.elements[n2];
            int n4 = this.atoms.length;
            while (--n4 > n2) {
                if (bl && this.elements[n4] != n3) continue;
                Point3f point3f3 = this.atoms[n4];
                point3f.add(point3f2, point3f3);
                point3f.scale(0.5f);
                vector3f.sub(point3f2, this.center);
                vector3f2.sub(point3f3, this.center);
                if (!this.isParallel(vector3f, vector3f2)) {
                    vector3f3.cross(vector3f, vector3f2);
                    vector3f3.normalize();
                    n = this.getPlane(vector3f3);
                }
                vector3f3.set(point3f3);
                vector3f3.sub(point3f2);
                vector3f3.normalize();
                n = this.getPlane(vector3f3);
                if (n != axesMaxN[0]) continue;
                return n;
            }
        }
        if (bl) {
            for (n2 = 16; n2 < maxAxis; ++n2) {
                for (int i = 0; i < this.nAxes[n2]; ++i) {
                    n = this.getPlane(this.axes[n2][i].normalOrAxis);
                }
            }
        }
        return n;
    }

    private int getPlane(Vector3f vector3f) {
        if (!this.haveAxis(0, vector3f) && this.checkOperation(new Quaternion(vector3f, 180.0f), this.center, -1)) {
            int n = this.nAxes[0];
            this.nAxes[0] = n + 1;
            this.axes[0][n] = new Operation(vector3f);
        }
        return this.nAxes[0];
    }

    private void findAdditionalAxes(int n) {
        Operation[] operationArray = this.axes[0];
        int n2 = 0;
        if (n > 1 && (n2 = n + 14) < maxAxis && this.nAxes[n2] == 0) {
            this.vTemp.cross(operationArray[0].normalOrAxis, operationArray[1].normalOrAxis);
            if (!this.checkAxisOrder(n2, this.vTemp, this.center) && n > 2) {
                this.vTemp.cross(operationArray[1].normalOrAxis, operationArray[2].normalOrAxis);
                this.checkAxisOrder(n2 - 1, this.vTemp, this.center);
            }
        }
        if (this.nAxes[16] == 0 && n > 2) {
            for (int i = 0; i < n - 1; ++i) {
                for (int j = i + 1; j < n; ++j) {
                    this.vTemp.add(operationArray[1].normalOrAxis, operationArray[2].normalOrAxis);
                    this.checkAxisOrder(16, this.vTemp, this.center);
                }
            }
        }
    }

    Object getInfo(int n, boolean bl, boolean bl2, String string, int n2, float f) {
        int n3;
        this.info = bl2 ? new Hashtable() : null;
        Vector3f vector3f = new Vector3f();
        if (f == 0.0f) {
            f = 1.0f;
        }
        int[][] nArray = new int[4][2];
        for (int i = 1; i < maxAxis; ++i) {
            n3 = this.nAxes[i];
            while (--n3 >= 0) {
                int[] nArray2 = nArray[this.axes[i][n3].type];
                nArray2[0] = nArray2[0] + 1;
            }
        }
        StringBuffer stringBuffer = new StringBuffer("# " + this.nAtoms + " atoms\n");
        if (bl) {
            Operation operation;
            String string2;
            int n4;
            n3 = string != null && string.length() > 0 ? 1 : 0;
            string = n3 != 0 ? string : "";
            this.drawType = string;
            this.drawIndex = n2;
            boolean bl3 = string.equalsIgnoreCase("Cn");
            boolean bl4 = string.equalsIgnoreCase("Sn");
            stringBuffer.append("set perspectivedepth off;\n");
            String string3 = "_" + n + "_";
            if (n3 == 0) {
                stringBuffer.append("draw delete pg0" + string3 + "*;draw delete pgva" + string3 + "*;draw delete pgvp" + string3 + "*;");
            }
            if (n3 == 0 || string.equalsIgnoreCase("Ci")) {
                stringBuffer.append("draw pg0").append(string3).append(this.haveInversionCenter ? "inv " : " ").append(Escape.escape(this.center) + (this.haveInversionCenter ? "\"i\";\n" : ";\n"));
            }
            float f2 = 0.1f;
            for (n4 = 2; n4 < maxAxis; ++n4) {
                if (n4 == 14) {
                    f2 = 0.1f;
                }
                if (this.nAxes[n4] == 0) continue;
                string2 = this.axes[n4][0].getLabel();
                float f3 = f * this.radius + (f2 += 0.25f);
                if (n3 != 0 && !string.equalsIgnoreCase(string2) && (!bl3 || n4 < 14) && (!bl4 || n4 >= 14)) continue;
                for (int i = 0; i < this.nAxes[n4]; ++i) {
                    if (n2 > 0 && i + 1 != n2) continue;
                    operation = this.axes[n4][i];
                    vector3f.set(operation.normalOrAxis);
                    vector3f.add(this.center);
                    if (operation.type == 2) {
                        f3 = -f3;
                    }
                    stringBuffer.append("draw pgva").append(string3).append(string2).append("_").append(i + 1).append(" width 0.05 scale " + f3 + " ").append(Escape.escape(vector3f));
                    vector3f.scaleAdd(-2.0f, operation.normalOrAxis, vector3f);
                    boolean bl5 = this.principalAxis != null && operation.index == this.principalAxis.index;
                    stringBuffer.append(Escape.escape(vector3f)).append("\"" + string2 + (bl5 ? "*" : "") + "\" color ").append(bl5 ? "red" : (operation.type == 2 ? "blue" : "yellow")).append(";\n");
                }
            }
            if (n3 == 0 || string.equalsIgnoreCase("Cs")) {
                for (n4 = 0; n4 < this.nAxes[0]; ++n4) {
                    if (n2 > 0 && n4 + 1 != n2) continue;
                    operation = this.axes[0][n4];
                    stringBuffer.append("draw pgvp").append(string3).append(n4 + 1).append("disk scale " + f * this.radius * 2.0f + " CIRCLE PLANE ").append(Escape.escape(this.center));
                    vector3f.set(operation.normalOrAxis);
                    vector3f.add(this.center);
                    stringBuffer.append(Escape.escape(vector3f)).append(" color translucent yellow;\n");
                    vector3f.set(operation.normalOrAxis);
                    vector3f.add(this.center);
                    stringBuffer.append("draw pgvp").append(string3).append(n4 + 1).append("ring width 0.05 scale " + f * this.radius * 2.0f + " arc ").append(Escape.escape(vector3f));
                    vector3f.scaleAdd(-2.0f, operation.normalOrAxis, vector3f);
                    stringBuffer.append(Escape.escape(vector3f));
                    vector3f.x = (float)((double)vector3f.x + 0.011);
                    vector3f.y = (float)((double)vector3f.y + 0.012);
                    vector3f.z = (float)((double)vector3f.z + 0.013);
                    stringBuffer.append(Escape.escape(vector3f)).append("{0 360 0.5} color ").append(this.principalPlane != null && operation.index == this.principalPlane.index ? "red" : "blue").append(";\n");
                }
            }
            stringBuffer.append("# name=" + this.name);
            stringBuffer.append(", nCi=" + (this.haveInversionCenter ? 1 : 0));
            stringBuffer.append(", nCs=" + this.nAxes[0]);
            stringBuffer.append(", nCn=" + nArray[1][0]);
            stringBuffer.append(", nSn=" + nArray[2][0]);
            stringBuffer.append(": ");
            n4 = maxAxis;
            while (--n4 >= 2) {
                if (this.nAxes[n4] <= 0) continue;
                string2 = " n" + (n4 < 14 ? "S" : "C") + n4 % 14;
                stringBuffer.append(string2 + "=" + this.nAxes[n4]);
            }
            stringBuffer.append(";\n");
            this.drawInfo = stringBuffer.toString();
            return this.drawInfo;
        }
        n3 = 0;
        int n5 = 1;
        int n6 = maxAxis;
        while (--n6 >= 0) {
            if (this.nAxes[n6] <= 0) continue;
            n3 = nUnique[n6];
            String string4 = this.axes[n6][0].getLabel();
            if (this.info != null) {
                this.info.put("n" + string4, this.nAxes[n6]);
            }
            stringBuffer.append("\n\n" + this.name + "\tn" + string4 + "\t" + this.nAxes[n6] + "\t" + n3);
            n5 += (n3 *= this.nAxes[n6]);
            int[] nArray3 = nArray[this.axes[n6][0].type];
            nArray3[1] = nArray3[1] + n3;
            ArrayList<Vector3f> arrayList = this.info == null ? null : new ArrayList<Vector3f>();
            for (int i = 0; i < this.nAxes[n6]; ++i) {
                if (arrayList != null) {
                    arrayList.add(this.axes[n6][i].normalOrAxis);
                }
                stringBuffer.append("\n" + this.name + "\t" + string4 + "_" + (i + 1) + "\t" + this.axes[n6][i].normalOrAxis);
            }
            if (this.info == null) continue;
            this.info.put(string4, arrayList);
        }
        if (this.haveInversionCenter) {
            ++n5;
            if (this.info == null) {
                stringBuffer.append("\n\n" + this.name + "\tCi\t" + Escape.escape(this.center));
            } else {
                this.info.put("Ci", this.center);
            }
        }
        if (this.info == null) {
            stringBuffer.append("\n");
            stringBuffer.append("\n" + this.name + "\ttype\tnType\tnUnique");
            stringBuffer.append("\n" + this.name + "\tE\t  1\t  1");
            n3 = this.haveInversionCenter ? 1 : 0;
            stringBuffer.append("\n" + this.name + "\tCi\t  " + n3 + "\t  " + n3);
            stringBuffer.append("\n" + this.name + "\tCs\t");
            TextFormat.rFill(stringBuffer, "    ", this.nAxes[0] + "\t");
            TextFormat.rFill(stringBuffer, "    ", this.nAxes[0] + "\n");
            stringBuffer.append(this.name + "\tCn\t");
            TextFormat.rFill(stringBuffer, "    ", nArray[1][0] + "\t");
            TextFormat.rFill(stringBuffer, "    ", nArray[1][1] + "\n");
            stringBuffer.append(this.name + "\tSn\t");
            TextFormat.rFill(stringBuffer, "    ", nArray[2][0] + "\t");
            TextFormat.rFill(stringBuffer, "    ", nArray[2][1] + "\n");
            stringBuffer.append(this.name + "\t\tTOTAL\t");
            TextFormat.rFill(stringBuffer, "    ", n5 + "\n");
            this.textInfo = stringBuffer.toString();
            return this.textInfo;
        }
        this.info.put("name", this.name);
        this.info.put("nAtoms", new Integer(this.nAtoms));
        this.info.put("nTotal", new Integer(n5));
        this.info.put("nCi", new Integer(this.haveInversionCenter ? 1 : 0));
        this.info.put("nCs", new Integer(this.nAxes[0]));
        this.info.put("nCn", new Integer(nArray[1][0]));
        this.info.put("nSn", new Integer(nArray[2][0]));
        this.info.put("distanceTolerance", new Float(this.distanceTolerance));
        this.info.put("linearTolerance", new Float(this.linearTolerance));
        this.info.put("detail", stringBuffer.toString().replace('\n', ';'));
        if (this.principalAxis != null && this.principalAxis.index > 0) {
            this.info.put("principalAxis", this.principalAxis.normalOrAxis);
        }
        if (this.principalPlane != null && this.principalPlane.index > 0) {
            this.info.put("principalPlane", this.principalPlane.normalOrAxis);
        }
        return this.info;
    }

    boolean isDrawType(String string, int n) {
        return this.drawInfo != null && this.drawType.equals(string == null ? "" : string) && this.drawIndex == n;
    }

    private class Operation {
        int type;
        int order;
        int index;
        Vector3f normalOrAxis;

        Operation() {
            this.index = ++PointGroup.this.nOps;
            this.type = 3;
            this.order = 1;
            if (Logger.debugging) {
                Logger.info("new operation -- " + typeNames[this.type]);
            }
        }

        Operation(Vector3f vector3f, int n) {
            this.index = ++PointGroup.this.nOps;
            this.type = n < 14 ? 2 : 1;
            this.order = n % 14;
            this.normalOrAxis = new Quaternion(vector3f, 180.0f).getNormal();
            if (Logger.debugging) {
                Logger.info("new operation -- " + (this.order == n ? "S" : "C") + this.order + " " + this.normalOrAxis);
            }
        }

        Operation(Vector3f vector3f) {
            if (vector3f == null) {
                return;
            }
            this.index = ++PointGroup.this.nOps;
            this.type = 0;
            this.normalOrAxis = new Quaternion(vector3f, 180.0f).getNormal();
            if (Logger.debugging) {
                Logger.info("new operation -- plane " + this.normalOrAxis);
            }
        }

        String getLabel() {
            switch (this.type) {
                case 0: {
                    return "Cs";
                }
                case 2: {
                    return "S" + this.order;
                }
            }
            return "C" + this.order;
        }
    }
}

