/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.symmetry;

import java.util.BitSet;
import java.util.Map;
import javax.vecmath.Matrix3f;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.api.SymmetryInterface;
import org.jmol.modelset.Atom;
import org.jmol.symmetry.PointGroup;
import org.jmol.symmetry.SpaceGroup;
import org.jmol.symmetry.SymmetryInfo;
import org.jmol.symmetry.SymmetryOperation;
import org.jmol.symmetry.UnitCell;
import org.jmol.util.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Symmetry
implements SymmetryInterface {
    private PointGroup pointGroup;
    private SpaceGroup spaceGroup;
    private SymmetryInfo symmetryInfo;
    private UnitCell unitCell;

    @Override
    public SymmetryInterface setPointGroup(SymmetryInterface symmetryInterface, Atom[] atomArray, BitSet bitSet, boolean bl, float f, float f2) {
        this.pointGroup = PointGroup.getPointGroup(symmetryInterface == null ? null : ((Symmetry)symmetryInterface).pointGroup, atomArray, bitSet, bl, f, f2);
        return this;
    }

    @Override
    public String getPointGroupName() {
        return this.pointGroup.getName();
    }

    @Override
    public Object getPointGroupInfo(int n, boolean bl, boolean bl2, String string, int n2, float f) {
        if (!bl && !bl2 && this.pointGroup.textInfo != null) {
            return this.pointGroup.textInfo;
        }
        if (bl && this.pointGroup.isDrawType(string, n2)) {
            return this.pointGroup.drawInfo;
        }
        if (bl2 && this.pointGroup.info != null) {
            return this.pointGroup.info;
        }
        return this.pointGroup.getInfo(n, bl, bl2, string, n2, f);
    }

    @Override
    public void setSpaceGroup(boolean bl) {
        if (this.spaceGroup == null) {
            this.spaceGroup = new SpaceGroup(bl);
        }
    }

    @Override
    public int addSpaceGroupOperation(String string, int n) {
        return this.spaceGroup.addSymmetry(string, n);
    }

    @Override
    public void addSpaceGroupOperation(Matrix4f matrix4f) {
        this.spaceGroup.addSymmetry("=" + SymmetryOperation.getXYZFromMatrix(matrix4f, false, false, false), 0);
    }

    @Override
    public void setLattice(int n) {
        this.spaceGroup.setLattice(n);
    }

    @Override
    public String getSpaceGroupName() {
        return this.symmetryInfo != null ? this.symmetryInfo.spaceGroup : (this.spaceGroup != null ? this.spaceGroup.getName() : "");
    }

    @Override
    public Object getSpaceGroup() {
        return this.spaceGroup;
    }

    @Override
    public void setSpaceGroup(SymmetryInterface symmetryInterface) {
        this.spaceGroup = symmetryInterface == null ? null : (SpaceGroup)symmetryInterface.getSpaceGroup();
    }

    @Override
    public boolean createSpaceGroup(int n, String string, float[] fArray) {
        this.spaceGroup = SpaceGroup.createSpaceGroup(n, string, fArray);
        if (this.spaceGroup != null && Logger.debugging) {
            Logger.debug("using generated space group " + this.spaceGroup.dumpInfo(null));
        }
        return this.spaceGroup != null;
    }

    @Override
    public boolean haveSpaceGroup() {
        return this.spaceGroup != null;
    }

    @Override
    public String getSpaceGroupInfo(String string, SymmetryInterface symmetryInterface) {
        return SpaceGroup.getInfo(string, symmetryInterface);
    }

    @Override
    public Object getLatticeDesignation() {
        return this.spaceGroup.getLatticeDesignation();
    }

    @Override
    public void setFinalOperations(Point3f[] point3fArray, int n, int n2, boolean bl) {
        this.spaceGroup.setFinalOperations(point3fArray, n, n2, bl);
    }

    @Override
    public int getSpaceGroupOperationCount() {
        return this.spaceGroup.finalOperations.length;
    }

    @Override
    public Matrix4f getSpaceGroupOperation(int n) {
        return this.spaceGroup.finalOperations[n];
    }

    @Override
    public String getSpaceGroupXyz(int n, boolean bl) {
        return this.spaceGroup.finalOperations[n].getXyz(bl);
    }

    @Override
    public void newSpaceGroupPoint(int n, Point3f point3f, Point3f point3f2, int n2, int n3, int n4) {
        if (this.spaceGroup.finalOperations == null) {
            if (!this.spaceGroup.operations[n].isFinalized) {
                this.spaceGroup.operations[n].doFinalize();
            }
            this.spaceGroup.operations[n].newPoint(point3f, point3f2, n2, n3, n4);
            return;
        }
        this.spaceGroup.finalOperations[n].newPoint(point3f, point3f2, n2, n3, n4);
    }

    @Override
    public Object rotateEllipsoid(int n, Point3f point3f, Vector3f[] vector3fArray, Point3f point3f2, Point3f point3f3) {
        return this.spaceGroup.finalOperations[n].rotateEllipsoid(point3f, vector3fArray, this.unitCell, point3f2, point3f3);
    }

    @Override
    public boolean haveUnitCell() {
        return this.unitCell != null;
    }

    public String getUnitsymmetryInfo() {
        return this.unitCell == null ? "no unit cell information" : this.unitCell.dumpInfo(false);
    }

    @Override
    public void setUnitCell(float[] fArray) {
        this.unitCell = new UnitCell(fArray);
    }

    @Override
    public void setUnitCellOrientation(Matrix3f matrix3f) {
        if (this.unitCell != null) {
            this.unitCell.setOrientation(matrix3f);
        }
    }

    @Override
    public void toCartesian(Point3f point3f, boolean bl) {
        if (this.unitCell == null) {
            return;
        }
        this.unitCell.toCartesian(point3f, bl);
    }

    @Override
    public Object[] getEllipsoid(float[] fArray) {
        return this.unitCell.getEllipsoid(fArray);
    }

    @Override
    public Point3f ijkToPoint3f(int n) {
        return UnitCell.ijkToPoint3f(n);
    }

    @Override
    public void toFractional(Point3f point3f, boolean bl) {
        if (this.unitCell != null) {
            this.unitCell.toFractional(point3f, bl);
        }
    }

    @Override
    public Point3f[] getUnitCellVertices() {
        return this.unitCell.getVertices();
    }

    @Override
    public Point3f getCartesianOffset() {
        return this.unitCell.getCartesianOffset();
    }

    @Override
    public float[] getNotionalUnitCell() {
        return this.unitCell == null ? null : this.unitCell.getNotionalUnitCell();
    }

    @Override
    public void toUnitCell(Point3f point3f, Point3f point3f2) {
        if (this.unitCell != null) {
            this.unitCell.toUnitCell(point3f, point3f2);
        }
    }

    @Override
    public void setUnitCellOffset(Point3f point3f) {
        this.unitCell.setOffset(point3f);
    }

    @Override
    public void setOffset(int n) {
        this.unitCell.setOffset(n);
    }

    @Override
    public Point3f getFractionalOffset() {
        return this.unitCell.getFractionalOffset();
    }

    @Override
    public Point3f[] getCanonicalCopy(float f) {
        return this.unitCell.getCanonicalCopy(f);
    }

    public float getUnitsymmetryInfo(int n) {
        return this.unitCell.getInfo(n);
    }

    @Override
    public int getModelIndex() {
        return this.symmetryInfo.modelIndex;
    }

    @Override
    public void setModelIndex(int n) {
        this.symmetryInfo.modelIndex = n;
    }

    @Override
    public boolean getCoordinatesAreFractional() {
        return this.symmetryInfo.coordinatesAreFractional;
    }

    @Override
    public int[] getCellRange() {
        return this.symmetryInfo.cellRange;
    }

    @Override
    public String getSymmetryInfoString() {
        return this.symmetryInfo.symmetryInfoString;
    }

    @Override
    public String[] getSymmetryOperations() {
        return this.symmetryInfo.symmetryOperations;
    }

    @Override
    public boolean isPeriodic() {
        return this.symmetryInfo.isPeriodic();
    }

    @Override
    public void setSymmetryInfo(int n, Map<String, Object> map) {
        Matrix3f matrix3f;
        this.symmetryInfo = new SymmetryInfo();
        float[] fArray = this.symmetryInfo.setSymmetryInfo(n, map);
        if (fArray == null) {
            return;
        }
        this.setUnitCell(fArray);
        this.setUnitCellOffset((Point3f)map.get("unitCellOffset"));
        if (map.containsKey("jmolData")) {
            this.setUnitCellAllFractionalRelative(true);
        }
        if ((matrix3f = (Matrix3f)map.get("matUnitCellOrientation")) != null) {
            this.setUnitCellOrientation(matrix3f);
        }
        if (Logger.debugging) {
            Logger.debug("symmetryInfos[" + n + "]:\n" + this.unitCell.dumpInfo(true));
        }
    }

    @Override
    public float getUnitCellInfo(int n) {
        return this.unitCell.getInfo(n);
    }

    @Override
    public String getUnitCellInfo() {
        return this.unitCell == null ? "no unit cell information" : this.unitCell.dumpInfo(false);
    }

    @Override
    public Object[] getSymmetryOperationDescription(int n, SymmetryInterface symmetryInterface, Point3f point3f, Point3f point3f2, String string) {
        return this.spaceGroup.operations[n].getDescription(symmetryInterface, point3f, point3f2, string);
    }

    @Override
    public boolean isSlab() {
        return this.unitCell == null ? false : this.unitCell.isSlab();
    }

    @Override
    public boolean isPolymer() {
        return this.unitCell == null ? false : this.unitCell.isPolymer();
    }

    @Override
    public void setMinMaxLatticeParameters(Point3i point3i, Point3i point3i2) {
        if (this.unitCell != null) {
            this.unitCell.setMinMaxLatticeParameters(point3i, point3i2);
        }
    }

    @Override
    public void setUnitCellAllFractionalRelative(boolean bl) {
        if (this.unitCell != null) {
            this.unitCell.setAllFractionalRelative(bl);
        }
    }
}

