/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.vecmath.Vector3f;
import org.jmol.util.Elements;
import org.jmol.util.Logger;

public final class JmolConstants {
    public static final String copyright = "(C) 2009 Jmol Development";
    public static final String version;
    public static final String cvsDate = "$Date: 2010-09-17 21:12:30 +0100 (Fri, 17 Sep 2010) $";
    public static final String date;
    public static final boolean officialRelease = false;
    public static final String CLASSBASE_OPTIONS = "org.jmol.";
    public static final String DEFAULT_HELP_PATH = "http://chemapps.stolaf.edu/jmol/docs/index.htm";
    public static final String EMBEDDED_SCRIPT_TAG = "**** Jmol Embedded Script ****";
    public static final String SCRIPT_EDITOR_IGNORE = "\u0001## EDITOR_IGNORE ##";
    public static final int CALLBACK_ANIMFRAME = 0;
    public static final int CALLBACK_ECHO = 1;
    public static final int CALLBACK_ERROR = 2;
    public static final int CALLBACK_EVAL = 3;
    public static final int CALLBACK_HOVER = 4;
    public static final int CALLBACK_LOADSTRUCT = 5;
    public static final int CALLBACK_MEASURE = 6;
    public static final int CALLBACK_MESSAGE = 7;
    public static final int CALLBACK_MINIMIZATION = 8;
    public static final int CALLBACK_PICK = 9;
    public static final int CALLBACK_RESIZE = 10;
    public static final int CALLBACK_SCRIPT = 11;
    public static final int CALLBACK_SYNC = 12;
    public static final int CALLBACK_CLICK = 13;
    public static final int CALLBACK_COUNT = 14;
    private static final String[] callbackNames;
    public static final int INFO_A = 0;
    public static final int INFO_B = 1;
    public static final int INFO_C = 2;
    public static final int INFO_ALPHA = 3;
    public static final int INFO_BETA = 4;
    public static final int INFO_GAMMA = 5;
    public static final int INFO_DIMENSIONS = 6;
    public static final int JMOL_DATA_OTHER = -1;
    public static final int JMOL_DATA_RAMACHANDRAN = 0;
    public static final int JMOL_DATA_QUATERNION = 1;
    public static final String allowedQuaternionFrames = "RC;RP;a;b;c;n;p;q;x;";
    public static final String EXPORT_DRIVER_LIST = "Idtf;Maya;Povray;Vrml;X3d;Tachyon";
    public static final int DRAW_MULTIPLE = -1;
    public static final int DRAW_NONE = 0;
    public static final int DRAW_POINT = 1;
    public static final int DRAW_LINE = 2;
    public static final int DRAW_TRIANGLE = 3;
    public static final int DRAW_PLANE = 4;
    public static final int DRAW_CYLINDER = 5;
    public static final int DRAW_ARROW = 15;
    public static final int DRAW_CIRCLE = 16;
    public static final int DRAW_CURVE = 17;
    public static final int DRAW_CIRCULARPLANE = 18;
    public static final int DRAW_ARC = 19;
    public static final int DRAW_LINE_SEGMENT = 20;
    public static final int DRAW_POLYGON = 21;
    public static final Vector3f center;
    public static final Vector3f axisX;
    public static final Vector3f axisY;
    public static final Vector3f axisZ;
    public static final Vector3f axisNX;
    public static final Vector3f axisNY;
    public static final Vector3f axisNZ;
    public static final Vector3f[] unitAxisVectors;
    public static final int XY_ZTOP = 100;
    public static final int DEFAULT_PERCENT_VDW_ATOM = 23;
    public static final float DEFAULT_BOND_RADIUS = 0.15f;
    public static final short DEFAULT_BOND_MILLIANGSTROM_RADIUS = 150;
    public static final float DEFAULT_STRUT_RADIUS = 0.3f;
    public static final float DEFAULT_BOND_TOLERANCE = 0.45f;
    public static final float DEFAULT_MIN_BOND_DISTANCE = 0.4f;
    public static final float DEFAULT_MAX_CONNECT_DISTANCE = 1.0E8f;
    public static final float DEFAULT_MIN_CONNECT_DISTANCE = 0.1f;
    public static final int MINIMIZATION_ATOM_MAX = 200;
    public static final float MINIMIZE_FIXED_RANGE = 5.0f;
    public static final int CONNECT_DELETE_BONDS = 12291;
    public static final int CONNECT_MODIFY_ONLY = 1073742024;
    public static final int CONNECT_CREATE_ONLY = 0x40000050;
    public static final int CONNECT_MODIFY_OR_CREATE = 1073742026;
    public static final int CONNECT_AUTO_BOND = 1073741852;
    public static final int CONNECT_IDENTIFY_ONLY = 1087373321;
    public static final int MOUSE_NONE = -1;
    public static final int MOUSE_ROTATE = 0;
    public static final int MOUSE_ZOOM = 1;
    public static final int MOUSE_XLATE = 2;
    public static final int MOUSE_PICK = 3;
    public static final int MOUSE_DELETE = 4;
    public static final int MOUSE_MEASURE = 5;
    public static final int MOUSE_ROTATE_Z = 6;
    public static final int MOUSE_SLAB_PLANE = 7;
    public static final int MOUSE_POPUP_MENU = 8;
    public static final byte MULTIBOND_NEVER = 0;
    public static final byte MULTIBOND_WIREFRAME = 1;
    public static final byte MULTIBOND_NOTSMALL = 2;
    public static final byte MULTIBOND_ALWAYS = 3;
    public static final short madMultipleBondSmallMaximum = 500;
    public static final int AXES_MODE_BOUNDBOX = 0;
    public static final int AXES_MODE_MOLECULAR = 1;
    public static final int AXES_MODE_UNITCELL = 2;
    public static final int[] argbsHbondType;
    private static final String[] bondOrderNames;
    private static final String[] bondOrderNumbers;
    private static final int[] bondOrderValues;
    public static final float ANGSTROMS_PER_BOHR = 0.5291772f;
    public static final int FRONTLIT = 1073741958;
    public static final int BACKLIT = 1073741862;
    public static final int FULLYLIT = 1073741964;
    public static final int[] altArgbsCpk;
    public static final int firstIsotope = 4;
    public static final int VDW_UNKNOWN = -1;
    public static final int VDW_JMOL = 0;
    public static final int VDW_BABEL = 1;
    public static final int VDW_RASMOL = 2;
    public static final int VDW_BABEL21 = 3;
    public static final int VDW_AUTO_JMOL = 4;
    public static final int VDW_AUTO_BABEL = 5;
    public static final int VDW_AUTO_RASMOL = 6;
    public static final int VDW_NOJMOL = 7;
    public static final int VDW_AUTO = 8;
    public static final int VDW_USER = 9;
    static final String[] vdwLabels;
    public static final short[] vanderwaalsMars;
    private static final short[] covalentMars;
    public static final int FORMAL_CHARGE_MIN = -4;
    public static final int FORMAL_CHARGE_MAX = 7;
    private static final short[] cationLookupTable;
    private static final short[] anionLookupTable;
    static BitSet bsCations;
    static BitSet bsAnions;
    public static final int MAXIMUM_AUTO_BOND_COUNT = 20;
    public static final byte PALETTE_VOLATILE = 64;
    public static final byte PALETTE_STATIC = 63;
    public static final byte PALETTE_UNKNOWN = -1;
    public static final byte PALETTE_NONE = 0;
    public static final byte PALETTE_CPK = 1;
    public static final byte PALETTE_PARTIAL_CHARGE = 2;
    public static final byte PALETTE_FORMAL_CHARGE = 3;
    public static final byte PALETTE_TEMP = 68;
    public static final byte PALETTE_FIXEDTEMP = 5;
    public static final byte PALETTE_SURFACE = 70;
    public static final byte PALETTE_STRUCTURE = 7;
    public static final byte PALETTE_AMINO = 8;
    public static final byte PALETTE_SHAPELY = 9;
    public static final byte PALETTE_CHAIN = 10;
    public static final byte PALETTE_GROUP = 75;
    public static final byte PALETTE_MONOMER = 76;
    public static final byte PALETTE_MOLECULE = 77;
    public static final byte PALETTE_ALTLOC = 14;
    public static final byte PALETTE_INSERTION = 15;
    public static final byte PALETTE_JMOL = 16;
    public static final byte PALETTE_RASMOL = 17;
    public static final byte PALETTE_TYPE = 18;
    public static final byte PALETTE_ENERGY = 19;
    public static final byte PALETTE_PROPERTY = 84;
    public static final byte PALETTE_VARIABLE = 85;
    public static final byte PALETTE_STRAIGHTNESS = 86;
    public static final byte PALETTE_POLYMER = 87;
    private static final String[] paletteNames;
    private static final byte[] paletteIDs;
    private static final int paletteCount;
    public static final int[] argbsCpk;
    public static final int[] argbsCpkRasmol;
    public static final byte PROTEIN_STRUCTURE_NOT = -1;
    public static final byte PROTEIN_STRUCTURE_NONE = 0;
    public static final byte PROTEIN_STRUCTURE_TURN = 1;
    public static final byte PROTEIN_STRUCTURE_SHEET = 2;
    public static final byte PROTEIN_STRUCTURE_HELIX = 3;
    public static final byte PROTEIN_STRUCTURE_DNA = 4;
    public static final byte PROTEIN_STRUCTURE_RNA = 5;
    public static final byte PROTEIN_STRUCTURE_CARBOHYDRATE = 6;
    private static final String[] proteinStructureNames;
    public static final int[] argbsStructure;
    public static final int[] argbsAmino;
    public static final int argbShapelyBackbone = -4671304;
    public static final int argbShapelySpecial = -10616738;
    public static final int argbShapelyDefault = -65281;
    public static final int[] argbsChainAtom;
    public static final int[] argbsChainHetero;
    public static final short FORMAL_CHARGE_COLIX_RED;
    public static final short FORMAL_CHARGE_COLIX_WHITE;
    public static final short FORMAL_CHARGE_COLIX_BLUE;
    public static final int FORMAL_CHARGE_RANGE_SIZE = 12;
    public static final int[] argbsFormalCharge;
    public static final int FORMAL_CHARGE_INDEX_WHITE = 4;
    public static final int FORMAL_CHARGE_INDEX_MAX;
    public static final short PARTIAL_CHARGE_COLIX_RED;
    public static final short PARTIAL_CHARGE_COLIX_WHITE;
    public static final short PARTIAL_CHARGE_COLIX_BLUE;
    public static final int PARTIAL_CHARGE_RANGE_SIZE = 31;
    public static final int[] argbsRwbScale;
    public static final int[] argbsRoygbScale;
    public static final int[] argbsIsosurfacePositive;
    public static final int[] argbsIsosurfaceNegative;
    private static final String[] specialAtomNames;
    public static final int ATOMID_MAX;
    public static final byte ATOMID_AMINO_NITROGEN = 1;
    public static final byte ATOMID_ALPHA_CARBON = 2;
    public static final byte ATOMID_CARBONYL_CARBON = 3;
    public static final byte ATOMID_CARBONYL_OXYGEN = 4;
    public static final byte ATOMID_O1 = 5;
    public static final int ATOMID_ALPHA_ONLY_MASK = 4;
    public static final int ATOMID_PROTEIN_MASK = 14;
    public static final byte ATOMID_O5_PRIME = 6;
    public static final byte ATOMID_C4_PRIME = 8;
    public static final byte ATOMID_C3_PRIME = 9;
    public static final byte ATOMID_O3_PRIME = 10;
    public static final byte ATOMID_C1_PRIME = 12;
    public static final int ATOMID_NUCLEIC_MASK = 8128;
    public static final byte ATOMID_NUCLEIC_PHOSPHORUS = 13;
    public static final int ATOMID_PHOSPHORUS_ONLY_MASK = 8192;
    public static final int ATOMID_DISTINGUISHING_ATOM_MAX = 14;
    public static final byte ATOMID_CARBONYL_OD1 = 14;
    public static final byte ATOMID_CARBONYL_OD2 = 15;
    public static final byte ATOMID_CARBONYL_OE1 = 16;
    public static final byte ATOMID_CARBONYL_OE2 = 17;
    public static final byte ATOMID_SG = 18;
    public static final byte ATOMID_N1 = 32;
    public static final byte ATOMID_C2 = 33;
    public static final byte ATOMID_N3 = 34;
    public static final byte ATOMID_C4 = 35;
    public static final byte ATOMID_C5 = 36;
    public static final byte ATOMID_C6 = 37;
    public static final byte ATOMID_O2 = 38;
    public static final byte ATOMID_N7 = 39;
    public static final byte ATOMID_C8 = 40;
    public static final byte ATOMID_N9 = 41;
    public static final byte ATOMID_N4 = 42;
    public static final byte ATOMID_N2 = 43;
    public static final byte ATOMID_N6 = 44;
    public static final byte ATOMID_C5M = 45;
    public static final byte ATOMID_O6 = 46;
    public static final byte ATOMID_O4 = 47;
    public static final byte ATOMID_S4 = 48;
    public static final byte ATOMID_C7 = 49;
    private static final int ATOMID_BACKBONE_MIN = 64;
    public static final byte ATOMID_TERMINATING_OXT = 64;
    public static final byte ATOMID_H5T_TERMINUS = 72;
    public static final byte ATOMID_O5T_TERMINUS = 73;
    public static final byte ATOMID_O1P = 74;
    public static final byte ATOMID_OP1 = 75;
    public static final byte ATOMID_O2P = 76;
    public static final byte ATOMID_OP2 = 77;
    public static final byte ATOMID_O2_PRIME = 79;
    public static final byte ATOMID_H3T_TERMINUS = 88;
    public static final byte ATOMID_HO3_PRIME = 89;
    public static final byte ATOMID_HO5_PRIME = 90;
    private static Map<String, Integer> htSpecialAtoms;
    public static final int GROUPID_CYSTEINE = 5;
    public static final int GROUPID_PROLINE = 15;
    public static final int GROUPID_AMINO_MAX = 24;
    private static final int GROUPID_WATER = 43;
    private static final int GROUPID_SOLVENTS = 46;
    private static final int GROUPID_SULPHATE = 49;
    public static final String[] predefinedGroup3Names;
    public static final int[] argbsShapely;
    private static final String allCarbohydrates = ",[AFL],[AGC],[AHR],[ARA],[ARB],[BDF],[BDR],[BGC],[BMA],[FCA],[FCB],[FRU],[FUC],[FUL],[GAL],[GLA],[GLB],[GLC],[GUP],[LXC],[MAN],[RAA],[RAM],[RIB],[RIP],[XYP],[XYS],[CBI],[CT3],[CTR],[CTT],[LAT],[MAB],[MAL],[MLR],[MTT],[SUC],[TRE],[ASF],[GCU],[MTL],[NAG],[NAM],[RHA],[SOR],[XYL]";
    public static final String group3List;
    public static final int group3Count;
    public static final char[] predefinedGroup1Names;
    public static String[] predefinedVariable;
    public static String[] predefinedStatic;
    public static final String MODELKIT_ZAP_STRING = "1 0 C 0 0";
    public static final String MODELKIT_ZAP_TITLE = "Jmol Model Kit";
    public static final String DEFAULT_FONTFACE = "SansSerif";
    public static final String DEFAULT_FONTSTYLE = "Plain";
    public static final int LABEL_MINIMUM_FONTSIZE = 6;
    public static final int LABEL_MAXIMUM_FONTSIZE = 63;
    public static final int LABEL_DEFAULT_FONTSIZE = 13;
    public static final int LABEL_DEFAULT_X_OFFSET = 4;
    public static final int LABEL_DEFAULT_Y_OFFSET = 4;
    public static final int MEASURE_DEFAULT_FONTSIZE = 15;
    public static final int AXES_DEFAULT_FONTSIZE = 14;
    public static final int SHAPE_BALLS = 0;
    public static final int SHAPE_STICKS = 1;
    public static final int SHAPE_HSTICKS = 2;
    public static final int SHAPE_SSSTICKS = 3;
    public static final int SHAPE_STRUTS = 4;
    public static final int SHAPE_LABELS = 5;
    public static final int SHAPE_MEASURES = 6;
    public static final int SHAPE_STARS = 7;
    public static final int SHAPE_HALOS = 8;
    public static final int SHAPE_MIN_SECONDARY = 9;
    public static final int SHAPE_BACKBONE = 9;
    public static final int SHAPE_TRACE = 10;
    public static final int SHAPE_CARTOON = 11;
    public static final int SHAPE_STRANDS = 12;
    public static final int SHAPE_MESHRIBBON = 13;
    public static final int SHAPE_RIBBONS = 14;
    public static final int SHAPE_ROCKETS = 15;
    public static final int SHAPE_MAX_SECONDARY = 16;
    public static final int SHAPE_MIN_SPECIAL = 16;
    public static final int SHAPE_DOTS = 16;
    public static final int SHAPE_DIPOLES = 17;
    public static final int SHAPE_VECTORS = 18;
    public static final int SHAPE_GEOSURFACE = 19;
    public static final int SHAPE_ELLIPSOIDS = 20;
    public static final int SHAPE_MAX_SIZE_ZERO_ON_RESTRICT = 21;
    public static final int SHAPE_POLYHEDRA = 21;
    public static final int SHAPE_MIN_HAS_ID = 22;
    public static final int SHAPE_MIN_MESH_COLLECTION = 22;
    public static final int SHAPE_DRAW = 22;
    public static final int SHAPE_MAX_SPECIAL = 23;
    public static final int SHAPE_MIN_SURFACE = 23;
    public static final int SHAPE_ISOSURFACE = 23;
    public static final int SHAPE_LCAOCARTOON = 24;
    public static final int SHAPE_MO = 25;
    public static final int SHAPE_PMESH = 26;
    public static final int SHAPE_PLOT3D = 27;
    public static final int SHAPE_MAX_SURFACE = 28;
    public static final int SHAPE_MAX_MESH_COLLECTION = 28;
    public static final int SHAPE_ECHO = 28;
    public static final int SHAPE_MAX_HAS_ID = 29;
    public static final int SHAPE_AXES = 29;
    public static final int SHAPE_BBCAGE = 30;
    public static final int SHAPE_UCCAGE = 31;
    public static final int SHAPE_HOVER = 32;
    public static final int SHAPE_FRANK = 33;
    public static final int SHAPE_MAX = 34;
    public static final String[] shapeClassBases;
    public static final int ATOM_IN_FRAME = 1;
    public static final int ATOM_SLABBED = 2;
    public static final String PREVIOUS_MESH_ID = "+PREVIOUS_MESH+";
    public static final int CARTOON_VISIBILITY_FLAG;
    public static final int BACKBONE_VISIBILITY_FLAG;
    public static final int ALPHA_CARBON_VISIBILITY_FLAG;
    public static final int DEFAULT_STEREO_DEGREES = -5;
    public static final int STEREO_UNKNOWN = -1;
    public static final int STEREO_NONE = 0;
    public static final int STEREO_DOUBLE = 1;
    public static final int STEREO_REDCYAN = 2;
    public static final int STEREO_REDBLUE = 3;
    public static final int STEREO_REDGREEN = 4;
    public static final int STEREO_CUSTOM = 5;
    private static final String[] stereoModes;
    public static final int SHELL_S = 0;
    public static final int SHELL_P = 1;
    public static final int SHELL_SP = 2;
    public static final int SHELL_L = 2;
    public static final int SHELL_D_SPHERICAL = 3;
    public static final int SHELL_D_CARTESIAN = 4;
    public static final int SHELL_F_SPHERICAL = 5;
    public static final int SHELL_F_CARTESIAN = 6;
    public static final int SHELL_G_SPHERICAL = 7;
    public static final int SHELL_G_CARTESIAN = 8;
    public static final int SHELL_H_SPHERICAL = 9;
    public static final int SHELL_H_CARTESIAN = 10;
    public static final String SUPPORTED_BASIS_FUNCTIONS = "SPLDF";
    private static final String[] quantumShellTags;
    private static final int[] quantumShellIDs;
    public static final String SUPPORTED_BASES = "SPDLF";
    private static final String[][] shellOrder;
    public static final String LOAD_ATOM_DATA_TYPES = "xyz;vxyz;vibration;temperature;occupancy;partialcharge";
    public static final int ANIMATION_ONCE = 0;
    public static final int ANIMATION_LOOP = 1;
    public static final int ANIMATION_PALINDROME = 2;
    public static final float radiansPerDegree = (float)Math.PI / 180;

    public static String embedScript(String string) {
        return "\n/****** Jmol Embedded Script **** \n" + string + "\n**/";
    }

    public static String getCallbackName(int n) {
        if (n < 0) {
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < callbackNames.length; ++i) {
                stringBuffer.append(callbackNames[i].toLowerCase()).append(";");
            }
            return stringBuffer.toString();
        }
        return n >= callbackNames.length ? null : callbackNames[n];
    }

    public static int getCallbackId(String string) {
        for (int i = 0; i < 14; ++i) {
            if (!JmolConstants.getCallbackName(i).equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    public static String getDrawTypeName(int n) {
        switch (n) {
            case -1: {
                return "multiple";
            }
            case 1: {
                return "point";
            }
            case 2: {
                return "line";
            }
            case 5: {
                return "cylinder";
            }
            case 3: {
                return "triangle";
            }
            case 4: {
                return "plane";
            }
            case 15: {
                return "arrow";
            }
            case 19: {
                return "arc";
            }
            case 16: {
                return "circle";
            }
            case 18: {
                return "circularPlane";
            }
            case 17: {
                return "curve";
            }
        }
        return "drawObject";
    }

    public static int getArgbHbondType(int n) {
        int n2 = (n & 0x7800) >> 11;
        return argbsHbondType[n2];
    }

    public static final int getBondOrderFromString(String string) {
        for (int i = 0; i < bondOrderNumbers.length; ++i) {
            if (!bondOrderNames[i].equalsIgnoreCase(string)) continue;
            return bondOrderValues[i];
        }
        if (string.toLowerCase().indexOf("partial ") == 0) {
            return JmolConstants.getPartialBondOrderFromInteger(JmolConstants.modelValue(string.substring(8).trim()));
        }
        return 131071;
    }

    public static final int getPartialBondOrderFromInteger(int n) {
        return (n / 1000000 % 6 << 5) + (n % 1000000 & 0x1F);
    }

    public static final int getCovalentBondOrder(int n) {
        if ((n & 0x3FF) == 0) {
            return 0;
        }
        if (((n &= 0xFFFDFFFF) & 0xE0) != 0) {
            return JmolConstants.getPartialBondOrder(n);
        }
        if ((n & 0x100) != 0) {
            n &= 0xFFFFFEFF;
        }
        if ((n & 0xF8) != 0) {
            n = 1;
        }
        return n & 7;
    }

    public static final int getPartialBondOrder(int n) {
        return (n & 0xFFFDFFFF) >> 5;
    }

    public static final int getPartialBondDotted(int n) {
        return n & 0x1F;
    }

    public static final int getBondOrderFromFloat(float f) {
        for (int i = 0; i < bondOrderNumbers.length; ++i) {
            if (Float.valueOf(bondOrderNumbers[i]).floatValue() != Math.abs(f)) continue;
            if (f > 0.0f) {
                return bondOrderValues[i];
            }
            f = -f;
        }
        return 131071;
    }

    public static final String getBondOrderNameFromOrder(int n) {
        switch (n &= 0xFFFDFFFF) {
            case 65535: 
            case 131071: {
                return "";
            }
            case 32768: {
                return "strut";
            }
            case 1: {
                return "single";
            }
            case 2: {
                return "double";
            }
        }
        if ((n & 0xE0) != 0) {
            return "partial " + JmolConstants.getBondOrderNumberFromOrder(n);
        }
        if ((n & 0x7800) != 0) {
            return "hbond";
        }
        if ((n & 0x100) != 0) {
            return "single";
        }
        int n2 = bondOrderValues.length;
        while (--n2 >= 0) {
            if (bondOrderValues[n2] != n) continue;
            return bondOrderNames[n2];
        }
        return "?";
    }

    public static String getCmlOrder(int n) {
        String string = JmolConstants.getBondOrderNameFromOrder(n);
        switch (string.charAt(0)) {
            case 'd': 
            case 's': 
            case 't': {
                return "" + string.toUpperCase().charAt(0);
            }
            case 'a': {
                if (string.indexOf("Double") >= 0) {
                    return "D";
                }
                if (string.indexOf("Single") >= 0) {
                    return "S";
                }
                return "aromatic";
            }
            case 'p': {
                if (string.indexOf(" ") >= 0) {
                    return string.substring(string.indexOf(" ") + 1);
                }
                return "partial12";
            }
        }
        return null;
    }

    public static final String getBondOrderNumberFromOrder(int n) {
        if ((n &= 0xFFFDFFFF) == 131071 || n == 65535) {
            return "0";
        }
        if ((n & 0x7800) != 0) {
            return "1";
        }
        if ((n & 0x100) != 0) {
            return "1";
        }
        if ((n & 0xE0) != 0) {
            return (n >> 5) + "." + (n & 0x1F);
        }
        int n2 = bondOrderValues.length;
        while (--n2 >= 0) {
            if (bondOrderValues[n2] != n) continue;
            return bondOrderNumbers[n2];
        }
        return "?";
    }

    public static String getVdwLabel(int n) {
        return vdwLabels[n % 4];
    }

    public static int getVdwType(String string) {
        if (string != null) {
            for (int i = 0; i < vdwLabels.length; ++i) {
                if (!string.equalsIgnoreCase(vdwLabels[i])) continue;
                return i;
            }
        }
        return -1;
    }

    public static int getVanderwaalsMar(int n, int n2) {
        return vanderwaalsMars[(n << 2) + n2 % 4];
    }

    public static float getBondingRadiusFloat(int n, int n2) {
        if (n2 > 0 && bsCations.get(n)) {
            return JmolConstants.getBondingRadiusFloat(n, n2, cationLookupTable);
        }
        if (n2 < 0 && bsAnions.get(n)) {
            return JmolConstants.getBondingRadiusFloat(n, n2, anionLookupTable);
        }
        return (float)covalentMars[n] / 1000.0f;
    }

    private static float getBondingRadiusFloat(int n, int n2, short[] sArray) {
        short s = (short)((n << 4) + (n2 + 4));
        short s2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = sArray.length / 2;
        while (n4 != n5) {
            n3 = (n4 + n5) / 2;
            s2 = sArray[n3 << 1];
            if (s2 > s) {
                n5 = n3;
                continue;
            }
            if (s2 < s) {
                n4 = n3 + 1;
                continue;
            }
            return (float)sArray[(n3 << 1) + 1] / 1000.0f;
        }
        if (s2 > s) {
            --n3;
        }
        if (n != (s2 = sArray[n3 << 1]) >> 4) {
            ++n3;
        }
        return (float)sArray[(n3 << 1) + 1] / 1000.0f;
    }

    public static byte pidOf(Object object) {
        return object instanceof Byte ? (Byte)object : (byte)-1;
    }

    public static boolean isPaletteVariable(byte by) {
        return (by & 0x40) != 0;
    }

    public static final byte getPaletteID(String string) {
        for (int i = 0; i < paletteCount; ++i) {
            if (!paletteNames[i].equals(string)) continue;
            return paletteIDs[i];
        }
        return string.indexOf("property_") == 0 ? (byte)84 : -1;
    }

    public static final String getPaletteName(byte by) {
        if (by == -1) {
            return null;
        }
        for (int i = 0; i < paletteCount; ++i) {
            if (paletteIDs[i] != by) continue;
            return paletteNames[i];
        }
        return null;
    }

    public static final String getProteinStructureName(int n, boolean bl) {
        return n < 0 || n > 6 ? "" : (bl && n < 4 ? "protein" : proteinStructureNames[n]);
    }

    public static final byte getProteinStructureType(String string) {
        for (byte by = 0; by < 4; by = (byte)(by + 1)) {
            if (!string.equalsIgnoreCase(proteinStructureNames[by])) continue;
            return by;
        }
        return -1;
    }

    public static final String getSpecialAtomName(int n) {
        return specialAtomNames[n];
    }

    public static byte lookupSpecialAtomID(String string) {
        Integer n = htSpecialAtoms.get(string);
        if (n != null) {
            return (byte)n.intValue();
        }
        return 0;
    }

    public static final boolean checkCarbohydrate(String string) {
        return string != null && allCarbohydrates.indexOf("[" + string.toUpperCase() + "]") >= 0;
    }

    private static final String getGroup3List() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 1; i < 43; ++i) {
            stringBuffer.append(",[").append((predefinedGroup3Names[i] + "   ").substring(0, 3) + "]");
        }
        stringBuffer.append(allCarbohydrates);
        return stringBuffer.toString();
    }

    public static final boolean isHetero(String string) {
        int n = group3List.indexOf("[" + (string + "   ").substring(0, 3) + "]");
        return n < 0 || n / 6 >= 43;
    }

    public static final boolean isShapeSecondary(int n) {
        return n >= 9 && n < 16;
    }

    public static final int shapeTokenIndex(int n) {
        switch (n) {
            case 0x44100001: {
                return 0;
            }
            case 659523: 
            case 1678770178: {
                return 1;
            }
            case 1612189718: {
                return 2;
            }
            case 1611141176: {
                return 3;
            }
            case 1708089: {
                return 4;
            }
            case 1826248716: {
                return 5;
            }
            case 537006111: 
            case 1746538509: {
                return 6;
            }
            case 1113200652: {
                return 7;
            }
            case 1113200646: {
                return 8;
            }
            case 1115297793: {
                return 9;
            }
            case 1113200654: {
                return 10;
            }
            case 1113200642: {
                return 11;
            }
            case 1650071565: {
                return 12;
            }
            case 1113200647: {
                return 13;
            }
            case 1113200649: {
                return 14;
            }
            case 1113200650: {
                return 15;
            }
            case 1113198595: {
                return 16;
            }
            case 135182: {
                return 17;
            }
            case 135233: {
                return 18;
            }
            case 1113198597: {
                return 19;
            }
            case 1113198596: {
                return 20;
            }
            case 135208: {
                return 21;
            }
            case 135184: {
                return 22;
            }
            case 135197: {
                return 23;
            }
            case 135198: {
                return 24;
            }
            case 0x121021: {
                return 25;
            }
            case 135206: {
                return 26;
            }
            case 135207: {
                return 27;
            }
            case 537022465: {
                return 28;
            }
            case 1611272194: {
                return 29;
            }
            case 1679429641: {
                return 30;
            }
            case 1614417984: {
                return 31;
            }
            case 544771: {
                return 32;
            }
            case 1611272213: {
                return 33;
            }
        }
        return -1;
    }

    public static final String getShapeClassName(int n) {
        if (n < 0) {
            return shapeClassBases[~n];
        }
        return "org.jmol.shape" + (n >= 9 && n < 16 ? "bio." : (n >= 16 && n < 23 ? "special." : (n >= 23 && n < 28 ? "surface." : "."))) + shapeClassBases[n];
    }

    public static final int getShapeVisibilityFlag(int n) {
        return 4 << n;
    }

    public static int getStereoMode(String string) {
        for (int i = 0; i < 5; ++i) {
            if (!string.equalsIgnoreCase(stereoModes[i])) continue;
            return i;
        }
        return -1;
    }

    static String getStereoModeName(int n) {
        return stereoModes[n];
    }

    public static final String[] getShellOrder(int n) {
        return n < 0 || n > shellOrder.length ? null : shellOrder[n];
    }

    public static final int getQuantumShellTagID(String string) {
        int n = quantumShellTags.length;
        while (--n >= 0) {
            if (!string.equals(quantumShellTags[n])) continue;
            return quantumShellIDs[n];
        }
        return -1;
    }

    public static final int getQuantumShellTagIDSpherical(String string) {
        int n = JmolConstants.getQuantumShellTagID(string);
        switch (n) {
            case 4: {
                return 3;
            }
            case 6: {
                return 5;
            }
            case 8: {
                return 7;
            }
            case 10: {
                return 9;
            }
        }
        return n;
    }

    public static final String getQuantumShellTag(int n) {
        int n2 = quantumShellTags.length;
        while (--n2 >= 0) {
            if (n != quantumShellIDs[n2]) continue;
            return quantumShellTags[n2];
        }
        return "" + n;
    }

    public static int modelValue(String string) {
        int n = string.indexOf(".");
        if (n < 1 || string.charAt(0) == '-') {
            return Integer.MAX_VALUE;
        }
        int n2 = 0;
        int n3 = 0;
        if (n > 0) {
            try {
                n2 = Integer.parseInt(string.substring(0, n));
                if (n2 < 0) {
                    n2 = -n2;
                }
            }
            catch (NumberFormatException numberFormatException) {
                n2 = -1;
            }
        }
        if (n < string.length() - 1) {
            try {
                n3 = Integer.parseInt(string.substring(n + 1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return (n2 = n2 * 1000000 + n3) < 0 ? Integer.MAX_VALUE : n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        int n;
        String string = null;
        Object object = new Properties();
        if (string == null) {
            BufferedInputStream bufferedInputStream = null;
            InputStream inputStream = null;
            try {
                inputStream = JmolConstants.class.getClassLoader().getResourceAsStream("org/jmol/viewer/Jmol.properties");
                bufferedInputStream = new BufferedInputStream(inputStream);
                ((Properties)object).load(bufferedInputStream);
                string = ((Properties)object).getProperty("version", string);
            }
            catch (IOException iOException) {
            }
            finally {
                if (bufferedInputStream != null) {
                    try {
                        bufferedInputStream.close();
                    }
                    catch (IOException iOException) {}
                }
                if (inputStream != null) {
                    try {
                        inputStream.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        version = string != null ? string : "(Unknown version)";
        date = cvsDate.substring(7, 23);
        callbackNames = new String[]{"animFrameCallback", "echoCallback", "errorCallback", "evalCallback", "hoverCallback", "loadStructCallback", "measureCallback", "messageCallback", "minimizationCallback", "pickCallback", "resizeCallback", "scriptCallback", "syncCallback", "clickCallback"};
        center = new Vector3f(0.0f, 0.0f, 0.0f);
        axisX = new Vector3f(1.0f, 0.0f, 0.0f);
        axisY = new Vector3f(0.0f, 1.0f, 0.0f);
        axisZ = new Vector3f(0.0f, 0.0f, 1.0f);
        axisNX = new Vector3f(-1.0f, 0.0f, 0.0f);
        axisNY = new Vector3f(0.0f, -1.0f, 0.0f);
        axisNZ = new Vector3f(0.0f, 0.0f, -1.0f);
        unitAxisVectors = new Vector3f[]{axisX, axisY, axisZ, axisNX, axisNY, axisNZ};
        argbsHbondType = new int[]{-38476, -256, -256, -1, -65281, -65536, -23296, -16711681, -16711936, -32640};
        bondOrderNames = new String[]{"single", "double", "triple", "quadruple", "aromatic", "struts", "hbond", "partial", "partialDouble", "partialTriple", "partialTriple2", "aromaticSingle", "aromaticDouble", "unspecified"};
        bondOrderNumbers = new String[]{"1", "2", "3", "4", "1.5", "1", "1", "0.5", "1.5", "2.5", "2.5", "1", "2", "1"};
        bondOrderValues = new int[]{1, 2, 3, 4, 515, 32768, 2048, 33, 66, 97, 100, 513, 514, 17};
        altArgbsCpk = new int[]{-60269, -4217178, -208, -11069553, -64, -96, -2565928, -11513776, -12566464, -15708080};
        vdwLabels = new String[]{"Jmol", "Babel", "RasMol", "Babel21", null, null, null, null, "Auto", "User"};
        vanderwaalsMars = new short[]{1000, 1000, 1000, 1000, 1200, 1100, 1100, 1200, 1400, 1400, 2200, 1400, 1820, 1810, 1220, 2200, 1700, 1530, 628, 1900, 2080, 1920, 1548, 1800, 1950, 1700, 1548, 1700, 1850, 1550, 1400, 1600, 1700, 1520, 1348, 1550, 1730, 1470, 1300, 1500, 1540, 1540, 2020, 1540, 2270, 2270, 2200, 2400, 1730, 1730, 1500, 2200, 2050, 1840, 1500, 2100, 2100, 2100, 2200, 2100, 2080, 1800, 1880, 1950, 2000, 1800, 1808, 1800, 1970, 1750, 1748, 1800, 1880, 1880, 2768, 1880, 2750, 2750, 2388, 2800, 1973, 2310, 1948, 2400, 1700, 2300, 1320, 2300, 1700, 2150, 1948, 2150, 1700, 2050, 1060, 2050, 1700, 2050, 1128, 2050, 1700, 2050, 1188, 2050, 1700, 2050, 1948, 2050, 1700, 2000, 1128, 2000, 1630, 2000, 1240, 2000, 1400, 2000, 1148, 2000, 1390, 2100, 1148, 2100, 1870, 1870, 1548, 2100, 1700, 2110, 3996, 2100, 1850, 1850, 828, 2050, 1900, 1900, 900, 1900, 2100, 1830, 1748, 1900, 2020, 2020, 1900, 2020, 1700, 3030, 2648, 2900, 1700, 2490, 2020, 2550, 1700, 2400, 1608, 2400, 1700, 2300, 1420, 2300, 1700, 2150, 1328, 2150, 1700, 2100, 1748, 2100, 1700, 2050, 1800, 2050, 1700, 2050, 1200, 2050, 1700, 2000, 1220, 2000, 1630, 2050, 1440, 2050, 1720, 2100, 1548, 2100, 1580, 2200, 1748, 2200, 1930, 2200, 1448, 2200, 2170, 1930, 1668, 2250, 2200, 2170, 1120, 2200, 2060, 2060, 1260, 2100, 2150, 1980, 1748, 2100, 2160, 2160, 2100, 2160, 1700, 3430, 3008, 3000, 1700, 2680, 2408, 2700, 1700, 2500, 1828, 2500, 1700, 2480, 1860, 2480, 1700, 2470, 1620, 2470, 1700, 2450, 1788, 2450, 1700, 2430, 1760, 2430, 1700, 2420, 1740, 2420, 1700, 2400, 1960, 2400, 1700, 2380, 1688, 2380, 1700, 2370, 1660, 2370, 1700, 2350, 1628, 2350, 1700, 2330, 1608, 2330, 1700, 2320, 1588, 2320, 1700, 2300, 1568, 2300, 1700, 2280, 1540, 2280, 1700, 2270, 1528, 2270, 1700, 2250, 1400, 2250, 1700, 2200, 1220, 2200, 1700, 2100, 1260, 2100, 1700, 2050, 1300, 2050, 1700, 2000, 1580, 2000, 1700, 2000, 1220, 2000, 1720, 2050, 1548, 2050, 1660, 2100, 1448, 2100, 1550, 2050, 1980, 2050, 1960, 1960, 1708, 2200, 2020, 2020, 2160, 2300, 1700, 2070, 1728, 2300, 1700, 1970, 1208, 2000, 1700, 2020, 1120, 2000, 1700, 2200, 2300, 2000, 1700, 3480, 3240, 2000, 1700, 2830, 2568, 2000, 1700, 2000, 2120, 2000, 1700, 2400, 1840, 2400, 1700, 2000, 1600, 2000, 1860, 2300, 1748, 2300, 1700, 2000, 1708, 2000, 1700, 2000, 1668, 2000, 1700, 2000, 1660, 2000, 1700, 2000, 1648, 2000, 1700, 2000, 1640, 2000, 1700, 2000, 1628, 2000, 1700, 2000, 1620, 2000, 1700, 2000, 1608, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1588, 2000, 1700, 2000, 1580, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000, 1700, 2000, 1600, 2000};
        covalentMars = new short[]{0, 230, 930, 680, 350, 830, 680, 680, 680, 640, 1120, 970, 1100, 1350, 1200, 750, 1020, 990, 1570, 1330, 990, 1440, 1470, 1330, 1350, 1350, 1340, 1330, 1500, 1520, 1450, 1220, 1170, 1210, 1220, 1210, 1910, 1470, 1120, 1780, 1560, 1480, 1470, 1350, 1400, 1450, 1500, 1590, 1690, 1630, 1460, 1460, 1470, 1400, 1980, 1670, 1340, 1870, 1830, 1820, 1810, 1800, 1800, 1990, 1790, 1760, 1750, 1740, 1730, 1720, 1940, 1720, 1570, 1430, 1370, 1350, 1370, 1320, 1500, 1500, 1700, 1550, 1540, 1540, 1680, 1700, 2400, 2000, 1900, 1880, 1790, 1610, 1580, 1550, 1530, 1510, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1500, 1600, 1600, 1600, 1600, 1600, 1600};
        cationLookupTable = new short[]{53, 680, 69, 440, 70, 350, 85, 350, 87, 230, 104, 160, 117, 680, 119, 160, 121, 130, 133, 220, 138, 90, 155, 80, 165, 1120, 181, 970, 197, 820, 198, 660, 215, 510, 229, 650, 232, 420, 247, 440, 249, 350, 262, 2190, 264, 370, 266, 300, 281, 340, 283, 270, 293, 1540, 309, 1330, 325, 1180, 326, 990, 343, 732, 357, 960, 358, 940, 359, 760, 360, 680, 374, 880, 375, 740, 376, 630, 377, 590, 389, 810, 390, 890, 391, 630, 394, 520, 406, 800, 407, 660, 408, 600, 411, 460, 422, 740, 423, 640, 438, 720, 439, 630, 454, 690, 469, 960, 470, 720, 485, 880, 486, 740, 501, 810, 503, 620, 518, 730, 520, 530, 535, 580, 537, 460, 549, 660, 552, 500, 554, 420, 569, 470, 571, 390, 597, 1470, 614, 1120, 631, 893, 645, 1090, 648, 790, 661, 1000, 664, 740, 665, 690, 677, 930, 680, 700, 682, 620, 699, 979, 712, 670, 727, 680, 742, 800, 744, 650, 757, 1260, 758, 890, 773, 1140, 774, 970, 791, 810, 806, 930, 808, 710, 823, 760, 825, 620, 837, 820, 840, 700, 842, 560, 857, 620, 859, 500, 885, 1670, 901, 1530, 902, 1340, 917, 1390, 919, 1016, 933, 1270, 935, 1034, 936, 920, 951, 1013, 952, 900, 967, 995, 983, 979, 999, 964, 1014, 1090, 1015, 950, 1031, 938, 1047, 923, 1048, 840, 1063, 908, 1079, 894, 1095, 881, 1111, 870, 1126, 930, 1127, 858, 1143, 850, 1160, 780, 1177, 680, 1192, 700, 1194, 620, 1208, 720, 1211, 560, 1224, 880, 1226, 690, 1240, 680, 1254, 800, 1256, 650, 1269, 1370, 1271, 850, 1285, 1270, 1286, 1100, 1301, 1470, 1303, 950, 1318, 1200, 1320, 840, 1333, 980, 1335, 960, 1337, 740, 1354, 670, 1371, 620, 1397, 1800, 1414, 1430, 1431, 1180, 1448, 1020, 1463, 1130, 1464, 980, 1465, 890, 1480, 970, 1482, 800, 1495, 1100, 1496, 950, 1499, 710, 1511, 1080, 1512, 930, 1527, 1070, 1528, 920};
        anionLookupTable = new short[]{19, 1540, 96, 2600, 113, 1710, 130, 1360, 131, 680, 147, 1330, 241, 2120, 258, 1840, 275, 1810, 512, 2720, 529, 2220, 546, 1980, 563, 1960, 800, 2940, 803, 3700, 817, 2450, 834, 2110, 835, 2500, 851, 2200};
        bsCations = new BitSet();
        bsAnions = new BitSet();
        for (n = 0; n < anionLookupTable.length; n += 2) {
            bsAnions.set(anionLookupTable[n] >> 4);
        }
        for (n = 0; n < cationLookupTable.length; n += 2) {
            bsCations.set(cationLookupTable[n] >> 4);
        }
        paletteNames = new String[]{"none", "cpk", "partialcharge", "formalcharge", "temperature", "fixedtemperature", "surfacedistance", "structure", "amino", "shapely", "chain", "group", "monomer", "molecule", "altloc", "insertion", "jmol", "rasmol", "type", "energy", "property", "variable", "straightness", "polymer"};
        paletteIDs = new byte[]{0, 1, 2, 3, 68, 5, 70, 7, 8, 9, 10, 75, 76, 77, 14, 15, 16, 17, 18, 19, 84, 85, 86, 87};
        paletteCount = paletteNames.length;
        argbsCpk = new int[]{-60269, -1, -2490369, -3374849, -3997952, -19019, -7303024, -13610760, -62195, -7282608, -4987915, -5546766, -7667968, -4217178, -997216, Short.MIN_VALUE, -208, -14684129, -8334877, -7388972, -12714240, -1644826, -4209977, -5855573, -7693881, -6522169, -2070989, -1011552, -11481008, -3637197, -8552272, -4026481, -10055793, -4357917, -24320, -5887703, -10700591, -9425232, -16711936, -7012353, -7020320, -9190711, -11225675, -12869986, -14381169, -16089716, -16750203, -4144960, -9841, -5868173, -10059648, -6397003, -2852352, -7077740, -12411216, -11069553, -16725760, -9382657, -57, -2490425, -3670073, -6029369, -7340089, -10354745, -12189753, -13566009, -14680121, -16711780, -16718219, -16722862, -16728264, -16733404, -11681025, -11688193, -14576426, -14254677, -14260586, -15248249, -3092256, -11997, -4671280, -5876659, -11052703, -6402123, -5547008, -9089211, -12418410, -12451738, -16745216, -9393158, -16729345, -16735745, -16740353, -16744193, -16749569, -11248398, -8889117, -7712797, -6211884, -5038124, -5038150, -5042778, -4387449, -3735450, -3407783, -3080113, -2555835, -2097096, -1703890, -1376218};
        argbsCpkRasmol = new int[]{16716947, 0x1FFFFFF, 50315467, 0x3B22222, 0x500FF00, 0x6C8C8C8, 0x78F8FFF, 0x8F00000, 165324064, 0xB0000FF, 203590434, 226525328, 249210144, 268412160, 285198386, 0x1100FF00, 343965840, 377520272, 411074704, 427851920, 452961536, 480586282, 497363498, 514140714, 598026794, 796950672, 899686640, 956278016, 1339729184};
        if (Elements.elementNames.length != Elements.elementNumberMax || vanderwaalsMars.length / 4 != Elements.elementNumberMax || covalentMars.length != Elements.elementNumberMax || argbsCpk.length != Elements.elementNumberMax) {
            Logger.error("ERROR!!! Element table length mismatch:\n elementSymbols.length=" + Elements.elementSymbols.length + "\n elementNames.length=" + Elements.elementNames.length + "\n vanderwaalsMars.length=" + vanderwaalsMars.length + "\n covalentMars.length=" + covalentMars.length + "\n argbsCpk.length=" + argbsCpk.length);
        }
        if ((proteinStructureNames = new String[]{"none", "turn", "sheet", "helix", "dna", "rna", "carbohydrate"}).length != (argbsStructure = new int[]{-8355712, -1, -10452737, -14336, -65408, -5373698, -196254, -5855494}).length - 1) {
            System.out.println("protineStructureNames.length != argbsStructure.length");
            throw new NullPointerException();
        }
        argbsAmino = new int[]{-4284306, -3618616, -15443201, -16720676, -1701366, -1645056, -16720676, -1701366, -1315861, -8224046, -15760881, -15760881, -15443201, -1645056, -13487446, -2320766, -354816, -354816, -4957516, -13487446, -15760881, -38476, -38476, -4284306};
        argbsChainAtom = new int[]{-1, -4140801, -5177424, -16184, -128, -16129, -5181200, -12176, -1015680, -663885, -16728065, -3318692, -10039894, -6632142, -1146130, -16724271, -16711809, -12799119, -16777077, -4343957, -16751616, -8388608, -8355840, -8388480, -16744320, -4684277, -5103070};
        argbsChainHetero = new int[]{-1, -7298865, -8335464, -3174224, -3158160, -3174193, -8339264, -3170208, -4173712, -3821949, -16734257, -4895668, -11094638, -7686870, -4296002, -16730463, -16724113, -13329567, -16777029, -5922981, -16739328, -5242880, -5197824, -5242704, -16731984, -1526253, -4050382};
        FORMAL_CHARGE_COLIX_RED = (short)Elements.elementSymbols.length;
        FORMAL_CHARGE_COLIX_WHITE = (short)(FORMAL_CHARGE_COLIX_RED + 4);
        FORMAL_CHARGE_COLIX_BLUE = (short)(FORMAL_CHARGE_COLIX_WHITE + 7);
        argbsFormalCharge = new int[]{-65536, -49088, -32640, -16192, -1, -2565889, -4934401, -7302913, -9671425, -12039937, -14408449, -16776961};
        FORMAL_CHARGE_INDEX_MAX = argbsFormalCharge.length;
        PARTIAL_CHARGE_COLIX_RED = (short)(FORMAL_CHARGE_COLIX_BLUE + 1);
        PARTIAL_CHARGE_COLIX_WHITE = (short)(PARTIAL_CHARGE_COLIX_RED + 15);
        PARTIAL_CHARGE_COLIX_BLUE = (short)(PARTIAL_CHARGE_COLIX_WHITE + 15);
        argbsRwbScale = new int[]{-65536, -61424, -57312, -53200, -49088, -44976, -40864, -36752, -32640, -28528, -24416, -20304, -16192, -12080, -7968, -1, -2039553, -3092225, -4144897, -5197569, -6250241, -7302913, -8355585, -9408257, -10460929, -11513601, -12566273, -13618945, -14671617, -15724289, -16776961};
        argbsRoygbScale = new int[]{-65536, -57344, -49152, -40960, Short.MIN_VALUE, -24576, -16384, -8192, -4096, -256, -987136, -2031872, -4129024, -6226176, -8323328, -10420480, -12517632, -14614784, -16711936, -16711904, -16711872, -16711840, -16711808, -16711776, -16711744, -16711712, -16711681, -16719617, -16727809, -16736001, -16744193, -16752385, -16760577, -16768769, -16776961};
        argbsIsosurfacePositive = new int[]{-11525984};
        argbsIsosurfaceNegative = new int[]{-6283184};
        specialAtomNames = new String[]{null, "N", "CA", "C", "O", "O1", "O5'", "C5'", "C4'", "C3'", "O3'", "C2'", "C1'", "P", "OD1", "OD2", "OE1", "OE2", "SG", null, null, null, null, null, null, null, null, null, null, null, null, null, "N1", "C2", "N3", "C4", "C5", "C6", "O2", "N7", "C8", "N9", "N4", "N2", "N6", "C5M", "O6", "O4", "S4", "C7", "H1", "H2", "H3", null, null, null, null, null, null, null, null, null, null, null, "OXT", "H", "1H", "2H", "3H", "HA", "1HA", "2HA", "H5T", "O5T", "O1P", "OP1", "O2P", "OP2", "O4'", "O2'", "1H5'", "2H5'", "H4'", "H3'", "1H2'", "2H2'", "2HO'", "H1'", "H3T", "HO3'", "HO5'", "HA2", "HA3", "HA2", "H5'", "H5''", "H2'", "H2''", "HO2'"};
        ATOMID_MAX = specialAtomNames.length;
        htSpecialAtoms = new Hashtable<String, Integer>();
        n = specialAtomNames.length;
        while (--n >= 0) {
            object = specialAtomNames[n];
            if (object == null) continue;
            htSpecialAtoms.put((String)object, n);
        }
        predefinedGroup3Names = new String[]{"", "ALA", "ARG", "ASN", "ASP", "CYS", "GLN", "GLU", "GLY", "HIS", "ILE", "LEU", "LYS", "MET", "PHE", "PRO", "SER", "THR", "TRP", "TYR", "VAL", "ASX", "GLX", "UNK", "G", "C", "A", "T", "U", "I", "DG", "DC", "DA", "DT", "DU", "DI", "+G", "+C", "+A", "+T", "+U", "+I", "NOS", "HOH", "DOD", "WAT", "SOL", "UREA", "PO4", "SO4"};
        argbsShapely = new int[]{-65281, -16777092, -33680, -7536756, -6291390, -144, -46004, -10092544, -1, -9408257, -16757760, -12231099, -12105800, -11318190, -4677566, -11382190, -36798, -4699136, -11581952, -7573428, -29441, -65281, -65281, -65281, -36752, -29621, -6250241, -6226016, -32640, -8323073, -36752, -29621, -6250241, -6226016, -32640, -8323073, -36752, -29621, -6250241, -6226016, -32640, -8323073, -8323073};
        group3List = JmolConstants.getGroup3List();
        group3Count = group3List.length() / 6;
        predefinedGroup1Names = new char[]{'\u0000', 'A', 'R', 'N', 'D', 'C', 'Q', 'E', 'G', 'H', 'I', 'L', 'K', 'M', 'F', 'P', 'S', 'T', 'W', 'Y', 'V', 'A', 'G', '?', 'G', 'C', 'A', 'T', 'U', 'I', 'G', 'C', 'A', 'T', 'U', 'I', 'G', 'C', 'A', 'T', 'U', 'I', 'I'};
        predefinedVariable = new String[]{"@_1H _H & !(_2H,_3H)", "@_12C _C & !(_13C,_14C)", "@_14N _N & !(_15N)", "@water _g>=43 & _g<46, oxygen & connected(2) & connected(2, hydrogen or deuterium or tritium), (hydrogen or deuterium or tritium) & connected(oxygen & connected(2) & connected(2, hydrogen or deuterium or tritium))", "@hoh water", "@solvent water, (_g>=46 & _g<=49)", "@ligand hetero & !solvent", "@turn structure=1", "@sheet structure=2", "@helix structure=3", "@bonded bondcount>0"};
        predefinedStatic = new String[]{"@amino _g>0 & _g<=23", "@acidic asp,glu", "@basic arg,his,lys", "@charged acidic,basic", "@negative acidic", "@positive basic", "@neutral amino&!(acidic,basic)", "@polar amino&!hydrophobic", "@cyclic his,phe,pro,trp,tyr", "@acyclic amino&!cyclic", "@aliphatic ala,gly,ile,leu,val", "@aromatic his,phe,trp,tyr", "@cystine within(group, cys.sg and connected(cys.sg))", "@buried ala,cys,ile,leu,met,phe,trp,val", "@surface amino&!buried", "@hydrophobic ala,gly,ile,leu,met,phe,pro,trp,tyr,val", "@mainchain backbone", "@small ala,gly,ser", "@medium asn,asp,cys,pro,thr,val", "@large arg,glu,gln,his,ile,leu,lys,met,phe,trp,tyr", "@c nucleic & within(group,_a=42)", "@g nucleic & within(group,_a=43)", "@cg c,g", "@a nucleic & within(group,_a=44)", "@t nucleic & within(group,_a=45 | _a=49)", "@at a,t", "@i nucleic & within(group,_a=46) & !g", "@u nucleic & within(group,_a=47) & !t", "@tu nucleic & within(group,_a=48)", "@ions _g=48,_g=49", "@alpha _a=2", "@backbone (protein,nucleic) & (_a>0 & _a<14 || _a>=64)", "@spine protein & _a>0 & _a<= 3 || nucleic & (_a >= 6 & _a <= 10 || _a=13)", "@sidechain (protein,nucleic) & !backbone", "@base nucleic & !backbone", "@dynamic_flatring search('[a]')"};
        shapeClassBases = new String[]{"Balls", "Sticks", "Hsticks", "Sssticks", "Struts", "Labels", "Measures", "Stars", "Halos", "Backbone", "Trace", "Cartoon", "Strands", "MeshRibbon", "Ribbons", "Rockets", "Dots", "Dipoles", "Vectors", "GeoSurface", "Ellipsoids", "Polyhedra", "Draw", "Isosurface", "LcaoCartoon", "MolecularOrbital", "Pmesh", "Plot3D", "Echo", "Axes", "Bbcage", "Uccage", "Hover", "Frank"};
        if (shapeClassBases.length != 34) {
            Logger.error("the shapeClassBases array has the wrong length");
            throw new NullPointerException();
        }
        CARTOON_VISIBILITY_FLAG = JmolConstants.getShapeVisibilityFlag(11);
        BACKBONE_VISIBILITY_FLAG = JmolConstants.getShapeVisibilityFlag(9);
        ALPHA_CARBON_VISIBILITY_FLAG = CARTOON_VISIBILITY_FLAG | BACKBONE_VISIBILITY_FLAG | JmolConstants.getShapeVisibilityFlag(10) | JmolConstants.getShapeVisibilityFlag(12) | JmolConstants.getShapeVisibilityFlag(13) | JmolConstants.getShapeVisibilityFlag(14);
        stereoModes = new String[]{"OFF", "", "REDCYAN", "REDBLUE", "REDGREEN"};
        if (argbsFormalCharge.length != 12) {
            Logger.error("formal charge color table length");
            throw new NullPointerException();
        }
        if (shapeClassBases.length != 34) {
            Logger.error("shapeClassBases wrong length");
            throw new NullPointerException();
        }
        if (argbsAmino.length != 24) {
            Logger.error("argbsAmino wrong length");
            throw new NullPointerException();
        }
        if (argbsShapely.length != 43) {
            Logger.error("argbsShapely wrong length");
            throw new NullPointerException();
        }
        if (argbsChainHetero.length != argbsChainAtom.length) {
            Logger.error("argbsChainHetero wrong length");
            throw new NullPointerException();
        }
        quantumShellTags = new String[]{"S", "P", "SP", "L", "5D", "D", "7F", "F", "9G", "G", "10H", "H"};
        quantumShellIDs = new int[]{0, 1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        shellOrder = new String[][]{{"S"}, {"X", "Y", "Z"}, {"S", "X", "Y", "Z"}, {"d0/z2", "d1+/xz", "d1-/yz", "d2+/x2-y2", "d2-/xy"}, {"XX", "YY", "ZZ", "XY", "XZ", "YZ"}, {"f0/2z3-3x2z-3y2z", "f1+/4xz2-x3-xy2", "f1-/4yz2-x2y-y3", "f2+/x2z-y2z", "f2-/xyz", "f3+/x3-3xy2", "f3-/3x2y-y3"}, {"XXX", "YYY", "ZZZ", "XYY", "XXY", "XXZ", "XZZ", "YZZ", "YYZ", "XYZ"}};
    }
}

