/*
 * Jalview - A Sequence Alignment Editor and Viewer (Version 2.6)
 * Copyright (C) 2010 J Procter, AM Waterhouse, G Barton, M Clamp, S Searle
 * 
 * This file is part of Jalview.
 * 
 * Jalview is free software: you can redistribute it and/or
 * modify it under the terms of the GNU General Public License 
 * as published by the Free Software Foundation, either version 3 of the License, or (at your option) any later version.
 * 
 * Jalview is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty 
 * of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 * PURPOSE.  See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along with Jalview.  If not, see <http://www.gnu.org/licenses/>.
 */
package jalview.gui;

import java.util.*;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.awt.*;

import javax.swing.*;
import javax.swing.event.*;

import java.awt.event.*;
import java.io.*;

import jalview.api.SequenceStructureBinding;
import jalview.bin.Cache;
import jalview.datamodel.*;
import jalview.gui.ViewSelectionMenu.ViewSetProvider;
import jalview.structure.*;
import jalview.io.*;
import jalview.schemes.*;
import fr.orsay.lri.varna.VARNAPanel;
import fr.orsay.lri.varna.exceptions.ExceptionFileFormatOrSyntax;
import fr.orsay.lri.varna.exceptions.ExceptionNonEqualLength;
import fr.orsay.lri.varna.exceptions.ExceptionUnmatchedClosingParentheses;
import fr.orsay.lri.varna.interfaces.InterfaceVARNAListener;
import fr.orsay.lri.varna.models.VARNAConfig;
import fr.orsay.lri.varna.models.annotations.HighlightRegionAnnotation;
import fr.orsay.lri.varna.models.rna.ModeleBaseNucleotide;
import fr.orsay.lri.varna.models.rna.RNA;


public class AppVarna extends JInternalFrame implements InterfaceVARNAListener,SecondaryStructureListener// implements Runnable,SequenceStructureBinding, ViewSetProvider

{
  AppVarnaBinding vab;

  VARNAPanel varnaPanel;
  
  public String name;
  
  public StructureSelectionManager ssm;
  
  /*public AppVarna(){
	  vab = new AppVarnaBinding(); 
	  initVarna();
  }*/
  
 
  
  public AppVarna(String seq,String struc,String name,AlignmentPanel ap){
	  ArrayList<RNA> rnaList = new ArrayList<RNA>();
	  RNA rna1 = new RNA(name);
	  try {
		  rna1.setRNA(seq,replaceOddGaps(struc));
	  } catch (ExceptionUnmatchedClosingParentheses e2) {
		e2.printStackTrace();
	  } catch (ExceptionFileFormatOrSyntax e3) {
		e3.printStackTrace();
	  }
	  rnaList.add(trimRNA(rna1));	  
	  rnaList.add(rna1);
	  //rna1.setName("consensus_"+rna1.getName());
	  
	  
	  vab = new AppVarnaBinding(rnaList);
	  this.name=name;
	  initVarna();
          ssm = ap.getStructureSelectionManager();
	  ssm.addStructureViewerListener(this);
  }
  
  public void initVarna(){
	  //vab.setFinishedInit(false);
	  varnaPanel=vab.get_varnaPanel();
	  setBackground(Color.white);
	  JSplitPane split = new JSplitPane(JSplitPane.HORIZONTAL_SPLIT,true,vab.getListPanel(),varnaPanel);
	  getContentPane().setLayout(new BorderLayout());
	  getContentPane().add(split, BorderLayout.CENTER);
	  //getContentPane().add(vab.getTools(), BorderLayout.NORTH);	
	  varnaPanel.addVARNAListener(this);
	  jalview.gui.Desktop.addInternalFrame(this,"VARNA -"+name,getBounds().width, getBounds().height);
	  this.pack();
	  showPanel(true);
  }
  
  public String replaceOddGaps(String oldStr){
	  String patternStr = "[^([{<>}])]";
      String replacementStr = ".";
      Pattern pattern = Pattern.compile(patternStr);
      Matcher matcher = pattern.matcher(oldStr);
      String newStr=matcher.replaceAll(replacementStr);
	  return newStr;
  }
  
  public RNA trimRNA(RNA rna){
	  RNA rnaTrim = new RNA("trim_"+rna.getName());
	  try {
		  rnaTrim.setRNA(rna.getSeq(),replaceOddGaps(rna.getStructDBN()));
	  } catch (ExceptionUnmatchedClosingParentheses e2) {
		e2.printStackTrace();
	  } catch (ExceptionFileFormatOrSyntax e3) {
		e3.printStackTrace();
	  }

	  StringBuffer seq=new StringBuffer(rnaTrim.getSeq());
	  StringBuffer struc=new StringBuffer(rnaTrim.getStructDBN());
	  for(int i=0;i<rnaTrim.getSeq().length();i++){
		  //TODO: Jalview utility for gap detection java.utils.isGap()
		  //TODO: Switch to jalview rna datamodel
		  if(seq.substring(i, i+1).compareTo("-")==0 || seq.substring(i, i+1).compareTo(".")==0){
			  if(!rnaTrim.findPair(i).isEmpty()){
				  int m=rnaTrim.findPair(i).get(1);
				  int l=rnaTrim.findPair(i).get(0);
				  
				  struc.replace(m, m+1, "*");
				  struc.replace(l, l+1, "*");
			  }else{
				  struc.replace(i, i+1, "*");
			  }
		  }
	  }
	 
	  String newSeq=rnaTrim.getSeq().replace("-", "");
	  rnaTrim.getSeq().replace(".", "");
	  String newStruc=struc.toString().replace("*", "");

	  try {
		rnaTrim.setRNA(newSeq,newStruc);
	  } catch (ExceptionUnmatchedClosingParentheses e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	  } catch (ExceptionFileFormatOrSyntax e) {
		// TODO Auto-generated catch block
		e.printStackTrace();
	  }
	  
	  return rnaTrim;
  }

  public void showPanel(boolean show){
	  this.setVisible(show);
  }
  
  private boolean _started = false;

  public void run(){
	  _started = true;
	  
	  try
      {
        initVarna();
      } catch (OutOfMemoryError oomerror)
      {
        new OOMWarning("When trying to open the Varna viewer!", oomerror);
      } catch (Exception ex)
      {
        Cache.log.error("Couldn't open Varna viewer!", ex);
      }
  }

@Override
public void onUINewStructure(VARNAConfig v, RNA r) {
	// TODO Auto-generated method stub
	
}

@Override
public void onWarningEmitted(String s) {
	// TODO Auto-generated method stub
	
}
/**
 * If a mouseOver event from the AlignmentPanel 
 * is noticed the currently selected RNA in the 
 * VARNA window is highlighted at the specific position. 
 * To be able to remove it before the next highlight
 * it is saved in _lastHighlight
 */
private  HighlightRegionAnnotation _lastHighlight;
@Override
public void mouseOverSequence(SequenceI sequence, int index) {
	// TODO Auto-generated method stub
	RNA rna=vab.getSelectedRNA();
	rna.removeHighlightRegion(_lastHighlight);
	
	HighlightRegionAnnotation highlight = new HighlightRegionAnnotation(rna.getBasesBetween(index,index));
	rna.addHighlightRegion(highlight);
	_lastHighlight=highlight;
	vab.updateSelectedRNA(rna);
}

@Override
public void mouseOverStructure(int atomIndex, String strInfo) {
	// TODO Auto-generated method stub
	
}

@Override
public void onStructureRedrawn()
{
  // TODO Auto-generated method stub
  
}


}
