package jalview.gui;

import javax.swing.JOptionPane;

import jalview.datamodel.PDBEntry;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceI;

/**
 * GUI related routines for associating PDB files with sequences
 * @author JimP
 *
 */
public class AssociatePdbFileWithSeq
{

/**
 * assocate the given PDB file with 
 * @param choice
 * @param sequence
 */
  public PDBEntry associatePdbWithSeq(String choice, String protocol, SequenceI sequence, boolean prompt)
  {
    PDBEntry entry = new PDBEntry();
    try
    {
      MCview.PDBfile pdbfile = new MCview.PDBfile(choice,
              protocol);

      if (pdbfile.id == null)
      {
        String reply = null;
      
        if (prompt) { reply = JOptionPane
                .showInternalInputDialog(
                        Desktop.desktop,
                        "Couldn't find a PDB id in the file supplied."
                                + "Please enter an Id to identify this structure.",
                        "No PDB Id in File", JOptionPane.QUESTION_MESSAGE);}
        if (reply == null)
        {
          return null;
        }

        entry.setId(reply);
      }
      else
      {
        entry.setId(pdbfile.id);
      }
    } catch (java.io.IOException ex)
    {
      ex.printStackTrace();
    }

    entry.setFile(choice);
    sequence.getDatasetSequence().addPDBId(entry);
    return entry;
  }

}
