package jalview.gui;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;

public class JalviewChangeSupport implements PropertyChangeListener
{
  public void propertyChange(PropertyChangeEvent evt)
  {
    // Handle change events - most are simply routed to other sources
    changeSupport.firePropertyChange(evt);
  }

  /**
   * change listeners are notified of changes to resources so they can update
   * their state. E.g. - the 'services' property notifies when the available
   * set of web service endpoints have changed.
   */
  private java.beans.PropertyChangeSupport changeSupport = new java.beans.PropertyChangeSupport(
          this);

  /**
   * @param propertyName
   * @param listener
   * @see java.beans.PropertyChangeSupport#addPropertyChangeListener(java.lang.String,
   *      java.beans.PropertyChangeListener)
   */
  public void addJalviewPropertyChangeListener(String propertyName,
          PropertyChangeListener listener)
  {
    changeSupport.addPropertyChangeListener(propertyName, listener);
  }

  /**
   * @param listener
   * @see java.beans.PropertyChangeSupport#addPropertyChangeListener(java.beans.PropertyChangeListener)
   */
  public void addJalviewPropertyChangeListener(
          PropertyChangeListener listener)
  {
    changeSupport.addPropertyChangeListener(listener);
  }

  /*
   * @param propertyName
   * 
   * @param oldValue
   * 
   * @param newValue
   * 
   * @see
   * java.beans.PropertyChangeSupport#firePropertyChange(java.lang.String,
   * java.lang.Object, java.lang.Object) public void firePropertyChange(String
   * propertyName, Object oldValue, Object newValue) {
   * changeSupport.firePropertyChange(propertyName, oldValue, newValue); }
   */

  /**
   * @param propertyName
   * @param listener
   * @see java.beans.PropertyChangeSupport#removePropertyChangeListener(java.lang.String,
   *      java.beans.PropertyChangeListener)
   */
  public void removeJalviewPropertyChangeListener(String propertyName,
          PropertyChangeListener listener)
  {
    changeSupport.removePropertyChangeListener(propertyName, listener);
  }

}