package jalview.io.packed;

/**
 * API for a data provider that can be used with jalview.io.packed.ParsePackedSet
 * @author JimP
 *
 */
public interface DataProvider
{
  /**
   * class of data expected to be provided by datasource
   * @author JimP
   *
   */
  public enum JvDataType
  {
    /**
     * any alignment flatfile recognisable by jalview.io.IdentifyFile
     */
    ALIGNMENT,
    /**
     * a jalview annotation file
     */
    ANNOTATION, 
    /**
     * a GFF or Jalview features file 
     */
    FEATURES,
    /**
     * a tree representation understood by the NewickFile parser
     */
    TREE,
    /**
     * any file that provides data that should be associated with a specified sequence.
     */
    SEQASSOCATED;
  }

  /**
   * data to be parsed according to its type. Each call to getDataSource
   * should return a new instance of the same data stream initialised to the
   * beginning of the chunk of data that is to be parsed.
   * 
   * @return
   */
  jalview.io.FileParse getDataSource();

  /**
   * association context for data. Either null or a specific sequence.
   * 
   * @return
   */
  Object getSequenceTarget();

  /**
   * type of data
   * 
   * @return
   */
  DataProvider.JvDataType getType();
}