package jalview.io.packed;

import jalview.io.FileParse;

/**
 * minimal implementation of the DataProvider interface.
 * Allows a FileParse datasource to be specified as one of the DataProvider.JvDataType content types, with or without some other associated object as external reference.
 */
public class SimpleDataProvider implements DataProvider
{
  DataProvider.JvDataType jvtype;

  FileParse source;

  Object assocseq;

  /**
   * create a SimpleDataProvider
   * @param type - contents of resource accessible via fp
   * @param fp - datasource
   * @param assoc - external object that fp's content should be associated with (may be null)
   */
  public SimpleDataProvider(DataProvider.JvDataType type, FileParse fp,
          Object assoc)
  {
    jvtype = type;
    source = fp;
    assocseq = assoc;
  }

  @Override
  public FileParse getDataSource()
  {
    return source;
  }

  @Override
  public Object getSequenceTarget()
  {
    return assocseq;
  }

  @Override
  public DataProvider.JvDataType getType()
  {
    return jvtype;
  }

}