package jalview.javascript;

import java.util.Vector;

import jalview.appletgui.AlignFrame;
import jalview.bin.JalviewLite;
import jalview.datamodel.SequenceI;
import jalview.structure.VamsasListener;
import jalview.structure.VamsasSource;
import netscape.javascript.JSObject;

public class MouseOverListener extends JSFunctionExec implements
        VamsasListener, JsCallBack
{
  AlignFrame _af;

  String _listener;

  SequenceI last = null;

  int i = -1;

  public void mouseOver(SequenceI seq, int index, VamsasSource source)
  {
    if (seq != last || i != index)
    {
      // this should really be a trace message.
      // Cache.log.debug("Mouse over " + v.getId() + " bound to "
      // + seq + " at " + index);
      last = seq;
      i = index;
      AlignFrame src = null;
      try
      {
        if (source != null)
        {
          if (source instanceof jalview.appletgui.AlignViewport
                  && ((jalview.appletgui.AlignViewport) source).applet.currentAlignFrame.viewport == source)
          {
            // should be valid if it just generated an event!
            src = ((jalview.appletgui.AlignViewport) source).applet.currentAlignFrame;

          }
          // TODO: ensure that if '_af' is specified along with a handler function, then only events from that alignFrame are sent to that function
        }
        executeJavascriptFunction(_listener, new Object[]
        { src, seq.getDisplayId(false), "" + (1 + i), ""+seq.findPosition(i) });
      } catch (Exception ex)
      {

        System.err
                .println("JalviewLite javascript error: Couldn't send mouseOver with handler '"
                        + _listener + "'");
        if (ex instanceof netscape.javascript.JSException)
        {
          System.err.println("Javascript Exception: "
                  + ((netscape.javascript.JSException) ex).getMessage());
        }
        ex.printStackTrace();
      }
    }
  }

  public MouseOverListener(JalviewLite applet, AlignFrame af,
          String listener)
  {
    super(applet);
    _af = af;
    _listener = listener;
  }

  @Override
  public AlignFrame getAlignFrame()
  {
    return _af;
  }

  @Override
  public String getListenerFunction()
  {
    return _listener;
  }

}
