package jalview.structure;


/**
 * holder for script commands generated for a particular structure mapping
 * @author jimp
 *
 */
public class StructureMappingcommandSet {
  /**
   * structure file for which these commands were generated
   */
  public String mapping;
  /**
   * set of commands
   */
  public String[] commands;
  /**
   * some object that indicates what the commands can be parsed by (eg JmolCommands.class implies these are Jmol commands)
   */
  public Object handledBy;
  /**
   * record the originating command generator, the structure mapping involved, and the set of commands to be passed.
   * @param handledBy
   * @param files
   * @param commands
   */
  public StructureMappingcommandSet(Object handledBy, String files, String[] commands)
  {
    this.mapping=files;
    this.handledBy=handledBy;
    this.commands=commands;
  }
}
