package jalview.ws.io.mime;

import jalview.io.packed.DataProvider.JvDataType;

/**
 * static functions for resolving Jalview datatypes from mime types 
 * @author JimP
 * TODO: consider making get(Mime)TypeOf functions throw exceptions rather than returning null
 */
public class MimeTypes
{
  /**
   * pair list {String,JvDataType} giving a mime-type followed by its associated JvDataType enumeration.
   */
  final public static Object[] typemap = new Object[] {
    "application/x-align",JvDataType.ALIGNMENT,
    "application/x-jalview-annotation",JvDataType.ANNOTATION,
    "application/x-newick",JvDataType.TREE,
    "application/x-new-hampshire",JvDataType.TREE,
    "application/x-new-hampshire-extended",JvDataType.TREE,
    "application/x-nh",JvDataType.TREE,
    "application/x-nhx",JvDataType.TREE,
    "application/x-gff",JvDataType.FEATURES,
    "application/x-gff3",JvDataType.FEATURES,
    "application/x-jalview-feature-file",JvDataType.FEATURES,
    "application/x-pdb",JvDataType.SEQASSOCATED};
  /**
   * 
   * @param mimeType
   * @return the associated jalview datatype or null if no mapping is available
   */
  public static JvDataType getTypeOf(String mimeType)
  {
    String mt = mimeType.toLowerCase();
    for (int i=0;i<typemap.length;i+=2)
    {
      if (typemap[i].equals(mt))
      {
        return (JvDataType) typemap[i+1];
      }
    }
    return null;
  }
  
  /**
   * 
   * @param type
   * @return the primary mimetype associated with this type.
   */
  public static String getMimeTypeOf(JvDataType type)
  {
    for (int i=1;i<typemap.length;i+=2)
    {
      if (typemap[i].equals(type))
      {
        return (String) typemap[i-1];
      }
    }
    return null;
  }
}