package jalview.ws.rest;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;

import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

import sun.io.CharacterEncoding;
import sun.misc.CharacterEncoder;

/***
 * InputType is the abstract model of each input parameter that a rest service might take.
 * It enables the engine to validate input by providing 
 * { formatter for type, parser for type }
 *  
 */
public abstract class InputType {
  /**
   * not used yet
   */
  boolean replaceids;
  public enum molType { NUC, PROT, MIX}
  public String token;
  public int min=1;
  public int max=0; // unbounded
  protected ArrayList<Class> inputData=new ArrayList<Class>();
  /**
   * initialise the InputType with a list of jalview data classes that the RestJob needs to be able to provide to it. 
   * @param types
   */
  protected InputType(Class[] types)
  {
    if(types!=null)
      {for (Class t:types)
    {
      inputData.add(t);
    }
      }
  }
  /**
   * do basic tests to ensure the job's service takes this parameter, and the job's input data can be used to generate the input data 
   * @param restJob
   * @return
   */
  public boolean validFor(RestJob restJob)
  {
    if (!validFor(restJob.rsd))
      return false;
    for (Class cl:inputData)
    {
      if (!restJob.hasDataOfType(cl))
      {
        return false;
      }
    }
    return true;
  }
  
  public boolean validFor(RestServiceDescription restServiceDescription)
  {
    if (!restServiceDescription.inputParams.values().contains(this))
      return false;
    
    return true;
  }
  protected ContentBody utf8StringBody(String content, String type)
  {
    Charset utf8 = Charset.forName("UTF-8");
    try {
    if (type==null ) {
      return new StringBody(utf8.encode(content).asCharBuffer().toString());
    } else {
      return new StringBody(utf8.encode(content).asCharBuffer().toString(), type, utf8);
    }
    } catch (Exception ex)
    {
      System.err.println("Couldn't transform string\n"+content+"\nException was :");
      ex.printStackTrace(System.err);
    }
    return null;
  }
  /**
   * 
   * @param rj data from which input is to be extracted and formatted
   * @return StringBody or FileBody ready for posting
   */
  abstract public ContentBody formatForInput(RestJob rj) throws UnsupportedEncodingException,NoValidInputDataException;
  /**
   * 
   * @return true if no input data needs to be provided for this parameter
   */
  public boolean isConstant()
  {
    return (inputData==null || inputData.size()==0);
  }
}