package jalview.ws.rest.params;

import jalview.datamodel.AlignmentI;
import jalview.ws.rest.InputType;
import jalview.ws.rest.NoValidInputDataException;
import jalview.ws.rest.RestJob;
import jalview.ws.rest.InputType.molType;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;

import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.entity.mime.content.StringBody;

/**
 * format an alignment for input to rest service.
 * @author JimP
 *
 */
public class Alignment extends InputType {
  public Alignment()
  {
    super(new Class[] { AlignmentI.class} );
  }

  String format="FASTA";
  molType type;
  boolean jvsuffix=false;
  /**
   * input data as a file upload rather than inline content
   */
  public boolean writeAsFile;
  @Override
  public ContentBody formatForInput(RestJob rj) throws UnsupportedEncodingException, NoValidInputDataException
  {
    AlignmentI alignment = rj.getAlignmentForInput(token,type);
    if (writeAsFile)
    {
    try {
      File fa = File.createTempFile("jvmime", ".fa");
      PrintWriter pw = new PrintWriter(new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(fa)), "UTF-8"));
      pw.append(new jalview.io.FormatAdapter().formatSequences(format, alignment, jvsuffix));
      pw.close();
      return new FileBody(fa, "text/plain");
    } catch (Exception ex)
    {
      throw new NoValidInputDataException("Couldn't write out alignment to file.",ex);
    }
    } else {
      jalview.io.FormatAdapter fa = new jalview.io.FormatAdapter();
      fa.setNewlineString("\r\n");
      return new StringBody((fa.formatSequences(format, alignment, jvsuffix)));
      //,
      //"text/plain",Charset.forName("UTF-8"));
      // , "text/plain", Charset.forName("UTF-8"));
    // sb.getContentTypeParameters().put("filename", "alignment.fa");
    }
  }
}