package jalview.ws.rest.params;

import jalview.datamodel.AlignmentI;
import jalview.ws.rest.InputType;
import jalview.ws.rest.NoValidInputDataException;
import jalview.ws.rest.RestJob;
import jalview.ws.rest.InputType.molType;

import java.io.UnsupportedEncodingException;

import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

/**
 * format a jalview annotation file for input to a rest service.
 * @author JimP
 *
 */
public class AnnotationFile extends InputType {
  public AnnotationFile()
  {
    super(new Class[] { AlignmentI.class} );
  }
  /**
   * standard jalview annotation file
   */
  final String JVANNOT="JalviewAnnotation";
  /**
   * export annotation row as simple csv
   */
  final String CSVANNOT="CsvAnnotationRow";
  /**
   * format of annotation file
   */
  String format=JVANNOT;
  // TODO verify annotation file format enumeration
  @Override
  public ContentBody formatForInput(RestJob rj) throws UnsupportedEncodingException, NoValidInputDataException
  {
    AlignmentI al = rj.getAlignmentForInput(token,molType.MIX);
    if (format.equals(JVANNOT))
      {return new StringBody(new jalview.io.AnnotationFile().printAnnotations(al.getAlignmentAnnotation(),
            al.getGroups(),al.getProperties()));
      } else {
        if (!format.equals(CSVANNOT))
        {
          throw new UnsupportedEncodingException("Unrecognised format for exporting Annotation ("+format+")");
        }
        return new StringBody(new jalview.io.AnnotationFile().printCSVAnnotations(al.getAlignmentAnnotation()));
      }
  }
}