package jalview.ws.rest.params;

import jalview.ws.rest.InputType;
import jalview.ws.rest.NoValidInputDataException;
import jalview.ws.rest.RestJob;

import java.io.UnsupportedEncodingException;

import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

/**
 * defines a constant value always provided as a parameter.
 * @author JimP
 *
 */
public class JobConstant extends InputType
{

  String value;
  /**
   * 
   * @param param name of parameter
   * @param val value of parameter
   */
  public JobConstant(String param, String val)
  {
    // needs no data from the restJob
    super(null);
    this.token = param;
    value = val;
  }

  @Override
  public ContentBody formatForInput(RestJob rj)
          throws UnsupportedEncodingException, NoValidInputDataException
  {
    
    return new StringBody(value);
  }

}
