package jalview.ws.rest.params;

import jalview.datamodel.AlignmentI;
import jalview.datamodel.SequenceI;
import jalview.ws.rest.InputType;
import jalview.ws.rest.NoValidInputDataException;
import jalview.ws.rest.RestJob;
import jalview.ws.rest.InputType.molType;

import java.io.UnsupportedEncodingException;

import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.StringBody;

/**
 * input a list of sequence IDs separated by some separator 
 * @author JimP
 *
 */
class SeqIdVector extends InputType {
  public SeqIdVector()
  {
    super(new Class[] { AlignmentI.class} );
  }

  /**
   * separator for list of sequence IDs - default is ','
   */
  String sep=",";
  molType type;
  @Override
  public ContentBody formatForInput(RestJob rj) throws UnsupportedEncodingException, NoValidInputDataException
  {
    StringBuffer idvector = new StringBuffer();
    boolean list=false;
    for (SequenceI seq:rj.getSequencesForInput(token, type))
    {
      if (list)
      {
        idvector.append(sep);
      }
      idvector.append(seq.getName());
    }
    return new StringBody(idvector.toString());
  }
}