#include <stdlib.h>
#include <stdio.h>
#include "gjutil.h"
#include "array.h"

int Agetbloc(FILE *,struct seqdat *,int *);

int MAXtlen = 500;
int MAXnbloc = 500;
int MAXilen = 50;
int precis = 100;
int MAXslen = 8000;
int MAXnseq;

/* alsnum:  Aim - produce TEXT commands for ALSCRIPT that will generate numbers
   corresponding to a given sequence in the blockfile.

   Usage:

   alsnum  <seqnum> <startnum> <interval> <position> < blockfile > output

   Where:

   seqnum:    The number of the sequence in the blockfile.
   
   startnum:  The number to use for the first residue in the sequence (e.g. 1).

   interval:  The numbering interval (e.g. 10).

   position:  Where to place the text in the alscript output (ie the Y coordinate).


   ALL ARGUMENTS ARE REQUIRED


   G. J. Barton (25 May 1993).

   $Id$
   $Log$

*/

main(int argc,char *argv[])

{

  extern FILE *std_in,*std_out,*std_err;
  extern int MAXtlen,MAXnbloc;
  extern int MAXilen,precis,MAXslen;

  int seqnum,startnum,interval,position;
  int nseq;
  int *nums;
  int nval;
  int i;

  struct seqdat *bloc;

  GJinitfile();

  if(argc != 5){
    fprintf(std_err,
    "Usage:    alsnum  <seqnum> <startnum> <interval> <position> < blockfile > output\n");
    exit(0);
  }

  seqnum = atoi(argv[1]);
  startnum = atoi(argv[2]);
  interval = atoi(argv[3]);
  position = atoi(argv[4]);

  nseq = 0;
  bloc = (struct seqdat *) malloc(sizeof(struct seqdat) * MAXnbloc);
  mcheck((char *) bloc,"Cannot get space for bloc");
  if(!Agetbloc(std_in,bloc,&nseq))error("Cannot read bloc file",1); 

  /* have read block file */

  nums = (int *) GJmalloc(sizeof(int) * bloc[seqnum].slen);

  nval = startnum;

  /* get the array of numbers - use blank . or - as non-amino acid character */
  for(i=1;i<bloc[seqnum].slen-1;++i){
    if(bloc[seqnum].seq[i] == ' ' ||
       bloc[seqnum].seq[i] == '.' ||
       bloc[seqnum].seq[i] == '-' ){
      nums[i] = 0;
    }else{
      nums[i] = nval;
      ++nval;
    }
  }

  
  /* now go down the array and output TEXT commands at interval intervals */

  fprintf(std_out,"# Text commands created for numbering\n");
  fprintf(std_out,"# Sequence Number: %d\n",seqnum);
  fprintf(std_out,"# Starting Number: %d\n",startnum);
  fprintf(std_out,"# Interval:        %d\n",interval);
  fprintf(std_out,"# Position:        %d\n",position);
  
  for(i=1;i<bloc[seqnum].slen-1;++i){
    if(nums[i] != 0 && (float) (nums[i]/interval) == (float)nums[i]/(float)interval){
      fprintf(std_out,"TEXT %d %d \"%d\"\n",i,position,nums[i]);
    }
  }

  exit(0);
}
  









