/****************************************************************************

 ALSCRIPT - Sequence alignment to PostScript

   Copyright:  University of Oxford (1992,1993)

TERMS OF USE:

The computer software and associated documentation called ALSCRIPT hereinafter
referred to as the WORK is more particularly identified and described in 
Appendix A.

The WORK was written and developed by: Geoffrey J. Barton

Laboratory of Molecular Biophysics
University of Oxford
Rex Richards Building
South Parks Road
Oxford OX1 3QU
U.K.

Tel:  (+44) 865-275368
Fax:  (+44) 865-510454

Internet: gjb@bioch.ox.ac.uk
Janet:    gjb@uk.ac.ox.bioch

The WORK is Copyright (1993) University of Oxford

Administrative Offices
Wellington Square
Oxford OX1 2JD
U.K.

CONDITIONS:

The WORK is made available for educational and non-commercial research 
purposes.

For commercial use, a commercial licence is required - contact the author
at the above address for details.


The WORK may be modified, however this text, all copyright notices and
the authors' address must be left unchanged on every copy, and all
changes must be documented after this notice.  A copy of the
modified WORK must be supplied to the author.

All use of the WORK must cite:  Barton, G. J. (1993), ALSCRIPT: A Tool to
Format Multiple Sequence Alignments, Protein Engineering, Volume 6, No. 1, 
pp. 37-40.

APPENDIX A:

The program package known as ALSCRIPT is made up of the following files:

README     	This copyright notice
EXAMPLE.BLC     Example block file
EXAMPLE.COM     Example command file
EXAMPLE1.BLC    Example block file
EXAMPLE1.COM    Example command file
EXAMPLE2.COM    Example command file
EXAMPLE3.COM    Example command file
ALSCRIPT.EXE    ALSCRIPT executable program
MSF2BLC.EXE     GCG MSF to BLOCK file conversion program
CLUS2BLC.EXE    CLUSTAL PIR file to BLOCK file conversion program
EXAMPLE1.PS     Example output of program
ALSCRIPT.DOC    Documentation
MAKEFILE        Makefile for programs
MAKEFILE.GCC    Makefile for GCC compiler
MAKEFILE.SGI    Makefile for Silicon Graphics 
MAKEFILE.WAT    Makefile for WATCOM 386 C compiler
AGETBLOC.C      Source code for block file reading routine
ALPS.C          Source code for main ALSCRIPT routines
ARRAY.H         Header file
CLUS2BLC.C      Source code for CLUSTAL PIR file to BLOCK file conversion program
DEFAULTS.H      Header file
GJUTIL.C        Source code for utility routines
GJUTIL.H        pHeader file for utility routines
MSF2BLC.C       Source code for GCG MSF to BLOCK file conversion program
MAKEFILE.SUN    Makefile for Sun acc compiler.
ALSCRIPT.C      Source code for ALSCRIPT main program

****************************************************************************

ALSCRIPT is a program for producing pretty versions of multiple sequence aligments.
ALSCRIPT will also format single sequences.
A full description of the program is given in the file "alscript.doc".

Ways of running alscript:

1.  Interactive mode:  just type alscript.
    You will be prompted for a command file name.  The command file will
    define the AMPS blocfile, and name of the file to store the PostScript
    output - see alscript.doc for details.
    
2.  alscript <command_file> has same effect as 1, But does not prompt for the command file
    e.g.  alscript example1.com

3.  alscript -q < <blocfile> > <PostScript>
    Quick mode - uses default commands, reads alignment from stdin, writes PostScript
    to stdout.
    e.g. alscript -q < example1.blc > example1.ps
    
4.  alscript -f <command_file>
    Similar effect to 2.

5.  alscript -f <command_file> -s
    Silent operation:  No messages are written to stderr, unless fatal.
    Silent operation may be toggled by the silent_mode command in the command file.

6.  alscript -f <command_file> -p < <blocfile> > <PostScript>
    Make alscript work like a pipe - blocfile is read from stdin, postscript is written
    to stdout.  Messages are written to stderr.  To supress messages include
    the -s flag too
    e.g. alscript -f example1.com -p -s < example1.blc > example1.ps

Using alscript as a pipe has the advantage of allowing the blocfile to
be created on the fly by the programs msf2blc or clus2blc.  For example
if we have a GCG .msf file called "pileup.msf" we can run alscript with
default shading/fonts and send the results straight to the PostScript
printer "lpr" as follows:

msf2blc -q < pileup.msf | alscript -q -s | lpr

See alps.c for revision history;
fprintf(std_err,"\n Version 2.0 - 23 May 1995\n");

*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "array.h"
#include "gjutil.h"

int MAXtlen = 500;
int MAXnbloc = 500;
int MAXilen = 50;
int precis = 100;
int MAXslen = 8000;
int MAXnseq;

void ALwritestddefs(FILE *);
int alps(char *command_file,int silent, int pipe, int single);

main(int argc,char *argv[])
{
  char *alps_file;
  int silent;
  int quick;
  int i;
  int pipe;
  int singlepage; /* flag for EPS output */
  FILE *fp;

  extern FILE *std_out,*std_err,*std_in;

  silent = 0;
  quick = 0;
  pipe = 0;

  alps_file = NULL;
  
  /* initialize the file streams for GJ... routines */
  GJinitfile();
  
  if(argc > 1){
    /* check for -f option - if present, then define name for command file */
    i = 1;
    while(i<argc){
        if(argv[i][0] == '-'){
            if(strcmp(argv[i],"-f")==0){
                /* command file name */
                alps_file = GJstrdup(argv[++i]);
            }else if(strcmp(argv[i],"-s")==0){
                /* silent mode */
                silent = 1;
            }else if(strcmp(argv[i],"-q")==0){
                /* quick mode - defines its own command file */
                quick = 1;
                pipe = 1;
            }else if(strcmp(argv[i],"-p")==0){
                /* send all output to std_out rather than the file defined in the command file */
                pipe = 1;
                silent = 1;
            }else if(strcmp(argv[i],"-single")==0){
                /* single page mode - will generate a BoundingBox */
		singlepage = 1;
            }
            ++i;
        }else if(i == 1){
            /* we have just defined the alscript command file */
            alps_file = GJstrdup(argv[1]);
            break;
        }
    }
  }

  if(!silent){    
    fprintf(std_err,"\nALSCRIPT  (ALignment to PostScript)\n");

    fprintf(std_err,"Version 2.0 -  23 May 1995\n");
    fprintf(std_err,"\nSee ALSCRIPT.DOC for details\n");

    fprintf(std_err,"\nPlease Reference: Barton, G. J. (1993), Protein Engineering, 6, 37-40.\n");

    fprintf(std_err,"\nBy: G. J. Barton\n");
    fprintf(std_err,"Laboratory of Molecular Biophysics\n");
    fprintf(std_err,"South Parks Road\n");
    fprintf(std_err,"Oxford OX1 3QU\n");
    fprintf(std_err,"\nCopyright: University of Oxford (1992)\n\n");

    fprintf(std_err,"Initial Defaults:\n");
    fprintf(std_err,"Maximum number of sequences:\t %d \t(Change using MAX_NSEQ command)\n",MAXnbloc);
    fprintf(std_err,"Maximum sequence length:\t %d \t(Change using MAX_SEQ_LEN command)\n",MAXslen);
    fprintf(std_err,"Maximum identifier length:\t %d \t(Change using MAX_ID_LEN command)\n",MAXilen);
  }

  if(alps_file == NULL && !quick){
    fprintf(std_err,"Enter ALscript Command File name: ");
    alps_file = (char *) GJmalloc(sizeof(char) * MAXtlen);
    fscanf(std_in,"%s",alps_file);
  }

  if(quick){
    /* create an alscript command file */
    fp = GJfopen("ALPSQ.COM","w",1);
    ALwritestddefs(fp);
    GJfclose(fp,1);
    alps_file = GJstrdup("ALPSQ.COM");
  }

  if(!silent)fprintf(std_err,"ALscript Command File: %s\n",alps_file);

  if(alps(alps_file,silent,pipe,singlepage) == 1){
    if(!silent)fprintf(std_err,"ALscript Finished\n");
    exit(0);
  }else{
    error("Error in ALscript",1);
  }
}

/* Write an alscript command file with some standard definitions */

void ALwritestddefs(FILE *alps_file)
{
    fprintf(alps_file,"#ALSCRIPT - Default definitions\n");
    fprintf(alps_file,"#For explanation of commands see file: alscript.doc\n");
    fprintf(alps_file,"#Input from stdin and output to stdout by default\n");
    fprintf(alps_file,"#block_file ?\n");
    fprintf(alps_file,"#output_file ?\n");
    fprintf(alps_file,"landscape\n");
    fprintf(alps_file,"number_seqs\n");
    fprintf(alps_file,"pointsize 8\n");
    fprintf(alps_file,"define_font 0 Helvetica DEFAULT\n");
    fprintf(alps_file,"define_font 1 Helvetica REL 0.5 \n");
    fprintf(alps_file,"define_font 2 Helvetica-Bold DEFAULT\n");
    fprintf(alps_file,"define_font 3 Times-Bold DEFAULT\n");
    fprintf(alps_file,"define_font 4 Helvetica-BoldOblique DEFAULT\n");
    fprintf(alps_file,"setup\n");
    fprintf(alps_file,"mask SETUP\n");
    fprintf(alps_file,"mask LEGAL \"ARNDCQEGHILKMFPSTWYVBZX\"\n");    
    fprintf(alps_file,"mask FRE ALL\n");
    fprintf(alps_file,"mask SHADE ALL 0\n");
    fprintf(alps_file,"mask INVERSE ALL\n");
    fprintf(alps_file,"mask SHADE ALL 0\n");
    fprintf(alps_file,"mask RESET\n");
    fprintf(alps_file,"#shade_chars GP ALL 0\n");
    fprintf(alps_file,"#inverse_chars GP ALL \n");
    fprintf(alps_file,"#shade_chars LIVAWYFM ALL 0.8 \n");
    fprintf(alps_file,"font_chars DEKRH ALL 4\n");
}



