# include "includes.h"

/**** Produce Alscript code for summary alignmnet ****/

/* Control Variables:  	ps	 font point size 
			shade    shade the alignmnet?
			color    do the alignment shading in color?
			neg      consider negative conservation?
			gcut     number of gaps ignorable
			hist     produce conservation histogram not numbers
			hscale   number of lines for each part of histogram
			port     page orientation is portrait
			mask     mask unconserved residues                    */

/* Data Variables:	diff	 array containing difference information
			intcons  array of cluster pair conservation information
			bloc     structure containing original alignment
			cl       structure containing cluster subgroupings
			noclust  number of clusters considered
			pno	 number of properties considered
			count    length of alignment in alignment positions
			consval  conservation "cutoff"
			point    max number of conserved properties held
			blocfile name of alignment analysis series
                        pname    name of proeprty index	
                        def      defaults settings		      */

void interalsc(diff,intcons,bloc,cl,noclust,ptype,count,consval,point,def,blocfile,
          pname,aa,ps,shade,color,neg,gcut,hist,hscale,port,mask,ss,nostruct,
          aloff,strcr,atyp,nnote,other)

char *pname,*blocfile,*strcr,*nnote;
int nostruct,noclust,consval,count,shade,atyp,other;
int neg,point,gcut,hist,hscale,mask,color,aloff;
int **intcons,**diff,aa;
float ps;
struct slist ptype;
struct indclust *cl;
struct indclust *ss;
struct seqdat *bloc;
struct defaults def;
{ 
  FILE  *out;
  int mu,ml,tvar;
  int abloc=0,*ab,*bb,bbloc=0,nn=0;
  char *soaname,*blcname,*psname,*alcom,*bbsto;

  bbsto = (char*) malloc (sizeof(char*)*(count+1));
  for(mu=0;mu<count+1;++mu)bbsto[mu]=0;


  if(hist==1){aa=0;nn=hscale+1;}
  if(hist==-1){aa=0;nn=0;}
 
  ab = (int*) malloc (sizeof(int)*(noclust+1));
  for(ml=1;ml<noclust+1;++ml){
    ab[ml]=abloc;
    abloc=abloc+cl[ml].number;
  }

  bb = (int*) malloc (sizeof(int)*(nostruct+1));
  for(ml=1;ml<nostruct+1;++ml)bb[ml]=0;bbloc=0;
  if(nostruct!=0)for(ml=1;ml<nostruct+1;++ml){
    bb[ml]=bbloc;
    bbloc=bbloc+ss[ml].number;
  }

/******************************************************************************/
/* Alscript initialisation parameters set				      */
/******************************************************************************/

  soaname = (char*) malloc(sizeof(char)*(strlen(blocfile)+5));
  strcpy(soaname,blocfile);
  strcat(soaname,".soa");
  soaname[strlen(blocfile)+4] = '\0';
  if((out=fopen(soaname,"w"))==NULL){
    printf("Error: cant open file %s\n",soaname);
    exit(0);
  }
  fprintf(out,"#\n");
  fprintf(out,"# AMAS analysis Alscript command file\n");
  fprintf(out,"#\n");
  fprintf(out,"# Commands initialising Alscript setup parameters\n");
  fprintf(out,"#\n");

  blcname = (char*) malloc(sizeof(char)*(strlen(blocfile)+5));
  strcpy(blcname,blocfile);
  strcat(blcname,".blc");
  blcname[strlen(blocfile)+4] = '\0';
  fprintf(out,"BLOCK_FILE %s\n",blcname); 
  psname = (char*) malloc(sizeof(char)*(strlen(blocfile)+4));
  strcpy(psname,blocfile);
  strcat(psname,".ps");
  psname[strlen(blocfile)+3] = '\0';
  fprintf(out,"OUTPUT_FILE %s\n",psname);

  if(port==0){fprintf(out,"LANDSCAPE\n");}else fprintf(out,"PORTRAIT\n");

  fprintf(out,"POINTSIZE %0.1f\n",ps);

  for(ml=0;ml<4;++ml){
    fprintf(out,"%s",def.font[ml]);
  }
  fprintf(out,"DEFINE_FONT 4 Times-BoldItalic REL 1.6\n");
  for(ml=1;ml<10;++ml){
    fprintf(out,"%s",def.cols[ml]);
  }
  fprintf(out,"SETUP\n");
 


/******************************************************************************/
/* Box the whole diagram & present data at foot of alscript page	      */
/******************************************************************************/

  for(ml=1;ml<noclust+1;++ml){ 
    fprintf(out,"BOX_REGION %d %d %d %d\n",
            1,ab[ml]+1,count,ab[ml]+cl[ml].number);
  }


  if(nostruct!=0)for(ml=1;ml<nostruct+1;++ml){ 
    fprintf(out,"BOX_REGION %d %d %d %d\n",
            1,abloc+bb[ml]+1,count,abloc+bb[ml]+ss[ml].number);
    if(shade==1){
      fprintf(out,"SHADE_CHARS HGhg %d %d %d %d %0.2f\n",
                   1,abloc+bb[ml]+1,
                   count,abloc+bb[ml]+ss[ml].number,
                   def.grey[5]);
      fprintf(out,"SHADE_CHARS Ee %d %d %d %d %0.2f\n",
                   1,abloc+bb[ml]+1,
                   count,abloc+bb[ml]+ss[ml].number,
                   def.grey[1]);
      fprintf(out,"CCOL_CHARS c %d %d %d %d %d\n",
                   1,abloc+bb[ml]+1,
                   count,abloc+bb[ml]+ss[ml].number,
                   9);
    } else if(color==1){
      fprintf(out,"SCOL_CHARS HGhg %d %d %d %d %d\n",
                   1,abloc+bb[ml]+1,
                   count,abloc+bb[ml]+ss[ml].number,
                   1);
      fprintf(out,"SCOL_CHARS EeBb %d %d %d %d %d\n",
                   1,abloc+bb[ml]+1,
                   count,abloc+bb[ml]+ss[ml].number,
                   2);
      fprintf(out,"SCOL_CHARS c %d %d %d %d %d\n",
                   1,abloc+bb[ml]+1,
                   count,abloc+bb[ml]+ss[ml].number,
                   5);
    }
    fprintf(out,"CCOL_CHARS HhGg %d %d %d %d %d\n",
                 1,abloc+bb[ml]+1,
                 count,abloc+bb[ml]+ss[ml].number,9);
    fprintf(out,"SURROUND_CHARS HGhg %d %d %d %d\n",
                 1,abloc+bb[ml]+1,
               count,abloc+bb[ml]+ss[ml].number);
    fprintf(out,"SURROUND_CHARS EeBb %d %d %d %d\n",
                 1,abloc+bb[ml]+1,
                 count,abloc+bb[ml]+ss[ml].number);
    fprintf(out,"SURROUND_CHARS T %d %d %d %d\n",
                 1,abloc+bb[ml]+1,
                 count,abloc+bb[ml]+ss[ml].number);
  }



  
  if(shade==1){fprintf(out,"SHADE_REGION %d %d %d %d %0.2f\n",
                      1,1,count,abloc,def.grey[1]);}
  else if(color==1)fprintf(out,"COLOUR_REGION  %d %d %d %d %d\n",
                      1,1,count,abloc,2);

  fclose(out);

  if(hist==0)hshade0(soaname,abloc+bbloc,aa,count,diff,consval,color);
  if(hist==1)
    hshade1(soaname,abloc+bbloc,count,nn,color,def.grey[3],def.grey[4],noclust);

/******************************************************************************/
/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx	      */
/******************************************************************************/

  abscons(bloc,cl,intcons,point,ptype.pno,gcut,color,
          abloc,aa,noclust,neg,count,soaname,bbsto,shade,def);

/******************************************************************************/
/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx	      */
/******************************************************************************/

  cons(count,intcons,cl,color,consval,mask,ptype.pno,ab,neg,
       shade,point,noclust,soaname,def,bbsto);

/******************************************************************************/
/* xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx	      */
/******************************************************************************/

  tucp(noclust,count,intcons,cl,consval,mask,
       color,abloc,shade,ab,soaname,ml,def);

/******************************************************************************/
/* deal with titles at foot of diagram and AMAS symbol			      */
/******************************************************************************/

  printf("Execution: ALSCRIPT running - ");
  printf("prevents reports of execution to screen\n");

  if((out=fopen(soaname,"a"))==NULL){
    printf("Error: cant open file %s\n",soaname);
    exit(0);
  }

  fprintf(out,"#\n");
  fprintf(out,"# Alscript commands for labelling operations only\n");
  fprintf(out,"#\n");


  tvar = 0;
  tvar = tvar +abloc+bbloc;
  if(noclust!=1){
    tvar = tvar + (2*aa);
    tvar = tvar + (2*nn);
  } else{
    tvar = tvar + aa;
    tvar = tvar + nn;
  }

/*  printf("Execution: alignment display style %d set...\n",aloff); */

  if(aloff==1){
    for(ml=0;ml<ptype.syno;++ml){
      if(ptype.aas[ml]!=' ')
        fprintf(out,"SUB_CHARS %d %d %d %d",1,1,count,abloc);     
      if(ptype.aas[ml]!=' ')
        fprintf(out," %c SPACE\n",ptype.aas[ml]);
    }
    for(ml=0;ml<strlen(strcr);++ml){
      if(ptype.aas[ml]!=' ')
        fprintf(out,"SUB_CHARS %d %d %d %d",1,abloc+1,count,abloc+bbloc);     
      if(ptype.aas[ml]!=' ')
        fprintf(out," %c SPACE\n",strcr[ml]);
    }
  }
  if(aloff==2){
    for(ml=0;ml<strlen(strcr);++ml){
      if(ptype.aas[ml]!=' ')
        fprintf(out,"SUB_CHARS %d %d %d %d",1,abloc+1,count,abloc+bbloc);     
      if(ptype.aas[ml]!=' ')
        fprintf(out," %c SPACE\n",strcr[ml]);
    }
  }
  if(aloff==3){
    for(ml=0;ml<ptype.syno;++ml){
      if(ptype.aas[ml]!=' ')
        fprintf(out,"SUB_CHARS %d %d %d %d",1,1,count,abloc);     
      if(ptype.aas[ml]!=' ')
        fprintf(out," %c SPACE\n",ptype.aas[ml]);
    }
  }

/* Title lines */

  fprintf(out,"SUB_ID %d \" \"\n",tvar+1);
  fprintf(out,"SUB_ID %d \" \"\n",tvar+2);
  if(count>5){
    fprintf(out,"TEXT %d %d ",5+(4/(int)ps),tvar+2);
    fprintf(out,"\"(c) 1992,1997  C.D.Livingstone & G.J.Barton \"\n");
    fprintf(out,"FONT_REGION %d %d %d %d %d\n",
          5+(4/(int)ps),tvar+2,
          5+(4/(int)ps),tvar+2,
          1);
    fprintf(out,"TEXT %d %d \"AMAS\"\n",1,tvar+2);
    fprintf(out,"FONT_REGION %d %d %d %d %d\n",
            1,tvar+2,
            4,tvar+2,
            4);
  }else {
    fprintf(out,"TEXT %d %d ",1,tvar+2);
    fprintf(out,"\"AMAS (c) 1992 C.D.Livingstone & G.J.Barton \"\n");
    fprintf(out,"FONT_REGION %d %d %d %d %d\n",
          5,tvar+2,
          5,tvar+2,
          1);
  }

  fprintf(out,"SUB_ID %d \" \"\n",tvar+3);
  fprintf(out,"TEXT %d %d ",1,tvar+3);
  if(def.uot==0){
    fprintf(out,"\"Conservation plot of ");
    fprintf(out,"the sequence alignment ``%s''\"\n",blocfile);
  } else  fprintf(out,"\"%s\"\n",def.nt1);
  fprintf(out,"FONT_REGION %d %d %d %d %d\n",
          1,tvar+3,
          1,tvar+3,
          1);

  fprintf(out,"SUB_ID %d \" \"\n",tvar+4);
  fprintf(out,"TEXT %d %d ",1,tvar+4);
  if(def.uot==0){
    fprintf(out,"\"Conservation Threshold: %d  -  ",consval);
    fprintf(out,"Gaps Ignored: %d  -  ",gcut);
    fprintf(out,"Minimum Residue Occupancy: %d%%\"\n",atyp);
  } else fprintf(out,"\"%s\"\n",def.nt2);
  fprintf(out,"FONT_REGION %d %d %d %d %d\n",
          1,tvar+4,
          1,tvar+4,
          1);

  fprintf(out,"SUB_ID %d \" \"\n",tvar+5);
  fprintf(out,"TEXT %d %d ",1,tvar+5);
  if(def.uot==0){
    if(hist==1){
      fprintf(out,"\"Histogram type: ");
      if(other==1){fprintf(out,"AVERAGE");}else fprintf(out,"PAIR");
      fprintf(out,"  -  Conservation mode: " );
    }else{
      fprintf(out,"\"Pair conservation reported ");
      fprintf(out,"  -  Conservation mode: " );
    }
    if(neg==1){fprintf(out,"STANDARD");}else fprintf(out,"POSITIVE");
    fprintf(out," with %d property index ``%s'' \"\n",ptype.pno,nnote);
  } else fprintf(out,"\"%s\"\n",def.nt3);
  fprintf(out,"FONT_REGION %d %d %d %d %d\n",
          1,tvar+5,
          1,tvar+5,
          1);

  fclose(out);

/******************************************************************************/
/* call Alscript program automatically					      */
/******************************************************************************/

  alcom = (char*) malloc (sizeof(char)*(strlen(blocfile)+101));

  for(mu=0;mu<strlen(blocfile)+100;++mu)alcom[mu]=' ';
  alcom[strlen(blocfile)+100]='\0';

  strcpy(alcom,def.AlscC);
  strcat(alcom,soaname);
  strcat(alcom," -s");

  system(alcom);

  free((char*) alcom);
  free((char*) soaname);
  free((char*) blcname);
  free((char*) psname);
  free((char*) bbsto);
  free((char*) bb);
  free((char*) ab);
}

