# include "includes.h"

albloc(count,noclust,nostruct,consval,aa,same,diff,bloc,blocfile,cl,
       hist,hscale,point,other,pattout,ss,edat,tostr,ssno,pretty)
int count,noclust,nostruct,consval,aa,hist,ssno;
int edat,tostr,hscale,point,other,pattout,pretty;
int **same,**diff;
struct seqdat *bloc;
char *blocfile;
struct indclust *cl;
struct indclust *ss;
{ 
  FILE *out,*data,*pco,*str;
  int mn,ml,my,mx,mz,bb,cc,ii,kk,pp,type;
  float huneg,euneg,hneg,eneg,cneg,totneg;
  float hupos,eupos,hpos,epos,cpos,totpos;
  float hw,hp,ew,ep,ccn;
  char *outname,*datname;
  int dat1,dat2;
  
/**************************************************************************/
/*  Produce blocfile for plot including the similarity/difference data    */
/**************************************************************************/

  datname = (char*) malloc(sizeof(char)*(strlen(blocfile)+5));
  outname = (char*) malloc(sizeof(char)*(strlen(blocfile)+5));
  if((edat==1)&&(hist==1)){
    hupos=0;eupos=0;
    hpos=0;epos=0;
    cpos=0;totpos=0;
    huneg=0;euneg=0;
    hneg=0;eneg=0;
    cneg=0;totneg=0;
  }
  if((pattout==1)&&(hist==1)){
    strcpy(datname,blocfile);
    strcat(datname,".pat");
    datname[strlen(blocfile)+4] = '\0';
    if((data=fopen(datname,"w"))==NULL){
      printf("Error: cant open file %s\n",datname);
      exit(0);
    }
  }
  if(pretty==1){
    strcpy(outname,blocfile);
    strcat(outname,".blc");
    outname[strlen(blocfile)+4] = '\0';
    if((out=fopen(outname,"w"))==NULL){
      printf("Error: cant open file %s\n",outname);
      exit(0);
    }
  } 

/* ID and title fields for blocfile analysed sequence data */

  if(pretty==1)for(my=1;my<noclust+1;++my)
    for(mz=1;mz<cl[my].number+1;++mz){
      fprintf(out,"%d|",my);
      if(bloc[cl[my].order[mz]].id[0]!='>')fprintf(out,">");
      fprintf(out,"%s  ", bloc[cl[my].order[mz]].id);
      fprintf(out,"%s",bloc[cl[my].order[mz]].title);
    }

/* ID and title fields for blocfile structure data */

  if((nostruct!=0)&&(pretty==1))for(my=1;my<nostruct+1;++my)
    for(mz=1;mz<ss[my].number+1;++mz){
      fprintf(out,"%d|",my);
      if(bloc[ss[my].order[mz]].id[0]!='>')fprintf(out,">");
      fprintf(out,"%s  ", bloc[ss[my].order[mz]].id);
      fprintf(out,"%s",bloc[ss[my].order[mz]].title);
    }

/* ID and title fields for similarity difference numbers 
   if used in place of histogram */

  if((hist==0)&&(pretty==1)){
    bb=0;
    for(mn=1;mn<noclust;++mn)
      for(ml=mn+1;ml<noclust+1;++ml){
        bb++;
        fprintf(out,">%d-vs-%d        ",mn,ml);
        fprintf(out,"Group %d: combined conservation subset %d  subset %d ",
              bb,mn,ml);
        fprintf(out,"at consval=%d\n",consval);
      }
    bb=0;
    for(mn=1;mn<noclust;++mn)
      for(ml=mn+1;ml<noclust+1;++ml){
        bb++;
        fprintf(out,">%d-vs-%d        ",mn,ml);
        fprintf(out,"Group %d: subset %d different to subset %d ",bb,mn,ml);
        fprintf(out,"at consval=%d\n",consval);
      }
  }

/* ID and title fields for histograms if included */

  if((hist==1)&&(pretty==1)){
    for(mn=0;mn<hscale;++mn){
      fprintf(out,">HISTO_%d        ",mn);
        fprintf(out,"False line %d for Histogram\n",mn);
    }
    fprintf(out,">CV_%d          ",mn);
    fprintf(out,"False line %d for mean conservation\n",mn);
    for(mn=0;mn<hscale;++mn){
      fprintf(out,">HISTO_%d        ",mn);
        fprintf(out,"False line %d for difference Histogram\n",mn);
    }
    fprintf(out,">CV_%d          ",mn);
    fprintf(out,"False line %d for mean difference\n",mn);
  }

/* false data line IDs for introducing labels */

  if(pretty==1){
    fprintf(out,">BOGUS1       ");
    fprintf(out,"A false line for introducing labels\n");    
    fprintf(out,">BOGUS2       ");
    fprintf(out,"Another line for introducing labels\n");
    fprintf(out,">BOGUS3       ");
    fprintf(out,"Another line for introducing labels\n");   
    fprintf(out,">BOGUS4       ");
    fprintf(out,"Another line for introducing labels\n");
    fprintf(out,">BOGUS5       ");
    fprintf(out,"A last  line for introducing labels\n");
  }

/* output the alignment and sim/diff data itself */

  if(pretty==1)fprintf(out,"*ITERATION 1\n");
  for(ml=1;ml<count+1;++ml){
    if(pretty==1)for(my=1;my<noclust+1;++my)
      for(mz=1;mz<cl[my].number+1;++mz)
         fprintf(out,"%c",bloc[cl[my].order[mz]].seq[ml]);
    if((nostruct!=0)&&(pretty==1))for(my=1;my<nostruct+1;++my)
      for(mz=1;mz<ss[my].number+1;++mz)
         fprintf(out,"%c",bloc[ss[my].order[mz]].seq[ml]);
    if((hist==0)&&(pretty==1)){
      for(mn=0;mn<bb;++mn){
        if(same[mn][ml]>0){

          if(same[mn][ml]<10){
            if(same[mn][ml]<=point){type=same[mn][ml];} else type=point;
          } else {
            if(same[mn][ml]<=point){
              type=65+(same[mn][ml]-10);
            } else type = 65+(point-10);
          }
          if(same[mn][ml]<10){
            fprintf(out,"%d",type);
          } else fprintf(out,"%c",type);
        } else fprintf(out," ");
      }
      for(mn=0;mn<bb;++mn){
        if(diff[mn][ml]>0){
          if(diff[mn][ml]<10){
            fprintf(out,"%d",diff[mn][ml]);
          } else fprintf(out,"%c",65+(diff[mn][ml]-10));
        } else fprintf(out," ");
      }
    }

/****************************************************************************//*
  Determine height of bars for similarities and store data to file if required
*//****************************************************************************/

    if(hist==1){
      cc=0;ii=0;
      if(other==0){
        for(mn=0;mn<aa;++mn) if((same[mn][ml]>0)||(diff[mn][ml]>=consval))cc++;
        for(mn=0;mn<aa;++mn) if(same[mn][ml]==point+1)ii++;
        dat1 = (100*cc) / aa;
        dat2 = (100*ii) / aa;
        if(pattout==1)fprintf(data,"%5d%5d%5d",dat1,dat2,dat1-dat2);
        if(((dat1!=0)||(dat2!=0))&&(edat==1)){ 
          if(bloc[ssno].seq[ml]=='H')hpos++;
          if(bloc[ssno].seq[ml]=='h')hupos++;
          if(bloc[ssno].seq[ml]=='E')epos++;
          if(bloc[ssno].seq[ml]=='e')eupos++;
          if((bloc[ssno].seq[mn]=='c')||(bloc[ssno].seq[mn]==' '))cpos++;
          totpos++;
        }
        kk = (hscale*cc)/aa;
        ii = (hscale*ii)/aa;
      }else{
        for(mn=0;mn<aa;++mn) 
          if(same[mn][ml]>0)
            cc=cc+same[mn][ml];
        for(mn=0;mn<aa;++mn) if(same[mn][ml]==point+1)ii=ii+same[mn][ml];
        dat1 = (100*cc) / (aa*point);
        dat2 = (100*ii) / (aa*point);
        if(pattout==1)fprintf(data,"%5d%5d%5d",dat1,dat2,dat1-dat2);
        if(((dat1!=0)||(dat2!=0))&&(edat==1)){ 
          if(bloc[ssno].seq[ml]=='H')hpos++;
          if(bloc[ssno].seq[ml]=='h')hupos++;
          if(bloc[ssno].seq[ml]=='E')epos++;
          if(bloc[ssno].seq[ml]=='e')eupos++;
          if((bloc[ssno].seq[mn]=='c')||(bloc[ssno].seq[mn]==' '))cpos++;
          totpos++;
        }
        kk = (hscale*cc)/(point * aa);
        ii = (hscale*ii)/(point * aa);
      }
      if(pretty==1){
        for(mn=0;mn<(hscale-kk);++mn)fprintf(out," ");
        for(mn=0;mn<kk-ii;++mn)fprintf(out,"S");
        for(mn=0;mn<ii;++mn)fprintf(out,"Q");
        pp=0;
        if(other==0)
          for(mn=0;mn<aa;++mn) if(diff[mn][ml]>=consval)pp=pp+diff[mn][ml];
        for(mn=0;mn<aa;++mn) if(same[mn][ml]>0)pp=pp+same[mn][ml];
        if(pp>0){
          pp=pp/cc;
          if(pp>point)pp=point;
          if(pp<10){
            fprintf(out,"%d",pp);
          } else fprintf(out,"%c",65+(pp-10));
        } else fprintf(out," ");
      }
      cc=0;pp=0;

/****************************************************************************//*
  Determine height of bars for differences and store data to file if required
*//****************************************************************************/

      if(other==0){
        for(mn=0;mn<aa;++mn) 
          if((diff[mn][ml]>0)&&(diff[mn][ml]<consval)) 
            pp=pp+diff[mn][ml];
        for(mn=0;mn<aa;++mn) 
          if((diff[mn][ml]>0)&&(diff[mn][ml]<consval))cc++;
        dat1 = (100*cc)/aa;
        if(pattout==1)fprintf(data,"%5d     %c\n",-dat1,bloc[ssno].seq[ml]); 
        if(((dat1!=0)||(dat2!=0))&&(edat==1)){ 
          if(bloc[ssno].seq[ml]=='H')hneg++;
          if(bloc[ssno].seq[ml]=='h')huneg++;
          if(bloc[ssno].seq[ml]=='E')eneg++;
          if(bloc[ssno].seq[ml]=='e')euneg++;
          if((bloc[ssno].seq[ml]=='c')||(bloc[ssno].seq[ml]==' '))cneg++;
          totneg++;
        }


        kk = (hscale*cc)/aa;
      }else{
        for(mn=0;mn<aa;++mn)if(diff[mn][ml]>0)pp=pp+diff[mn][ml];
        for(mn=0;mn<aa;++mn)if(diff[mn][ml]>0)cc=cc+diff[mn][ml];
        dat1 = (100*cc)/(point*aa);
        if(pattout==1)fprintf(data,"%5d     %c\n",-dat1,bloc[ssno].seq[ml]);
        if(((dat1!=0)||(dat2!=0))&&(edat==1)){ 
          if(bloc[ssno].seq[ml]=='H')hneg++;
          if(bloc[ssno].seq[ml]=='h')huneg++;
          if(bloc[ssno].seq[ml]=='E')eneg++;
          if(bloc[ssno].seq[ml]=='e')euneg++;
          if((bloc[ssno].seq[ml]=='c')||(bloc[ssno].seq[ml]==' '))cneg++;
          totneg++;
        }
        kk = (hscale*cc)/(point*aa);
      }
      if(pretty==1){
        if(pp>0){
          pp=pp/cc;
          if(pp<10){
            fprintf(out,"%d",pp);
          } else fprintf(out,"%c",65+(pp-10));
        } else fprintf(out," ");
        for(mn=0;mn<kk;++mn)fprintf(out,"D");
        for(mn=0;mn<(hscale-kk);++mn)fprintf(out," ");
      }
    }
    if(pretty==1)fprintf(out,"     \n");
  }
  if((pattout==1)&&(hist==1))fclose(data);
  if(pretty==1){
    fprintf(out,"*");
    fclose(out);
  }

/***************************************************************************//*
     output text summary of Russel 2' structure assignments 
*//***************************************************************************/

  if((tostr==1)&&(hist==1)){
    strcpy(datname,blocfile);
    strcat(datname,".str");
    datname[strlen(blocfile)+4] = '\0';
    if((str=fopen(datname,"w"))==NULL){
      printf("Error: cant open file %s\n",datname);
      exit(0);
    }    
    fprintf(str,"########################################");
    fprintf(str,"########################################");
    fprintf(str,"\n2'structure breakdown from %s\n\n",blocfile);
    mn=1;mx=1;
    hw=0;hp=0;ew=0;ep=0;ccn=0;
    while(mn<count+1){
      if((mn<count+1)&&(bloc[ssno].seq[mn]=='h')){
        mx=mn;
        while((mn<count+1)&&(bloc[ssno].seq[mn]=='h')){mn++;hp++;}
        mn--;
        fprintf(str,"%5d-%-5d poorly characterised helix\n",mx,mn);
        mn++;
      }
      if((mn<count+1)&&(bloc[ssno].seq[mn]=='H')){
        mx=mn;
        while((mn<count+1)&&(bloc[ssno].seq[mn]=='H')){mn++;hw++;}
        mn--;
        fprintf(str,"%5d-%-5d well characterised helix\n",mx,mn);
        mn++;
      }
      if((mn<count+1)&&(bloc[ssno].seq[mn]=='e')){
        mx=mn;
        while((mn<count+1)&&(bloc[ssno].seq[mn]=='e')){mn++;ep++;}
        mn--;
        fprintf(str,"%5d-%-5d poorly characterised strand\n",mx,mn);
        mn++;
      }
      if((mn<count+1)&&(bloc[ssno].seq[mn]=='E')){
        mx=mn;
        while((mn<count+1)&&(bloc[ssno].seq[mn]=='E')){mn++;ew++;}
        mn--;
        fprintf(str,"%5d-%-5d well characterised strand\n",mx,mn);
        mn++;
      }
      if((mn<count+1)&&((bloc[ssno].seq[mn]=='c')||(bloc[ssno].seq[mn]==' '))){
        mx=mn;
        while((mn<count+1)&&
             ((bloc[ssno].seq[mn]=='c')||
              (bloc[ssno].seq[mn]==' '))){mn++;ccn++;}
        mn--;
        fprintf(str,"%5d-%-5d coil\n",mx,mn);
        mn++;
      }
    }
    fprintf(str,"########################################");
    fprintf(str,"########################################");
    fclose(str);
  }

/***************************************************************************//*
     output apropriate for direct import to splus detailing co-incidence of
     secondary structure elements defined by Russell assignments and 
     conservation pattern elements.
*//***************************************************************************/

  if((edat==1)&&(hist==1)){
    strcpy(datname,blocfile);
    strcat(datname,".pco");
    datname[strlen(blocfile)+4] = '\0';
    if((pco=fopen(datname,"w"))==NULL){
      printf("Error: cant open file %s\n",datname);
      exit(0);
    }    

/* conservation threshold and length of sequence */

    fprintf(pco,"%-5d %-5d %0.0f %0.0f\n",consval,count,totpos,totneg);

/* number of sequence positions in helix by rass, percent sequence positions */
/* in helix by rass, number sequence positions classified as "good" helix,   */ /* percent sequence positions classified as "good" helix, number sequence    */
/* positions classified as "poor" helix, percent sequence positions          */
/* classified as "poor" helix, number of pattern elements in helix, number   */
/* of pattern elements in "good" helix, number of pattern elements in "poor" */
/* helix, percent of pattern elements in helix, percent of pattern elements  */
/* in "good" helix, percent of pattern elements in "poor" helix.	     */

    fprintf(pco,"%-5d %-5d\n",(int)(hw+hp),(int)(((hw+hp)*100)/(float)count));
    fprintf(pco,"%-5d %-5d\n",(int)(hw),(int)((hw*100)/(float)count));
    fprintf(pco,"%-5d %-5d\n",(int)(hp),(int)((hp*100)/(float)count));

    fprintf(pco,"%0.0f %0.0f %0.0f\n",hpos+hupos,hpos,hupos);
    fprintf(pco,"%0.2f %0.2f %0.2f\n",
           ((hpos+hupos)*100)/totpos,
           (hpos*100)/totpos,(hupos*100)/totpos);

    fprintf(pco,"%0.0f %0.0f %0.0f\n",hneg+huneg,hneg,huneg);
    fprintf(pco,"%0.2f %0.2f %0.2f\n",
           ((hneg+huneg)*100)/totneg,
           (hneg*100)/totneg,(huneg*100)/totneg);

/* number of sequence positions in strand by rass, percent sequence positions */
/* in strand by rass, number sequence positions classified as "good" strand,  */ /* percent sequence positions classified as "good" strand, number sequence    */
/* positions classified as "poor" strand, percent sequence positions          */
/* classified as "poor" strand, number of pattern elements in strand, number  */
/* of pattern elements in "good" strand, number of pattern elements in "poor" */
/* strand, percent of pattern elements in strand, percent of pattern elements */
/* in "good" strand, percent of pattern elements in "poor" strand.	      */

    fprintf(pco,"%-5d %-5d\n",(int)(ew+ep),(int)(((ew+ep)*100)/(float)count));
    fprintf(pco,"%-5d %-5d\n",(int)(ew),(int)((ew*100)/(float)count));
    fprintf(pco,"%-5d %-5d\n",(int)(ep),(int)((ep*100)/(float)count));

    fprintf(pco,"%0.0f %0.0f %0.0f\n",epos+eupos,epos,eupos);
    fprintf(pco,"%0.2f %0.2f %0.2f\n",
           ((epos+eupos)*100)/totpos,
           (epos*100)/totpos,(eupos*100)/totpos);

    fprintf(pco,"%0.0f %0.0f %0.0f\n",eneg+euneg,eneg,euneg);
    fprintf(pco,"%0.2f %0.2f %0.2f\n",
           ((eneg+euneg)*100)/totneg,
           (eneg*100)/totneg,(euneg*100)/totneg);
 
/* same for coil where apropriate */

    fprintf(pco,"%-5d ",(int)ccn);
    fprintf(pco,"%-5d\n",(int)((ccn*100)/(float)count));
    fprintf(pco,"%0.0f %0.2f\n",cpos,(cpos*100)/totpos);
    fprintf(pco,"%0.0f %0.2f\n",cneg,(cneg*100)/totneg);
    fclose(pco);
  }

  free((char*)outname);
  free((char*)datname);
}
