#include "includes.h"

/* Ptyperead.c
   ***********

This program reads in standard property type matrices, allowing the use of 
multiple property types in the MAAS program, ie.   each amino acid may be a 
member of more than one property type group.   The standard input file is of
the format:

!    *ILVCAGMFYWHKREQDNSTP BZX**
!
 1    111111111111000000101001 Hydrophobic
 2    000000000011100000001001 Positive
 3    000000000000010100001001 Negative
 4    000000001111111111101111 Polar
 5    000000000011110100001001 Charged
 6    001111000000000111111001 Small
 7    000011000000000001001001 Tiny
 8    111000000000000000001001 Aliphatic
 9    000000011110000000001001 Aromatic
10    000000000000000000011001 Proline
~
~
 n    001001001000100010001101 n 
!

The first collumn (0) contains the property type record.   If a property 
type is not present on the line, this position is occupied by an 
exclamation mark (!), which is, therefore, a reserved character in 
collumn 0.   The property type record is a decimal number which is later 
associated with the property name record.

The first row contains an indicator of the number of property types to 
be read.   In this row, the asterisk (*) is a reserved character.   The 
first asterisk is always in collumn 5.   The second asterisk is a marker
for the number of symbols represented in the property type matrix, 
occuring in the collumn following the last collumn occupied by the 
property type matrix.   The space between the first two markers contains 
a list of the amino acid symbols for which property types are listed.   
The third asterisk indicates the collumn in which the
property type names start.

Any space to the right of the property type names, in any collumn, may 
be used for comments.   

The property type matrix is expressed in binary form.   As many symbols/
property types as required may be defined, with the proviso that the 
total number of characters per line does not exceed 80.

Changed 010595 - extended read line length - accommodate larger matrices

*/  
 
struct slist readprop(pfile)
char *pfile;

{
  FILE *fp;
  char pts[500],lno=0;
  int mu,sm,si,pdes=6,i,total,tally;
  struct slist sy;

  sy.pno=0;
  sy.syno=0;    
  sy.apm = (struct pmtrx*) malloc(sizeof(struct pmtrx)*2);
  sy.pnames = (char**) malloc(sizeof(char*)*2);
  sy.aas=(char*) malloc(sizeof(char)*2);

  if((fp = fopen(pfile, "r"))==0){
    printf("\nFile Error: can not open ptype file \"%s\" for reading.\n",
      pfile);
    exit(0);
  }
  total=-1;

  while(!feof(fp)){

  /* Read in one line (of max 500 characters) */
  
  fgets(pts,499,fp);
    if(pts[5]==42){
      while (pts[pdes]!=42){
	sy.syno++;
	pdes++;
      }
      sm=pdes+1;
      while (pts[sm]!=42){
	sm++;
      }
      sy.aas=(char*) realloc(sy.aas,sizeof(char)*(sy.syno+2));
      for(mu=6;mu<(sy.syno+6);++mu){
        sy.aas[mu-6]=pts[mu];
      }
    }

/* If the line starts with a non-control code character or ! read in the symbol
   and its property type matrix */

    tally=0;
    if((pts[0]!=33)&&(pts[0]>31)){
      si=0;
      i=0;
      sscanf(pts,"%d",&i);
      si = sm;
      while (pts[si]!=32){
        si++;  
      }
      sy.pnames[sy.pno] = (char*) malloc (sizeof(char)*((si-sm)+2));
      for(mu=sm;mu<si;++mu) sy.pnames[sy.pno][mu-sm]=pts[mu];
      sy.pnames[sy.pno][mu-sm]='\0';
      sy.apm[sy.pno].pcode=i;
      sy.apm[sy.pno].ptype = (int*) malloc(sizeof(int)*(sy.syno+2));
      for(mu=6;mu<(6+sy.syno);++mu){
	sy.apm[sy.pno].ptype[mu-6]=(int)pts[mu]-48;
        if(pts[mu]=='1') tally++;
      }
      sy.pno++;
      sy.apm = (struct pmtrx*) 
        realloc(sy.apm,sizeof(struct pmtrx)*(sy.pno+2));
      sy.pnames = (char**) realloc (sy.pnames,sizeof(char*)*(sy.pno+2));
    }
    if(total<tally) total=tally;
  }
  sy.maxnoprop = total;
  fclose(fp);
  return sy;
}
