/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was written by Asim S. Siddiqui

 The WORK is Copyright (1995) A. S. Siddiqui and G. J. Barton

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
 * Name
 *    asd_check_utils
 * Purpose
 *    to provide a set of checking utilities
 * Author
 *    Asim Siddqui
 * SccsId
 *    %W%   %U%   %E%
 */

#include <local.h>
#include <asd_structs.h>
#include <asm_mop.h>
#include <ase_error.h>
#include <asd_utils.h>
#include <asd_make_domains.h>
#include <asd_check_utils.h>
#include <asd_value.h>

extern Asd_Parameters params;

Asd_Seg_Cont sa_seg_info;   /* segment a info */
Asd_Seg_Cont sa_seg_info_2; /* segment a info */
Asd_Seg_Cont s1_seg_info;   /* segment 1 info */
Asd_Seg_Cont s1_seg_info_2; /* segment 1 info */

int 
asd_check_seg_a(Asd_Contact_List *c_list, bool_t ss_only, char *ss,
                Asd_Domain *d_to_split, int s1_sn, int s1_min_len,
                int start_chain, int type)
{
    int i;                         /* loop counter                          */
    int j;                         /* loop counter                          */
    int s1_e;                      /* end of segment s1                     */
    int num_contacts;              /* number of contacts for that item      */
    int val_i;                     /* temporary interger value              */
    int int_1;                     /* number of internal contacts           */
    int int_2;                     /* number of internal contacts           */
    int ext_no;                    /* number of external contacts           */
    int ext_sht;                   /* external sheet contacts               */
    float value;                   /* temporary value                       */
    Asd_Contact_Info **cf1_ptr;    /* temporary pointer to forward contacts */
    Asd_Contact_Info *cf2_ptr;     /* temporary pointer to forward contacts */
    Asd_Contact_Info **cbf1_ptr;   /* temporary pointer to forward contacts */
    Asd_Contact_Info **contact_info; /* beta sheet list                     */
    Asd_Contact_Info **beta_l;     /* beta sheet list                       */

    contact_info = c_list->cl;
    beta_l = c_list->bl;

    sa_seg_info.s1_int = 0;
    sa_seg_info.s2_int = 0;
    sa_seg_info.s1_s2_sht_cont = 0;
    sa_seg_info.s1_s2_cont = 0;
    sa_seg_info_2.s1_s2_sht_cont = 0;
    sa_seg_info_2.s1_s2_cont = 0;
    i = d_to_split->start1;    

    s1_e = s1_sn + s1_min_len;
    cf1_ptr = (contact_info + i);
    cbf1_ptr = (beta_l + i);
    while (i < s1_sn) {
        if (!ss_only ||
            (ss_only && (ss[i - 1] == 'H' || ss[i - 1] == 'E'))) {
/* first analyse forward contacts */
            cf2_ptr = *cf1_ptr;
            num_contacts = (*cf2_ptr).res_num;
            cf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cf2_ptr).res_num < s1_sn) {
                    (sa_seg_info.s1_int)++;
                } else if ((*cf2_ptr).res_num < s1_e) {
                    (sa_seg_info.s1_s2_cont)++;
                } else {
                    (sa_seg_info_2.s1_s2_cont)++;
                } /*if*/
                j++;
                cf2_ptr++;
            } /*while*/
/* first analyse forward beta contacts */
            cf2_ptr = *cbf1_ptr;
            num_contacts = (*cf2_ptr).res_num;
            cf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cf2_ptr).res_num >= s1_sn && (*cf2_ptr).res_num < s1_e) {
                    (sa_seg_info.s1_s2_sht_cont)++;
                } else if ((*cf2_ptr).res_num >= s1_e) {
                    (sa_seg_info_2.s1_s2_sht_cont)++;
                } /*if*/
                j++;
                cf2_ptr++;
            } /*while*/
        } /*if*/
        cf1_ptr = (cf1_ptr + 1);
        cbf1_ptr = (cbf1_ptr + 1);
        i++;
    } /*while*/

/* now work out s1 internal contacts */
    i = s1_sn;
    cf1_ptr = (contact_info + i);
    while (i <= s1_e) {
        if (!ss_only ||
            (ss_only && (ss[i - 1] == 'H' || ss[i - 1] == 'E'))) {
/* first analyse forward contacts */
            cf2_ptr = *cf1_ptr;
            num_contacts = (*cf2_ptr).res_num;
            cf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cf2_ptr).res_num >= s1_sn &&
                    (*cf2_ptr).res_num <= s1_e) {
                    (sa_seg_info.s2_int)++;
                } /*if*/
                j++;
                cf2_ptr++;
            } /*while*/
        } /*if*/
        cf1_ptr = (cf1_ptr + 1);
        i++;
    } /*while*/

    if (s1_sn == d_to_split->start1) {
        return(0);
    } /*if*/ 

    int_1 = sa_seg_info.s1_int;
    int_2 = sa_seg_info.s2_int;
    ext_no = sa_seg_info.s1_s2_cont;
    ext_sht = sa_seg_info.s1_s2_sht_cont;

    value = asd_calc_c_value(int_1, int_2, ext_no, ext_sht, d_to_split->start1,
                             s1_sn - 1, 0, 0, s1_sn, s1_e, 0, 0);

    if ((ss_only && value < params.MIN_PEAK_SS_ONLY_C) ||
       (!ss_only && value < params.MIN_PEAK_C)) {
        return(-1);
    } /*if*/

    return(0);

} /*asd_check_seg_a*/

int 
asd_check_seg_1(Asd_Contact_List *c_list, bool_t ss_only, char *ss,
                Asd_Domain *d_to_split, int s1_sn, int s1_en)
{
    int i;                         /* loop counter                          */
    int j;                         /* loop counter                          */
    int size1;                     /* size of segment                       */
    int num_contacts;              /* number of contacts for that item      */
    int val_i;                     /* temporary interger value              */
    int int_1;                     /* number of internal contacts           */
    int int_2;                     /* number of internal contacts           */
    int s2_sn;                     /* s2 start position                     */
    int ext_no;                    /* number of external contacts           */
    int ext_sht;                   /* external sheet contacts               */
    int s1_sa_cont;                /* sa s1 intersegment contacts           */
    int s1_sa_sht_cont;            /* s1 sa sheet contacts                  */
    float value;                   /* temporary value                       */
    Asd_Contact_Info **cf1_ptr;    /* temporary pointer to forward contacts */
    Asd_Contact_Info *cf2_ptr;     /* temporary pointer to forward contacts */
    Asd_Contact_Info *cr2_ptr;     /* temporary pointer to reverse contacts */
    Asd_Contact_Info **cbf1_ptr;   /* temporary pointer to forward contacts */
    Asd_Contact_Info **cr1_ptr; /* temporary pointer to reverse contacts */
    Asd_Contact_Info **cbr1_ptr; /* temporary pointer to r b     contacts */
    Asd_Contact_Info **contact_info; /* beta sheet list                     */
    Asd_Contact_Info **beta_l;     /* beta sheet list                       */
    Asd_Contact_Info **contact_rev_info;  /* reverse beta sheet list     */
    Asd_Contact_Info **rev_beta_l;  /* reverse beta sheet list           */

    contact_info = c_list->cl;
    beta_l = c_list->bl;
    contact_rev_info = c_list->rcl;
    rev_beta_l = c_list->rbl;

    s1_sa_cont = 0;
    s1_sa_sht_cont = 0;
    s1_seg_info.s1_int = 0;
    s1_seg_info.s2_int = 0;
    s1_seg_info.s1_s2_sht_cont = 0;
    s1_seg_info.s1_s2_cont = 0;
    s1_seg_info_2.s1_s2_sht_cont = 0;
    s1_seg_info_2.s1_s2_cont = 0;

    s2_sn = s1_en + params.MIN_SEGMENT_SIZE_MID + 1;
    i = s1_sn;

    cf1_ptr = (contact_info + i);
    cr1_ptr = (contact_rev_info + i);
    cbf1_ptr = (beta_l + i);
    cbr1_ptr = (rev_beta_l + i);

    while (i <= s1_en) {
        if (!ss_only ||
            (ss_only && (ss[i - 1] == 'H' || ss[i - 1] == 'E'))) {
/* first analyse forward contacts */
            cf2_ptr = *cf1_ptr;
            num_contacts = (*cf2_ptr).res_num;
            cf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cf2_ptr).res_num <= s1_en &&
                    (*cf2_ptr).res_num >= s1_sn) {
                    (s1_seg_info.s1_int)++;
                } else if ((*cf2_ptr).res_num > s1_en &&
                           (*cf2_ptr).res_num < s2_sn) {
                    (s1_seg_info.s1_s2_cont)++;
                } else if ((*cf2_ptr).res_num >= s2_sn) {
                    (s1_seg_info_2.s1_s2_cont)++;
                } /*if*/
                j++;
                cf2_ptr++;
            } /*while*/
/* first analyse forward beta contacts */
            cf2_ptr = *cbf1_ptr;
            num_contacts = (*cf2_ptr).res_num;
            cf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cf2_ptr).res_num > s1_en &&
                    (*cf2_ptr).res_num < s2_sn) {
                    (s1_seg_info.s1_s2_sht_cont)++;
                } else if ((*cf2_ptr).res_num >= s2_sn) {
                    (s1_seg_info_2.s1_s2_sht_cont)++;
                } /*if*/
                j++;
                cf2_ptr++;
            } /*while*/
/* now count reverse contacts to segment a */
            cr2_ptr = *cr1_ptr;
            num_contacts = (*cr2_ptr).res_num;
            cr2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cr2_ptr).res_num < s1_sn) {
                    s1_sa_cont++;
                } /*if*/
                j++;
                cr2_ptr++;
            } /*while*/
/* now do reverse beta contacts */
            cr2_ptr = *cbr1_ptr;
            num_contacts = (*cr2_ptr).res_num;
            cr2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cr2_ptr).res_num < s1_sn) {
                    s1_sa_sht_cont++;
                } /*if*/
                j++;
                cr2_ptr++;
            } /*while*/
        } /*if*/
        cf1_ptr = (cf1_ptr + 1);
        cbf1_ptr = (cbf1_ptr + 1);
        cr1_ptr = (cr1_ptr + 1);
        cbr1_ptr = (cbr1_ptr + 1);
        i++;
    } /*while*/

/* now work out sb internal contacts */
    i = s1_en + 1;
    cf1_ptr = (contact_info + i);
    while (i < s2_sn) {
        if (!ss_only ||
            (ss_only && (ss[i - 1] == 'H' || ss[i - 1] == 'E'))) {
/* first analyse forward contacts */
            cf2_ptr = *cf1_ptr;
            num_contacts = (*cf2_ptr).res_num;
            cf2_ptr++;
            j = 0;
            while (j < num_contacts) {
                if ((*cf2_ptr).res_num > s1_en &&
                    (*cf2_ptr).res_num < s2_sn) {
                    (s1_seg_info.s2_int)++;
                } /*if*/
                j++;
                cf2_ptr++;
            } /*while*/
        } /*if*/
        cf1_ptr = (cf1_ptr + 1);
        i++;
    } /*while*/
/* check to see if this s1 is distict from sb */
    int_1 = s1_seg_info.s1_int;
    int_2 = s1_seg_info.s2_int;
    ext_no = s1_seg_info.s1_s2_cont;
    ext_sht = s1_seg_info.s1_s2_sht_cont;

    value = asd_calc_c_value(int_1, int_2, ext_no, ext_sht, s1_sn,
                             s1_en, 0, 0, (s1_en + 1), (s2_sn - 1), 0, 0);

    if ((ss_only && value < params.MIN_PEAK_SS_ONLY_C) ||
       (!ss_only && value < params.MIN_PEAK_C)) {
        return(-1);
    } /*if*/
/* check to see if s1 is still distinct from sa */
    if (s1_sn != d_to_split->start1) {
        int_2 = sa_seg_info.s1_int;
        ext_no = s1_sa_cont;
        ext_sht = s1_sa_sht_cont;

        value = asd_calc_c_value(int_1, int_2, ext_no, ext_sht, s1_sn,
                            s1_en, 0, 0, d_to_split->start1, (s1_sn - 1), 0, 0);

        if ((ss_only && value < params.MIN_PEAK_SS_ONLY_C) ||
           (!ss_only && value < params.MIN_PEAK_C) && s1_sn != d_to_split->start1) {
            return(-1);
        } /*if*/
    } /*if*/

    return(0);
} /*asd_check_seg_a*/
