/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This file was written by Robert B. Russell

 The WORK is Copyright (1995) R. B. Russell and G. J. Barton

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

#define AA1 "ABCDEFGHIJKLMNOPQRST_VWXYZ________c"
#define AA3 "ALA ASX CYS ASP GLU PHE GLY HIS ILE CSH LYS LEU MET ASN CSS PRO GLN ARG SER THR ___ VAL TRP UNK TYR GLX ___ ___ ___ ___ ___ ___ ___ ___ CYH"

/* General notes:
 *
 * When wishing to refer to C_ss and C_sh seperately, I define C_sh as one letter 
 *  code "J" and  C_ss as one letter code "O".
 *
 * Given a one-letter code, to get the data for that amino acid one need merely
 *  refer to <data structure>[(int)(<code> - 'A')].  For example, to get the
 *  accessibility of Phenylalanine:
 *      AA_ACC[(int)('F'-'A')]
 *
 */

/* Values of standard state mean surface area.  Taken from:
 *  Rose, GD and Dworkin, JE `Hydrophobicity Profile', In:
 *  *Prediction of Protein Structure and the Principles of Protein
 *   Conformation*, Fasman, GD editor, Plenum press (1989). Page 629.
 * Value for Asx is the average of Asn/Asp; value for Glx is the 
 *  average for Gln/Glu; value for Unk is a complete guess. */
static int AA_ACC[35] =
 /* Ala, Asx, Cys, Asp, Glu, Phe, Gly, His, Ile, Cyh, Lys, Leu, Met, Asn, Cys */
 { 118, 162, 146, 158, 186, 222,  88, 203, 181, 146, 226, 193, 203, 166,  146,
 /* Pro, Gln, Arg, Ser, Thr, ___, Val, Trp, Unk, Tyr, Glx,---------------,Cys */ 
   147, 193, 256, 130, 153,   1, 165, 266, 400, 237, 190,1,1,1,1,1,1,1,1,146 };

 /* Amino acid abundance as calculated on REP.SEQ during the environment study */
 static float AA_ABUN[35] =
 /* Ala,  Asx,  Cys,  Asp,  Glu,  Phe,  Gly,  His,  Ile,  Csh,  Lys,  Leu,  Met */
 {  8.5,  0.1,  1.0,  5.8,  5.7,  3.6,  8.5,  2.6,  5.3,  1.0,  6.0,  8.1,  2.0,  
 /* Asn,  Css,  Pro, Gln, Arg, Ser, Thr, ___, Val, Trp, Unk, Tyr, Glx */
    4.7,  1.0,  4.7, 3.5, 4.2, 6.9, 6.2, 0.1, 7.7, 1.3,10.0, 3.6, 0.1,
 /* ------,                         cys-sh */ 
    0.1,0.1,0.1,0.1,0.1,0.1,0.1,0.1,1.0 };

 /* Molecular weights from Rawn (1984) 
  * Note that these are the weights for isolated amino acids */
 static int AA_MASS_ALL[35] = 
 /* Ala,  Asx,  Cys,  Asp,  Glu,  Phe,  Gly,  His,  Ile,  Csh,  Lys,  Leu,  Met */
 {   89,  133,  121,  133,  147,  165,   75,  155,  131,  121,  146,  131,  149,
/*  Asn,  Cys,  Pro,  Gln,  Arg,  Ser,  Thr,  ___,  Val,  Trp,  Unk,  Tyr,  Glx */ 
    132,  121,  115,  146,  174,  105,  119,    0,  117,  204,  110,  181,  147,
/*  ...            Cys-sh */
    0,0,0,0,0,0,0,0, 121 };

/* The above, less 18.0 for each one (i.e. for calculating the weight of a polypeptide */
static int AA_MASS[35] = 
/*  Ala,  Asx,  Cys,  Asp,  Glu,  Phe,  Gly,  His,  Ile,  Csh,  Lys,  Leu,  Met */
 {   71,  115,  103,  115,  129,  147,   57,  137,  113,  103,  128,  113,  131,
/*  Asn,  Css,  Pro,  Gln,  Arg,  Ser,  Thr,  ___,  Val,  Trp,  Unk,  Tyr,  Glx */
    114,  103,   97,  128,  156,   87,  101,    0,   99,  186,  110,  163,  129,
/*  ...            Cys-sh */
    0,0,0,0,0,0,0,0, 103 };

/* number of heavy atoms in the amino acid (including main chain) */
static int AA_NATS[35] =
/*  Ala,  Asx,  Cys,  Asp,  Glu,  Phe,  Gly,  His,  Ile,  Csh,  Lys,  Leu,  Met */
{     5,    8,    6,    8,    9,   11,    4,   10,    8,   10,    9,    8,    8,
/*  Asn,  Css,  Pro,  Gln,  Arg,  Ser,  Thr,  ___,  Val,  Trp,  Unk,  Tyr,  Glx */
      8,    6,    7,    9,   11,    6,    7,    0,    7,   14,   99,   12,    9,
/*  ...            Cys-sh */
    0,0,0,0,0,0,0,0,6 };
