/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This file was written by Asim S. Siddiqui

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
 * name
 *    asd_value.h
 * purpose
 *    haeder file for asd_value.c
 * sccsid
 *    %W%   %U%   %E%
 * author
 *    Asim Siddiqui
 */

#include <asd_structs.h>

#ifndef HAVE_ASD_VALUE_H
#define HAVE_ASD_VALUE_H

void
asd_sort_helices(int d_start, int d_end, Asd_Contact_Info **contact_info,
                 char *ss);
float
asd_calc_c_value(int int_1, int int_2, int ext_no, int ext_sht,
                int s1_s, int s1_e, int dum1, int dum2, int s2_s, int s2_e,
                int dum3, int dum4);

float
asd_calc_d_value(int int_1, int int_2, int ext_no, int ext_sht,
                Asd_Domain *d_to_split, int s1_s, int s1_e, int s2_s, int s2_e);

void
asd_hel_reduce_ext_by(int cut_point, int *ext);

void
asd_scan_domain(Asd_Contact_Info **contact_info,
                Asd_Contact_Info **contact_rev_info, struct brookn *bn,
                char *ss, Asd_Domain_List *d_list, int d_int, int d_ext,
                Asd_Domain *c_domain, int *int_c, int *ext_c, int *ext_sht_c,
                bool_t do_ext);

#endif /*HAVE_ASD_VALUE_H*/
