/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This file was written by Asim S. Siddiqui

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

/*
 * Title
 *    asd_make_domains.h
 * Author
 *    Asim Siddiqui
 * SccsId
 *    %W%   %U%   %E%
 */

#ifndef HAVE_ASD_MAKE_DOMAINS_H
#define HAVE_ASD_MAKE_DOMAINS_H

#include <rdssp.h>
#include <asd_structs.h>

#define LARGE_NEG_GLOB          -2000.0
#define INF_SUB                     1.0
#define ZERO_SUB                    1.0

Asd_Domain_List *
asd_make_multiple_domains(Asd_Domain *d_by_choice, int *num_d_by_choice,
                          Asd_Domain *d_to_split, int num_atoms,
                          Asd_Contact_Info **contact_info,
                          Asd_Contact_Info **contact_rev_info,
                          struct brookn *bn, int start_chain, int end_chain,
                          char *ss);

Asd_Domain_List *
asd_work_out_domains(int num_atoms, Asd_Contact_Info **contact_info,
                     Asd_Contact_Info **contact_rev_info, struct brookn *bn,
                     char cid_g, char *ss);

#endif /*HAVE_ASD_MAKE_DOMAINS_H*/
