/******************************************************************************
 The computer software and associated documentation called DOMAK hereinafter
 referred to as the WORK which is more particularly identified and described in
 Appendix A of the file LICENSE.  Conditions and restrictions for use of
 this package are also in this file.

 This routine was developed by Robert B. Russell

 The WORK was developed by:
        Asim S. Siddiqui and Geoffrey J. Barton
        Laboratory of Molecular Biophysics
        University of Oxford
        Rex Richards Building
        South Parks Road
        Oxford OX1 3QU U.K.
        Tel:  (+44) 865-275379
        FAX:  (+44) 865-510454
        INTERNET: as@bioch.ox.ac.uk
        JANET:    as@uk.ac.ox.bioch

 The WORK is Copyright (1995) University of Oxford
        Administrative Offices
        Wellington Square
        Oxford OX1 2JD U.K.

 All use of the WORK must cite:
 Siddiqui, A. S. and Barton, G. J., "Continuous and Discontinuous Domains: An
 Algorithm for the Automatic Generation of Reliable Protein Domain Definitions" 
 PROTEIN SCIENCE, 4:872-884 (1995).
*****************************************************************************/

#include <stdio.h>
#include "structs.h"

/* Reads in paramters from a specified file
 *
 * for example
 *
 *  WINDOW 3   		Window length of three
 *  THRESTATE yes	Use three states only
 *
 * N.B. Comments may only be one line long (no return characters)
 */

struct parameters getpars(fp,test)
FILE *fp;
int *test;
{
    int i,BOOL;
    char c;
    char *parm;		/* name of following dimension */
    char *dim;		/* dimension */
    struct parameters var;

	

   /* set default parameter values
    *  these are changed if a paramter file is specified */
   var.CC_DISTANCE=40.0; 
   var.AA_DISTANCE=0.5; 
   var.HYDROPHOBIC=5.0;
   var.HBOND=3.0; 
   var.DISUL=2.2; 
   var.TOOCLOSE=2.0; 
   var.MUCHTOOCLOSE=1.2; 
   var.ACEFOR=0;
   var.WATERS=0;
   var.FORCE=0;



    parm = (char*)malloc(200*sizeof(char));
    dim  = (char*)malloc(200*sizeof(char));

    while(fscanf(fp,"%s%s",parm,dim) != (int)EOF){
	BOOL=(dim[0]=='y' || dim[0]=='Y' || dim[0]=='1' || dim[0]=='t' || dim[0]=='T');
	for(i=0; i<strlen(parm); ++i)
	   parm[i]=RBR_ltou(parm[i]); /* convert to upper case */
	/* enables one to write '1', 'YES', 'Yes', 'yes', 'BOOL', 'True' or 'true' to 
	 *  set any boolean variable to one */
	if(strcmp(parm,"CC_DISTANCE")==0)
		sscanf(dim,"%f",&var.CC_DISTANCE);
	else if(strcmp(parm,"AA_DISTANCE")==0)
		sscanf(dim,"%f",&var.AA_DISTANCE);
	else if(strcmp(parm,"HYDROPHOBIC")==0)
		sscanf(dim,"%f",&var.HYDROPHOBIC);
	else if(strcmp(parm,"HBOND")==0)
		sscanf(dim,"%f",&var.HBOND);
	else if(strcmp(parm,"DISUL")==0)
		sscanf(dim,"%f",&var.DISUL);
	else if(strcmp(parm,"TOOCLOSE")==0)
		sscanf(dim,"%f",&var.TOOCLOSE);
	else if(strcmp(parm,"ACEFOR")==0)
		var.ACEFOR=BOOL;
	else if(strcmp(parm,"WATERS")==0)
		var.WATERS=BOOL;
	else if(strcmp(parm,"VDW_FILE")==0)
		strcpy(&var.VDW_FILE[0],dim);
	else if(strcmp(parm,"MUCHTOOCLOSE")==0)
		sscanf(dim,"%f",&var.MUCHTOOCLOSE);
	else if(strcmp(parm,"SQTOOCLOSE")==0)
		sscanf(dim,"%f",&var.SQTOOCLOSE);
	else if(strcmp(parm,"SQMUCHTOOCLOSE")==0)
		sscanf(dim,"%f",&var.SQMUCHTOOCLOSE);
	else{
    	    printf("Unrecognised Dimension Command\n");
	    printf("%s %s\n",parm,dim);
	    *test=0;
	    return var;
	}
	while((c=getc(fp))!=(char)EOF && c!='\n'); /* read the end of the line, allows for comments */
	if(c==(char)EOF) break;
    }
    free(parm); free(dim); 
    *test=1;

    return var;
}
