/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine;

import compbio.data.sequence.FastaSequence;
import compbio.engine.AsyncExecutor;
import compbio.engine.LoadBalancer;
import compbio.engine.SyncExecutor;
import compbio.engine.client.ConfExecutable;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.engine.client.Executable;
import compbio.engine.client.PathValidator;
import compbio.engine.cluster.drmaa.AsyncClusterRunner;
import compbio.engine.cluster.drmaa.ClusterRunner;
import compbio.engine.conf.DirectoryManager;
import compbio.engine.conf.PropertyHelperManager;
import compbio.engine.local.AsyncLocalRunner;
import compbio.engine.local.LocalRunner;
import compbio.metadata.JobSubmissionException;
import compbio.util.PropertyHelper;
import compbio.util.SysPrefs;
import compbio.util.Util;
import java.io.File;
import java.security.InvalidParameterException;
import java.util.List;
import org.apache.log4j.Logger;

public class Configurator {
    private static Logger log = Logger.getLogger(Configurator.class);
    private static final PropertyHelper ph = PropertyHelperManager.getPropertyHelper();
    public static final boolean IS_LOCAL_ENGINE_ENABLED = Configurator.initBooleanValue("engine.local.enable");
    public static final boolean IS_CLUSTER_ENGINE_ENABLED = Configurator.initBooleanValue("engine.cluster.enable");
    public static final String LOCAL_WORK_DIRECTORY = Configurator.initLocalDirectory();
    public static final String CLUSTER_WORK_DIRECTORY = Configurator.initClusterWorkDirectory();

    private static boolean initBooleanValue(String string) {
        assert (string != null);
        String string2 = ph.getProperty(string);
        log.debug("Loading property: " + string + " with value: " + string2);
        if (Util.isEmpty(string2)) {
            return false;
        }
        return new Boolean(string2.trim());
    }

    private static String initClusterWorkDirectory() {
        String string = null;
        if (IS_CLUSTER_ENGINE_ENABLED) {
            string = ph.getProperty("cluster.tmp.directory");
            if (Util.isEmpty(string)) {
                throw new RuntimeException("Cluster work directory must be provided! ");
            }
            string = string.trim();
            if (LOCAL_WORK_DIRECTORY != null && LOCAL_WORK_DIRECTORY.equals(CLUSTER_WORK_DIRECTORY)) {
                throw new InvalidParameterException("Cluster engine output directory must be different of that for local engine!");
            }
        }
        return string;
    }

    private static String initLocalDirectory() {
        String string = ph.getProperty("local.tmp.directory");
        if (Util.isEmpty(string)) {
            string = SysPrefs.getSystemTmpDir();
            log.debug("local.tmp.directory is not defined using system tmp: " + string);
        }
        if (!PathValidator.isAbsolutePath(string)) {
            log.debug("local.tmp.directory path is relative! " + string);
            string = EngineUtil.convertToAbsolute(string);
            log.debug("local.tmp.directory path changed to absolute: " + string);
        }
        return string.trim();
    }

    static Executable.ExecProvider getExecProvider(ConfiguredExecutable<?> configuredExecutable, List<FastaSequence> list) throws JobSubmissionException {
        Executable.ExecProvider execProvider = configuredExecutable.getSupportedRuntimes();
        if (!IS_CLUSTER_ENGINE_ENABLED && !IS_LOCAL_ENGINE_ENABLED) {
            throw new RuntimeException("Both engines are disabled! Check conf/Engine.cluster.properties and conf/Engine.local.properties. At least one engine must be enabled!");
        }
        if (execProvider == Executable.ExecProvider.Local) {
            if (IS_LOCAL_ENGINE_ENABLED) {
                return Executable.ExecProvider.Local;
            }
            throw new JobSubmissionException("Executable can be executed only on locally, but local engine is disabled!");
        }
        if (execProvider == Executable.ExecProvider.Cluster) {
            if (IS_CLUSTER_ENGINE_ENABLED) {
                return Executable.ExecProvider.Cluster;
            }
            throw new JobSubmissionException("Executable can be executed only on the cluster, but cluster engine is disabled!");
        }
        if (SysPrefs.isWindows) {
            return Executable.ExecProvider.Local;
        }
        if (IS_CLUSTER_ENGINE_ENABLED && IS_LOCAL_ENGINE_ENABLED) {
            if (list == null) {
                return LoadBalancer.getEngine(configuredExecutable);
            }
            return LoadBalancer.getEngine(configuredExecutable, list);
        }
        if (IS_CLUSTER_ENGINE_ENABLED) {
            return Executable.ExecProvider.Cluster;
        }
        return Executable.ExecProvider.Local;
    }

    public static <T> ConfiguredExecutable<T> configureExecutable(Executable<T> executable) throws JobSubmissionException {
        ConfExecutable<T> confExecutable = new ConfExecutable<T>(executable, DirectoryManager.getTaskDirectory(executable.getClass()));
        Executable.ExecProvider execProvider = Configurator.getExecProvider(confExecutable, null);
        confExecutable.setExecProvider(execProvider);
        Configurator.setupWorkDirectory(confExecutable, execProvider);
        return confExecutable;
    }

    public static <T> ConfiguredExecutable<T> configureExecutable(Executable<T> executable, List<FastaSequence> list) throws JobSubmissionException {
        ConfExecutable<T> confExecutable = new ConfExecutable<T>(executable, DirectoryManager.getTaskDirectory(executable.getClass()));
        Executable.ExecProvider execProvider = Configurator.getExecProvider(confExecutable, list);
        confExecutable.setExecProvider(execProvider);
        Configurator.setupWorkDirectory(confExecutable, execProvider);
        return confExecutable;
    }

    static <T> void setupWorkDirectory(ConfExecutable<T> confExecutable, Executable.ExecProvider execProvider) {
        assert (execProvider != null && execProvider != Executable.ExecProvider.Any);
        String string = "";
        string = execProvider == Executable.ExecProvider.Local ? LOCAL_WORK_DIRECTORY + File.separator + confExecutable.getTaskId() : CLUSTER_WORK_DIRECTORY + File.separator + confExecutable.getTaskId();
        File file = new File(string);
        file.mkdir();
        log.info("Creating working directory for the task in: " + file.getAbsolutePath());
        confExecutable.setWorkDirectory(string);
    }

    public static <T> ConfiguredExecutable<T> configureExecutable(Executable<T> executable, Executable.ExecProvider execProvider) throws JobSubmissionException {
        if (executable == null) {
            throw new InvalidParameterException("Executable must be provided!");
        }
        ConfExecutable<T> confExecutable = new ConfExecutable<T>(executable, DirectoryManager.getTaskDirectory(executable.getClass()));
        if (execProvider == Executable.ExecProvider.Cluster && !IS_CLUSTER_ENGINE_ENABLED) {
            throw new JobSubmissionException("Cluster engine is disabled or not configured!");
        }
        if (execProvider == Executable.ExecProvider.Local && !IS_LOCAL_ENGINE_ENABLED) {
            throw new JobSubmissionException("Local engine is disabled or not configured!");
        }
        confExecutable.setExecProvider(execProvider);
        Configurator.setupWorkDirectory(confExecutable, execProvider);
        return confExecutable;
    }

    public static AsyncExecutor getAsyncEngine(ConfiguredExecutable<?> configuredExecutable, Executable.ExecProvider execProvider) {
        assert (execProvider != Executable.ExecProvider.Any && execProvider != null);
        if (execProvider == Executable.ExecProvider.Cluster) {
            return new AsyncClusterRunner();
        }
        return new AsyncLocalRunner();
    }

    public static SyncExecutor getSyncEngine(ConfiguredExecutable<?> configuredExecutable, Executable.ExecProvider execProvider) throws JobSubmissionException {
        assert (execProvider != Executable.ExecProvider.Any && execProvider != null);
        if (execProvider == Executable.ExecProvider.Cluster) {
            return ClusterRunner.getInstance(configuredExecutable);
        }
        return new LocalRunner(configuredExecutable);
    }

    public static AsyncExecutor getAsyncEngine(ConfiguredExecutable<?> configuredExecutable) {
        if (Configurator.isTargetedForLocalExecution(configuredExecutable)) {
            return new AsyncLocalRunner();
        }
        return new AsyncClusterRunner();
    }

    public static AsyncExecutor getAsyncEngine(String string) {
        if (Configurator.isLocal(string)) {
            return new AsyncLocalRunner();
        }
        return new AsyncClusterRunner();
    }

    public static SyncExecutor getSyncEngine(ConfiguredExecutable<?> configuredExecutable) throws JobSubmissionException {
        if (Configurator.isTargetedForLocalExecution(configuredExecutable)) {
            return new LocalRunner(configuredExecutable);
        }
        return ClusterRunner.getInstance(configuredExecutable);
    }

    static boolean isTargetedForLocalExecution(ConfiguredExecutable<?> configuredExecutable) {
        String string = configuredExecutable.getTaskId();
        return Configurator.isLocal(string);
    }

    static boolean isLocal(String string) {
        if (Util.isEmpty(string)) {
            throw new NullPointerException("TaskId must be provided!");
        }
        if (!EngineUtil.isValidJobId(string)) {
            throw new InvalidParameterException("TaskId is not valid!");
        }
        return !string.startsWith("@");
    }

    public static String getWorkDirectory(String string) {
        assert (!Util.isEmpty(string));
        assert (EngineUtil.isValidJobId(string));
        log.info("Getting workdirectory for TaskID: " + string);
        if (string.startsWith("@")) {
            return CLUSTER_WORK_DIRECTORY + File.separator + string;
        }
        return LOCAL_WORK_DIRECTORY + File.separator + string;
    }
}

