/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine;

import compbio.engine.client.PathValidator;
import compbio.metadata.ChunkHolder;
import compbio.util.FileWatcher;
import compbio.util.Util;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.log4j.Logger;

public class FilePuller
implements Delayed {
    private static final Logger log = Logger.getLogger(FilePuller.class);
    private static long defaultDelay = 300000000000L;
    private final File file;
    private long lastAccessTime;
    private FileWatcher watcher;
    final int chunkSize;
    long delay = 0L;

    private FilePuller(String string, int n) {
        FileWatcher.validateInput(string, n);
        if (Util.isEmpty(string)) {
            throw new NullPointerException("File name must be provided!");
        }
        if (!PathValidator.isAbsolutePath(string)) {
            throw new IllegalArgumentException("Absolute path to the File " + string + " is expected but not provided!");
        }
        this.file = new File(string);
        this.chunkSize = n;
        this.lastAccessTime = System.nanoTime();
    }

    private FilePuller(String string) {
        if (Util.isEmpty(string)) {
            throw new NullPointerException("File name must be provided!");
        }
        if (!PathValidator.isAbsolutePath(string)) {
            throw new IllegalArgumentException("Absolute path to the File " + string + " is expected but not provided!");
        }
        this.file = new File(string);
        this.chunkSize = 3;
        this.lastAccessTime = System.nanoTime();
    }

    public static FilePuller newFilePuller(String string, int n) {
        return new FilePuller(string, n);
    }

    public static FilePuller newProgressPuller(String string) {
        return new FilePuller(string);
    }

    public ChunkHolder pull(long l) throws IOException {
        this.initPull();
        String string = this.watcher.pull(l);
        String string2 = null;
        if (string != null) {
            string2 = FilePuller.removeInvalidXMLCharacters(string);
        }
        return new ChunkHolder(string2, this.watcher.getCursorPosition());
    }

    static String removeInvalidXMLCharacters(String string) {
        int n;
        assert (string != null);
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = null;
        try {
            string2 = new String(string.getBytes("UTF-8"), "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new AssertionError((Object)"UTF-8 charset is not supported!!!");
        }
        for (int i = 0; i < string2.length(); i += Character.charCount(n)) {
            n = string2.codePointAt(i);
            if (!(n == 9 || n == 10 || n == 13 || n >= 32 && n <= 55295 || n >= 57344 && n <= 65533) && (n < 65536 || n > 0x10FFFF)) continue;
            stringBuilder.append(Character.toChars(n));
        }
        return stringBuilder.toString();
    }

    public void initPull() {
        this.lastAccessTime = System.nanoTime();
        if (!this.isFileCreated()) {
            throw new IllegalStateException("File " + this.file.getAbsolutePath() + " has not been created yet! Cannot pull.");
        }
        if (this.watcher == null) {
            this.init();
        }
    }

    public String getFile() {
        return this.file.getAbsolutePath();
    }

    public boolean isFileCreated() {
        this.lastAccessTime = System.nanoTime();
        return this.file.exists();
    }

    public void waitForFile(long l) {
        long l2 = 0L;
        int n = 500;
        while (!this.isFileCreated()) {
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                log.debug("Thread interruped during waiting for file " + this.file.getAbsolutePath() + " to be created. Message: " + interruptedException.getMessage());
                break;
            }
            if ((l2 += (long)n) / 1000L < l) continue;
            break;
        }
    }

    public boolean hasMoreData() throws IOException {
        this.lastAccessTime = System.nanoTime();
        if (!this.isFileCreated()) {
            throw new IllegalStateException("File " + this.file.getAbsolutePath() + " has not been created yet! Cannot pull.");
        }
        if (this.watcher == null) {
            this.init();
        }
        return this.watcher.hasMore();
    }

    private synchronized void init() {
        if (this.watcher == null) {
            if (this.chunkSize < 256) {
                this.watcher = FileWatcher.newProgressWatcher(this.file.getAbsolutePath());
                log.debug("Init Progress watcher with file: " + this.file.getAbsolutePath());
            } else {
                this.watcher = FileWatcher.newFileWatcher(this.file.getAbsolutePath(), this.chunkSize);
                log.debug("Init File watcher with file: " + this.file.getAbsolutePath());
            }
        }
    }

    @Override
    public int compareTo(Delayed delayed) {
        return new Long(this.getDelay(TimeUnit.NANOSECONDS)).compareTo(delayed.getDelay(TimeUnit.NANOSECONDS));
    }

    @Override
    public long getDelay(TimeUnit timeUnit) {
        long l = System.nanoTime() - this.lastAccessTime;
        long l2 = this.delay == 0L ? defaultDelay : this.delay;
        return timeUnit.convert(l2 - l, TimeUnit.NANOSECONDS);
    }

    void setDelay(long l, TimeUnit timeUnit) {
        assert (l > 0L);
        this.delay = TimeUnit.NANOSECONDS.convert(l, timeUnit);
        assert (l < defaultDelay);
    }

    long getDelayValue(TimeUnit timeUnit) {
        return this.delay == 0L ? timeUnit.convert(defaultDelay, TimeUnit.NANOSECONDS) : timeUnit.convert(this.delay, TimeUnit.NANOSECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disconnect() {
        FilePuller filePuller = this;
        synchronized (filePuller) {
            if (this.watcher != null) {
                this.watcher.disconnect();
                this.watcher = null;
            }
        }
    }

    boolean disconnected() {
        return this.watcher == null;
    }

    public String toString() {
        String string = "File: " + this.file.getAbsolutePath() + "\n";
        string = string + "Delay (s): " + this.getDelayValue(TimeUnit.SECONDS) + "\n";
        long l = this.getDelay(TimeUnit.MILLISECONDS);
        string = l > 0L ? string + "Expire in (ms): " + l + "\n" : string + "This object has expired\n";
        string = string + "ChunkSize  " + this.chunkSize + "\n";
        return string;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof FilePuller)) {
            return false;
        }
        FilePuller filePuller = (FilePuller)object;
        return this.file.equals(filePuller.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    public byte getProgress() throws IOException {
        this.initPull();
        return this.watcher.getProgress();
    }
}

