/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine;

import compbio.data.sequence.FastaSequence;
import compbio.engine.client.Executable;
import compbio.engine.local.LocalExecutorService;
import compbio.metadata.Limit;
import java.util.List;
import org.apache.log4j.Logger;

public class LoadBalancer {
    private static Logger log = Logger.getLogger(LoadBalancer.class);

    private LoadBalancer() {
    }

    public static Executable.ExecProvider getEngine(Executable<?> executable) {
        if (LocalExecutorService.getExecutor().canAcceptMoreWork()) {
            log.debug("LOCAL engine HAS FREE threads will execute ... ");
            return Executable.ExecProvider.Local;
        }
        log.debug("NO free threads on the LOCAL engine! Targeting for CLUSTER execution... ");
        return Executable.ExecProvider.Cluster;
    }

    public static <T, V> Executable.ExecProvider getEngine(Executable<V> executable, List<FastaSequence> list) {
        Limit<V> limit = executable.getLimit("# LocalEngineExecutionLimit #");
        log.trace("Inspecting whether the job can be executed locally using limit: " + limit);
        if (limit == null || limit.isExceeded(list)) {
            log.debug("Job EXCEEDS LOCAL execution LIMIT targeting for cluster execution! ");
            return Executable.ExecProvider.Cluster;
        }
        log.debug("Job FITS into the LOCAL execution limit consulting load balancer... ");
        return LoadBalancer.getEngine(executable);
    }
}

