/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.client;

import compbio.engine.client.CommandBuilder;
import compbio.engine.client.EngineUtil;
import compbio.engine.client.Executable;
import compbio.engine.client.PathValidator;
import compbio.engine.client.RunConfiguration;
import compbio.engine.conf.PropertyHelperManager;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.util.PropertyHelper;
import compbio.util.Util;
import java.io.File;
import java.security.InvalidParameterException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public abstract class SkeletalExecutable<T>
implements Executable<T> {
    protected static final PropertyHelper ph = PropertyHelperManager.getPropertyHelper();
    private static Logger log = Logger.getLogger(SkeletalExecutable.class);
    private LimitsManager<T> limits;
    public static final String INPUT = "input.txt";
    public static final String OUTPUT = "result.txt";
    public static final String ERROR = "error.txt";
    protected String inputFile = "input.txt";
    protected String outputFile = "result.txt";
    protected String errorFile = "error.txt";
    private boolean isInputSet = false;
    private boolean isOutputSet = false;
    private boolean isErrorSet = false;
    protected CommandBuilder<T> cbuilder;

    public SkeletalExecutable() {
        this.cbuilder = new CommandBuilder(" ");
    }

    public SkeletalExecutable(String string) {
        assert (string != null);
        this.cbuilder = new CommandBuilder(string);
    }

    public SkeletalExecutable<T> setInput(String string) {
        if (Util.isEmpty(string)) {
            throw new IllegalArgumentException("Input file must not be NULL");
        }
        this.inputFile = string;
        this.isInputSet = true;
        return this;
    }

    public SkeletalExecutable<T> setOutput(String string) {
        if (Util.isEmpty(string) || PathValidator.isAbsolutePath(string)) {
            throw new IllegalArgumentException("Output file must not be NULL and Absolute path could not be used! Please provide the filename only. Value provided: " + string);
        }
        this.outputFile = string;
        this.isOutputSet = true;
        return this;
    }

    public SkeletalExecutable<T> setError(String string) {
        if (Util.isEmpty(string) || PathValidator.isAbsolutePath(string)) {
            throw new IllegalArgumentException("Error file must not be NULL and Absolute path could not be used! Please provide the filename only. Value provided: " + string);
        }
        this.errorFile = string;
        this.isErrorSet = true;
        return this;
    }

    @Override
    public CommandBuilder<T> getParameters(Executable.ExecProvider execProvider) {
        this.paramValueUpdater();
        return this.cbuilder;
    }

    @Override
    public Executable<T> addParameters(List<String> list) {
        this.cbuilder.addParams(list);
        return this;
    }

    public Executable<T> setParameter(String string) {
        this.cbuilder.setParam(string);
        return this;
    }

    void paramValueUpdater() {
        for (CommandBuilder.Parameter parameter : this.cbuilder.getCommandList()) {
            String string;
            if (parameter.value == null || Util.isEmpty(string = EngineUtil.getExecProperty(parameter.name + ".path", this.getType())) || new File(parameter.value).isAbsolute()) continue;
            String string2 = EngineUtil.convertToAbsolute(string);
            parameter.value = string2 + File.separator + parameter.value;
            this.cbuilder.setParam(parameter);
        }
    }

    @Override
    public List<String> getCreatedFiles() {
        return Arrays.asList(this.getOutput(), this.getError());
    }

    @Override
    public String getInput() {
        return this.inputFile;
    }

    protected boolean isInputSet() {
        return this.isInputSet;
    }

    protected boolean isOutputSet() {
        return this.isOutputSet;
    }

    protected boolean isErrorSet() {
        return this.isErrorSet;
    }

    @Override
    public String getOutput() {
        return this.outputFile;
    }

    @Override
    public String getError() {
        return this.errorFile;
    }

    public String toString() {
        String string = "Input: " + this.getInput() + "\n";
        string = string + "Output: " + this.getOutput() + "\n";
        string = string + "Error: " + this.getError() + "\n";
        string = string + "Class: " + this.getClass() + "\n";
        string = string + "Params: " + this.cbuilder + "\n";
        return string;
    }

    @Override
    public Executable<?> loadRunConfiguration(RunConfiguration runConfiguration) {
        if (!Util.isEmpty(runConfiguration.getOutput())) {
            this.setOutput(runConfiguration.getOutput());
        }
        if (!Util.isEmpty(runConfiguration.getError())) {
            this.setError(runConfiguration.getError());
        }
        if (!Util.isEmpty(runConfiguration.getInput())) {
            this.setInput(runConfiguration.getInput());
        }
        this.cbuilder = runConfiguration.getParameters();
        return this;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof SkeletalExecutable)) {
            return false;
        }
        SkeletalExecutable skeletalExecutable = (SkeletalExecutable)object;
        if (!(Util.isEmpty(this.inputFile) || Util.isEmpty(skeletalExecutable.inputFile) || this.inputFile.equals(skeletalExecutable.inputFile))) {
            return false;
        }
        if (!(Util.isEmpty(this.outputFile) || Util.isEmpty(skeletalExecutable.outputFile) || this.outputFile.equals(skeletalExecutable.outputFile))) {
            return false;
        }
        if (!(Util.isEmpty(this.errorFile) || Util.isEmpty(skeletalExecutable.errorFile) || this.errorFile.equals(skeletalExecutable.errorFile))) {
            return false;
        }
        return this.cbuilder.equals(skeletalExecutable.cbuilder);
    }

    public int hashCode() {
        int n = this.inputFile.hashCode();
        n += this.outputFile.hashCode();
        n += this.errorFile.hashCode();
        return n *= this.cbuilder.hashCode();
    }

    @Override
    public String getClusterJobSettings() {
        String string = ph.getProperty(this.getType().getSimpleName().toLowerCase() + ".cluster.settings");
        return string == null ? "" : string;
    }

    public static int getClusterCpuNum(Class<? extends Executable<?>> clazz) {
        int n = 0;
        String string = ph.getProperty(clazz.getSimpleName().toLowerCase() + ".cluster.cpunum");
        if (Util.isEmpty(string)) {
            return 0;
        }
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            log.debug("Number of cpus to use for cluster execution is defined but could not be parsed as integer! Given value is: " + string);
            return 0;
        }
        if (n < 1 || n > 100) {
            throw new InvalidParameterException("Number of cpu for cluster execution must be within 1 and 100! Look at the value of 'tcoffee.cluster.cpunum' property. Given value is " + n);
        }
        return n;
    }

    @Override
    public synchronized Limit<T> getLimit(String string) {
        if (this.limits == null) {
            this.limits = this.getLimits();
        }
        if (this.limits == null) {
            return null;
        }
        Limit<T> limit = null;
        if (this.limits != null) {
            limit = this.limits.getLimitByName(string);
        }
        if (limit == null) {
            log.debug("Limit for the preset " + string + " is not found. Using default");
            limit = this.limits.getDefaultLimit();
        }
        return limit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LimitsManager<T> getLimits() {
        Class<SkeletalExecutable> clazz = SkeletalExecutable.class;
        synchronized (SkeletalExecutable.class) {
            if (this.limits == null) {
                this.limits = EngineUtil.getLimits(this.getType());
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return this.limits;
        }
    }

    public abstract Class<T> getType();
}

