/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.cluster.drmaa;

import compbio.engine.AsyncExecutor;
import compbio.engine.Cleaner;
import compbio.engine.Configurator;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.engine.cluster.drmaa.ClusterEngineUtil;
import compbio.engine.cluster.drmaa.ClusterRunner;
import compbio.engine.cluster.drmaa.ClusterSession;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.ResultNotAvailableException;
import org.apache.log4j.Logger;
import org.ggf.drmaa.DrmaaException;

public class AsyncClusterRunner
implements AsyncExecutor {
    private static Logger log = Logger.getLogger(AsyncClusterRunner.class);

    @Override
    public String submitJob(ConfiguredExecutable<?> configuredExecutable) throws JobSubmissionException {
        ClusterRunner clusterRunner = new ClusterRunner(configuredExecutable);
        clusterRunner.submitJob();
        return configuredExecutable.getTaskId();
    }

    @Override
    public boolean cancelJob(String string) {
        ClusterSession clusterSession = ClusterSession.getInstance();
        return ClusterEngineUtil.cancelJob(string, clusterSession);
    }

    @Override
    public JobStatus getJobStatus(String string) {
        return ClusterRunner.getJobStatus(string);
    }

    @Override
    public boolean cleanup(String string) {
        String string2 = Configurator.getWorkDirectory(string);
        return Cleaner.deleteAllFiles(string2);
    }

    @Override
    public ConfiguredExecutable<?> getResults(String string) throws ResultNotAvailableException {
        ConfiguredExecutable<?> configuredExecutable;
        assert (EngineUtil.isValidJobId(string));
        ClusterSession clusterSession = ClusterSession.getInstance();
        try {
            configuredExecutable = clusterSession.getResults(string);
        }
        catch (DrmaaException drmaaException) {
            log.error(drmaaException.getLocalizedMessage(), drmaaException.getCause());
            throw new ResultNotAvailableException(drmaaException);
        }
        return configuredExecutable;
    }

    @Override
    public String getWorkDirectory(String string) {
        return Configurator.getWorkDirectory(string);
    }
}

