/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.cluster.drmaa;

import compbio.engine.Cleaner;
import compbio.engine.ClusterJobId;
import compbio.engine.Configurator;
import compbio.engine.SyncExecutor;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.engine.client.Executable;
import compbio.engine.client.PathValidator;
import compbio.engine.client.PipedExecutable;
import compbio.engine.cluster.drmaa.AsyncClusterRunner;
import compbio.engine.cluster.drmaa.ClusterEngineUtil;
import compbio.engine.cluster.drmaa.ClusterSession;
import compbio.metadata.JobExecutionException;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.ResultNotAvailableException;
import compbio.util.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.ggf.drmaa.DrmaaException;
import org.ggf.drmaa.InvalidJobException;
import org.ggf.drmaa.JobInfo;
import org.ggf.drmaa.JobTemplate;
import org.ggf.drmaa.Session;

public class ClusterRunner
implements SyncExecutor {
    final JobTemplate jobtempl;
    static ClusterSession clustSession = ClusterSession.getInstance();
    static Session session = clustSession.getSession();
    static final Logger log = Logger.getLogger(ClusterRunner.class);
    final ConfiguredExecutable<?> confExecutable;
    private final String workDirectory;
    String jobId;

    public ClusterRunner(ConfiguredExecutable<?> configuredExecutable) throws JobSubmissionException {
        try {
            List<String> list;
            String string = configuredExecutable.getCommand(Executable.ExecProvider.Cluster);
            PathValidator.validateExecutable(string);
            log.debug("Setting command " + string);
            this.jobtempl = session.createJobTemplate();
            this.jobtempl.setRemoteCommand(string);
            this.jobtempl.setJoinFiles(false);
            this.setJobName(configuredExecutable.getExecutable().getClass().getSimpleName());
            this.workDirectory = configuredExecutable.getWorkDirectory();
            assert (!Util.isEmpty(this.workDirectory));
            this.jobtempl.setWorkingDirectory(this.workDirectory);
            Map<String, String> map = configuredExecutable.getEnvironment();
            if (map != null && !map.isEmpty()) {
                this.setJobEnvironmentVariables(map);
            }
            if ((list = configuredExecutable.getParameters().getCommands()) != null && list.size() > 0) {
                this.jobtempl.setArgs(list);
            }
            if (configuredExecutable.getExecutable() instanceof PipedExecutable) {
                this.setPipes(configuredExecutable);
            }
            this.setNativeSpecs(configuredExecutable.getExecutable());
            log.trace("using arguments: " + this.jobtempl.getArgs());
            this.confExecutable = configuredExecutable;
            configuredExecutable.saveRunConfiguration();
        }
        catch (DrmaaException drmaaException) {
            log.error(drmaaException.getLocalizedMessage(), drmaaException.getCause());
            throw new JobSubmissionException(drmaaException);
        }
        catch (IOException iOException) {
            log.error(iOException.getLocalizedMessage(), iOException.getCause());
            throw new JobSubmissionException(iOException);
        }
    }

    void setPipes(ConfiguredExecutable<?> configuredExecutable) throws DrmaaException {
        String string = configuredExecutable.getOutput();
        String string2 = configuredExecutable.getError();
        if (string != null) {
            if (!string.contains(":")) {
                string = ClusterRunner.makeLocalPath(string);
            }
            this.jobtempl.setOutputPath(string);
            log.debug("Output to: " + this.jobtempl.getOutputPath());
        }
        if (string2 != null) {
            if (!string2.contains(":")) {
                string2 = ClusterRunner.makeLocalPath(string2);
            }
            this.jobtempl.setErrorPath(string2);
            log.debug("Output errors to: " + this.jobtempl.getErrorPath());
        }
    }

    void setNativeSpecs(Executable<?> executable) throws DrmaaException {
        String string = executable.getClusterJobSettings();
        if (!Util.isEmpty(string)) {
            log.debug("Using cluster job settings: " + string);
            this.jobtempl.setNativeSpecification(string);
        }
    }

    void setEmail(String string) {
        log.trace("Setting email to:" + string);
        try {
            this.jobtempl.setEmail(Collections.singleton(string));
            this.jobtempl.setBlockEmail(false);
        }
        catch (DrmaaException drmaaException) {
            log.debug(drmaaException.getLocalizedMessage());
            throw new IllegalArgumentException(drmaaException);
        }
    }

    void setJobName(String string) {
        log.trace("Setting job name to:" + string);
        try {
            this.jobtempl.setJobName(string);
        }
        catch (DrmaaException drmaaException) {
            log.debug(drmaaException.getLocalizedMessage());
            throw new IllegalArgumentException(drmaaException);
        }
    }

    void setJobEnvironmentVariables(Map<String, String> map) {
        assert (map != null && !map.isEmpty());
        try {
            log.trace("Setting job environment to:" + map);
            Map<String, String> map2 = this.jobtempl.getJobEnvironment();
            if (map2 != null && !map2.isEmpty()) {
                EngineUtil.mergeEnvVariables(map2, map);
            } else {
                map2 = map;
            }
            this.jobtempl.setJobEnvironment(map2);
        }
        catch (DrmaaException drmaaException) {
            log.debug(drmaaException.getLocalizedMessage());
            throw new IllegalArgumentException(drmaaException);
        }
    }

    private static String makeLocalPath(String string) {
        return ":" + string;
    }

    public boolean deepClean() {
        throw new UnsupportedOperationException();
    }

    static JobStatus getJobStatus(String string) {
        try {
            ClusterJobId clusterJobId = ClusterSession.getClusterJobId(string);
            switch (clustSession.getJobStatus(clusterJobId)) {
                case 48: {
                    EngineUtil.writeStatFile(Configurator.getWorkDirectory(string), JobStatus.FINISHED.toString());
                    return JobStatus.FINISHED;
                }
                case 64: {
                    EngineUtil.writeMarker(Configurator.getWorkDirectory(string), JobStatus.FAILED);
                    return JobStatus.FAILED;
                }
                case 32: {
                    return JobStatus.RUNNING;
                }
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 33: 
                case 34: 
                case 35: {
                    return JobStatus.PENDING;
                }
            }
            return JobStatus.UNDEFINED;
        }
        catch (InvalidJobException invalidJobException) {
            log.info("Job " + string + " could not be located by DRMAA " + invalidJobException.getLocalizedMessage(), invalidJobException.getCause());
            log.info("Attempting to determine the status by marker files");
            return ClusterRunner.getRecordedJobStatus(string);
        }
        catch (DrmaaException drmaaException) {
            log.error("Exception in DRMAA system while quering the job status: " + drmaaException.getLocalizedMessage(), drmaaException.getCause());
        }
        catch (IOException iOException) {
            log.error("Could not read JOBID for taskId: " + string + " Message: " + iOException.getLocalizedMessage(), iOException.getCause());
        }
        return JobStatus.UNDEFINED;
    }

    static JobStatus getRecordedJobStatus(String string) {
        String string2 = Configurator.getWorkDirectory(string);
        if (EngineUtil.isMarked(string2, JobStatus.FINISHED) || EngineUtil.isMarked(string2, JobStatus.COLLECTED)) {
            return JobStatus.FINISHED;
        }
        if (EngineUtil.isMarked(string2, JobStatus.CANCELLED)) {
            return JobStatus.CANCELLED;
        }
        if (EngineUtil.isMarked(string2, JobStatus.FAILED)) {
            return JobStatus.FAILED;
        }
        return JobStatus.UNDEFINED;
    }

    @Override
    public boolean cleanup() {
        return Cleaner.deleteFiles(this.confExecutable);
    }

    JobInfo waitForJob(String string) throws JobExecutionException {
        assert (EngineUtil.isValidJobId(string));
        return ClusterEngineUtil.waitForResult(clustSession, string);
    }

    boolean cancelJob(String string) {
        assert (EngineUtil.isValidJobId(string));
        return ClusterEngineUtil.cancelJob(string, clustSession);
    }

    @Override
    public boolean cancelJob() {
        return this.cancelJob(this.jobId);
    }

    String submitJob() throws JobSubmissionException {
        try {
            String string = session.runJob(this.jobtempl);
            log.info("submitted single job with jobids:");
            log.info("\t \"" + string + "\"");
            session.deleteJobTemplate(this.jobtempl);
            clustSession.addJob(string, this.confExecutable);
        }
        catch (DrmaaException drmaaException) {
            drmaaException.printStackTrace();
            throw new JobSubmissionException(drmaaException);
        }
        return this.confExecutable.getTaskId();
    }

    @Override
    public String getWorkDirectory() {
        return this.workDirectory;
    }

    @Override
    public void executeJob() throws JobSubmissionException {
        this.jobId = this.submitJob();
    }

    public JobInfo getJobInfo() throws JobExecutionException {
        return this.waitForJob(this.jobId);
    }

    @Override
    public ConfiguredExecutable<?> waitForResult() throws JobExecutionException {
        ConfiguredExecutable<?> configuredExecutable;
        try {
            configuredExecutable = new AsyncClusterRunner().getResults(this.jobId);
            if (configuredExecutable == null) {
                log.warn("Could not find results of job " + this.jobId);
            }
        }
        catch (ResultNotAvailableException resultNotAvailableException) {
            log.error(resultNotAvailableException.getMessage(), resultNotAvailableException.getCause());
            throw new JobExecutionException(resultNotAvailableException);
        }
        return configuredExecutable;
    }

    @Override
    public JobStatus getJobStatus() {
        return ClusterRunner.getJobStatus(this.jobId);
    }

    public static ClusterRunner getInstance(ConfiguredExecutable<?> configuredExecutable) throws JobSubmissionException {
        return new ClusterRunner(configuredExecutable);
    }
}

