/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.conf;

import compbio.util.PropertyHelper;
import compbio.util.Util;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.log4j.Logger;

public final class PropertyHelperManager {
    private static Logger log = Logger.getLogger(PropertyHelperManager.class);
    private static PropertyHelper ph = null;
    public static final String confDir = "conf" + File.separator;

    public static PropertyHelper getPropertyHelper() {
        if (ph == null) {
            try {
                File file = PropertyHelperManager.getResourceFromClasspath(confDir + "Engine.local.properties");
                File file2 = PropertyHelperManager.getResourceFromClasspath(confDir + "Engine.cluster.properties");
                File file3 = PropertyHelperManager.getResourceFromClasspath(confDir + "Executable.properties");
                File file4 = PropertyHelperManager.getResourceFromClasspath(confDir + "GA.properties");
                ph = new PropertyHelper(file, file2, file3, file4);
            }
            catch (IOException iOException) {
                log.warn("Cannot read property files! Reason: " + iOException.getLocalizedMessage(), iOException.getCause());
            }
        }
        return ph;
    }

    static File getResourceFromClasspath(String string) {
        assert (!Util.isEmpty(string));
        String string2 = PropertyHelperManager.getLocalPath();
        File file = new File(string2 + string);
        if (!file.exists()) {
            log.warn("Could not find a resource " + string + " in the classpath!");
        }
        return file;
    }

    public static String getLocalPath() {
        String string = PropertyHelperManager.class.getSimpleName();
        URL uRL = PropertyHelperManager.class.getResource(string + ".class");
        File file = null;
        try {
            file = new File(uRL.toURI());
            for (int i = 0; i < 6; ++i) {
                file = file.getParentFile();
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            String string2 = "Could not find resources path! Problems locating PropertyHelperManager class! ";
            log.error(string2 + uRISyntaxException.getLocalizedMessage(), uRISyntaxException.getCause());
            throw new RuntimeException(string2 + uRISyntaxException.getLocalizedMessage(), uRISyntaxException.getCause());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string3 = "It looks like classes are in the jar file. Attempting a different method to determinine the path to the resources";
            log.debug(string3 + illegalArgumentException.getLocalizedMessage(), illegalArgumentException.getCause());
            try {
                file = new File(PropertyHelperManager.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                for (int i = 0; i < 3; ++i) {
                    file = file.getParentFile();
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                log.error("Could not find resources path! " + uRISyntaxException.getLocalizedMessage(), uRISyntaxException.getCause());
                throw new RuntimeException("Could not find resources path! ", uRISyntaxException.getCause());
            }
        }
        log.debug("Project directory is: " + file.getAbsolutePath());
        return file.getAbsolutePath() + File.separator;
    }

    public static int getIntProperty(String string) {
        if (!Util.isEmpty(string)) {
            return Integer.parseInt(string.trim());
        }
        return -1;
    }

    public static boolean getBooleanProperty(String string) {
        if (!Util.isEmpty(string)) {
            string = string.trim();
            return Boolean.parseBoolean(string);
        }
        return false;
    }
}

