/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.conf;

import compbio.util.SysPrefs;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;

public class RunnerConfigMarshaller<T> {
    private static final Logger log = Logger.getLogger(RunnerConfigMarshaller.class);
    private final JAXBContext ctx;

    public RunnerConfigMarshaller(Class<?> clazz) throws JAXBException {
        this(clazz, null);
    }

    public RunnerConfigMarshaller(Class<?> clazz, Class<?> ... classArray) throws JAXBException {
        if (classArray != null) {
            ArrayList arrayList = new ArrayList(Arrays.asList(classArray));
            arrayList.add(clazz);
            this.ctx = JAXBContext.newInstance((Class[])arrayList.toArray(new Class[0]));
        } else {
            this.ctx = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
    }

    public void write(Object object, OutputStream outputStream) throws JAXBException, IOException {
        Marshaller marshaller = this.ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setSchema(null);
        marshaller.marshal(object, outputStream);
    }

    public void writeAndValidate(Object object, String string, OutputStream outputStream) throws JAXBException, IOException, SAXException {
        Marshaller marshaller = this.ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.noNamespaceSchemaLocation", (Object)string);
        marshaller.setSchema(RunnerConfigMarshaller.getSchema(string));
        marshaller.marshal(object, outputStream);
    }

    void generateSchema(String string, String string2) throws JAXBException, IOException {
        Marshaller marshaller = this.ctx.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        this.ctx.generateSchema((SchemaOutputResolver)new MySchemaOutputResolver(string, string2));
    }

    public static Schema getSchema(String string) throws SAXException {
        String string2 = "http://www.w3.org/2001/XMLSchema";
        SchemaFactory schemaFactory = SchemaFactory.newInstance(string2);
        Schema schema = schemaFactory.newSchema(new StreamSource(string));
        return schema;
    }

    public static Validator getValidator(String string) throws SAXException {
        Schema schema = RunnerConfigMarshaller.getSchema(string);
        Validator validator = schema.newValidator();
        return validator;
    }

    public static Validator getValidator(Schema schema) throws SAXException {
        Validator validator = schema.newValidator();
        return validator;
    }

    public static boolean validate(Validator validator, String string) throws IOException, SAXException {
        try {
            validator.validate(new StreamSource(string));
        }
        catch (SAXException sAXException) {
            sAXException.printStackTrace();
            log.warn("SAXException validating xml" + sAXException.getMessage());
            return false;
        }
        return true;
    }

    public <V> V readAndValidate(InputStream inputStream, Class<V> clazz) throws JAXBException, IOException, SAXException {
        String string = Long.toHexString(System.nanoTime());
        this.generateSchema(SysPrefs.getSystemTmpDir(), string);
        Unmarshaller unmarshaller = this.ctx.createUnmarshaller();
        unmarshaller.setSchema(RunnerConfigMarshaller.getSchema(SysPrefs.getSystemTmpDir() + File.separator + string));
        JAXBElement jAXBElement = unmarshaller.unmarshal((Source)new StreamSource(inputStream), clazz);
        return (V)jAXBElement.getValue();
    }

    public <V> V read(InputStream inputStream, Class<V> clazz) throws JAXBException {
        return this.read(inputStream, clazz, null);
    }

    public <V> V read(InputStream inputStream, Class<V> clazz, Class<?> ... classArray) throws JAXBException {
        Unmarshaller unmarshaller;
        if (inputStream == null) {
            throw new NullPointerException("Input stream must be provided!");
        }
        JAXBContext jAXBContext = null;
        if (classArray != null) {
            unmarshaller = new ArrayList(Arrays.asList(classArray));
            unmarshaller.add(clazz);
            jAXBContext = JAXBContext.newInstance((Class[])unmarshaller.toArray(new Class[0]));
        } else {
            jAXBContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
        }
        unmarshaller = jAXBContext.createUnmarshaller();
        JAXBElement jAXBElement = unmarshaller.unmarshal((Source)new StreamSource(inputStream), clazz);
        return (V)jAXBElement.getValue();
    }

    static class MySchemaOutputResolver
    extends SchemaOutputResolver {
        final String dir;
        final String sname;

        public MySchemaOutputResolver(String string, String string2) {
            this.dir = string;
            this.sname = string2;
        }

        public Result createOutput(String string, String string2) throws IOException {
            return new StreamResult(new File(this.dir, this.sname));
        }
    }
}

