/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine.local;

import compbio.engine.AsyncExecutor;
import compbio.engine.Configurator;
import compbio.engine.SubmissionManager;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.engine.local.LocalEngineUtil;
import compbio.engine.local.LocalRunner;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.ResultNotAvailableException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.log4j.Logger;

public final class AsyncLocalRunner
implements AsyncExecutor {
    private static final Logger log = Logger.getLogger(AsyncLocalRunner.class);

    @Override
    public String getWorkDirectory(String string) {
        return Configurator.getWorkDirectory(string);
    }

    @Override
    public boolean cancelJob(String string) {
        Future<ConfiguredExecutable<?>> future = SubmissionManager.getTask(string);
        if (future == null) {
            log.debug("Did not find future for local job " + string + " will not cancel it. Perhaps it has finished or cancelled already.");
            return false;
        }
        LocalEngineUtil.cancelJob(future, this.getWorkDirectory(string));
        return future.cancel(true);
    }

    @Override
    public JobStatus getJobStatus(String string) {
        Future<ConfiguredExecutable<?>> future = SubmissionManager.getTask(string);
        if (future == null) {
            return LocalEngineUtil.getRecordedJobStatus(string);
        }
        return LocalEngineUtil.getJobStatus(future);
    }

    @Override
    public String submitJob(ConfiguredExecutable<?> configuredExecutable) throws JobSubmissionException {
        if (configuredExecutable == null) {
            throw new NullPointerException("Executable expected!");
        }
        LocalRunner localRunner = new LocalRunner(configuredExecutable);
        localRunner.executeJob();
        Future<ConfiguredExecutable<?>> future = localRunner.getFuture();
        if (future == null) {
            throw new RuntimeException("Future is NULL for executable " + configuredExecutable);
        }
        SubmissionManager.addTask(configuredExecutable, future);
        return configuredExecutable.getTaskId();
    }

    @Override
    public boolean cleanup(String string) {
        Future<ConfiguredExecutable<?>> future = SubmissionManager.getTask(string);
        ConfiguredExecutable<?> configuredExecutable = null;
        try {
            configuredExecutable = future.get();
        }
        catch (InterruptedException interruptedException) {
            log.error("Cannot clean up as calculation was not completed!" + interruptedException.getLocalizedMessage());
        }
        catch (ExecutionException executionException) {
            log.error("Cannot clean up due to ExecutionException " + executionException.getLocalizedMessage());
        }
        if (configuredExecutable == null) {
            return false;
        }
        return LocalEngineUtil.cleanup(configuredExecutable);
    }

    @Override
    public ConfiguredExecutable<?> getResults(String string) throws ResultNotAvailableException {
        if (!EngineUtil.isValidJobId(string)) {
            throw new IllegalArgumentException(string);
        }
        Future<ConfiguredExecutable<?>> future = SubmissionManager.getTask(string);
        if (future == null) {
            ConfiguredExecutable<?> configuredExecutable = EngineUtil.loadExecutable(string);
            return configuredExecutable;
        }
        return LocalEngineUtil.getResults(future, string);
    }
}

