/*
 * Decompiled with CFR 0.152.
 */
package compbio.runner;

import compbio.engine.client.Executable;
import compbio.metadata.Option;
import compbio.metadata.Parameter;
import compbio.metadata.RunnerConfig;
import compbio.metadata.ValueConstrain;
import compbio.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import org.apache.log4j.Logger;

public final class OptionCombinator {
    private static Logger log = Logger.getLogger(OptionCombinator.class);
    private static final String MINVALUE = "-100";
    private static final String MAXVALUE = "100";
    private static final Random rand = new Random();
    private final RunnerConfig<? extends Executable<?>> rconfig;

    public OptionCombinator(RunnerConfig<? extends Executable<?>> runnerConfig) {
        if (runnerConfig == null) {
            throw new IllegalArgumentException("RunnerConfig must be provided!");
        }
        this.rconfig = runnerConfig;
    }

    public List<String> optionsToCommandString(List<Option<?>> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Option<?> option : list) {
            arrayList.add(OptionCombinator.optionToCommandString(option));
        }
        return arrayList;
    }

    public List<String> getOptionsAtRandom() {
        return this.optionsToCommandString(this.getAllOptions());
    }

    public List<Option<?>> getAllOptions() {
        return new ArrayList(this.rconfig.getOptions());
    }

    static String optionToCommandString(Option<?> option) {
        int n = option.getOptionNames().size();
        int n2 = rand.nextInt(n);
        return option.getOptionNames().get(n2);
    }

    public List<Parameter<?>> getAllParameters() {
        ArrayList arrayList = new ArrayList();
        for (Parameter<? extends Executable<?>> parameter : this.rconfig.getParameters()) {
            arrayList.add(parameter);
        }
        return arrayList;
    }

    public List<String> argumentsToCommandString(List<? extends Option<?>> list) {
        return OptionCombinator.argumentsToCommandString(list, this.rconfig);
    }

    public static List<String> argumentsToCommandString(List<? extends Option<?>> list, RunnerConfig<? extends Executable<?>> runnerConfig) {
        if (list == null || runnerConfig == null) {
            throw new NullPointerException("Arguments and RunnerConfig objects must be provided!");
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Option<?> option : list) {
            if (option instanceof Parameter) {
                Parameter parameter = (Parameter)option;
                arrayList.add(parameter.getOptionName() + runnerConfig.getPrmSeparator() + OptionCombinator.getValue(parameter));
                log.trace("Setting parameter " + parameter);
                continue;
            }
            log.trace("Setting option " + option);
            arrayList.add(OptionCombinator.optionToCommandString(option));
        }
        return arrayList;
    }

    public List<String> parametersToCommandString(List<Parameter<?>> list, Map<Parameter<?>, String> map) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Parameter<?> parameter : list) {
            arrayList.add(parameter.getOptionName() + this.rconfig.getPrmSeparator() + map.get(parameter));
        }
        return arrayList;
    }

    public Map<Parameter<?>, String> getAllConstrainedParametersWithBorderValues(boolean bl) {
        HashMap hashMap = new HashMap();
        for (Parameter<Executable<?>> parameter : this.rconfig.getParameters()) {
            ValueConstrain valueConstrain = parameter.getValidValue();
            if (valueConstrain == null) continue;
            String string = this.getUpperBorderValue(parameter);
            if (bl) {
                string = this.getLowBorderValue(parameter);
            }
            hashMap.put(parameter, string);
        }
        return hashMap;
    }

    public Map<Parameter<?>, String> getAllConstrainedParametersWithRandomValues() {
        HashMap hashMap = new HashMap();
        for (Parameter<Executable<?>> parameter : this.rconfig.getParameters()) {
            ValueConstrain valueConstrain = parameter.getValidValue();
            if (valueConstrain == null) continue;
            hashMap.put(parameter, this.getRandomValue(parameter));
        }
        return hashMap;
    }

    String getLowBorderValue(Parameter<?> parameter) {
        assert (parameter != null);
        ValueConstrain valueConstrain = parameter.getValidValue();
        Number number = valueConstrain.getMin();
        return number == null ? MINVALUE : number.toString();
    }

    String getUpperBorderValue(Parameter<?> parameter) {
        assert (parameter != null);
        ValueConstrain valueConstrain = parameter.getValidValue();
        Number number = valueConstrain.getMax();
        return number == null ? MAXVALUE : number.toString();
    }

    String getRandomValue(Parameter<?> parameter) {
        assert (parameter != null);
        String string = this.getLowBorderValue(parameter);
        String string2 = this.getUpperBorderValue(parameter);
        ValueConstrain valueConstrain = parameter.getValidValue();
        if (valueConstrain.getType() == ValueConstrain.Type.Float) {
            return new Double(Util.getRandomNumber(Double.parseDouble(string), Double.parseDouble(string2))).toString();
        }
        return new Integer(Util.getRandomNumber(Integer.parseInt(string), Integer.parseInt(string2))).toString();
    }

    static String getValue(Parameter<?> parameter) {
        assert (parameter != null);
        if (parameter.getDefaultValue() != null) {
            log.trace("Returning default value: " + parameter.getDefaultValue());
            return parameter.getDefaultValue();
        }
        List<String> list = parameter.getPossibleValues();
        int n = rand.nextInt(list.size());
        log.trace("Returning random value: " + list.get(n));
        return list.get(n);
    }
}

