/*
 * Decompiled with CFR 0.152.
 */
package compbio.runner.msa;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.engine.client.SkeletalExecutable;
import compbio.metadata.ResultNotAvailableException;
import compbio.runner.RunnerUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class ClustalW
extends SkeletalExecutable<ClustalW> {
    private static Logger log = Logger.getLogger(ClustalW.class);
    private static final String EXEC_STAT_FILE = "stat.log";
    private static final String TREE_FILE_EXT = ".dnd";
    public static final String KEY_VALUE_SEPARATOR = "=";

    public ClustalW() {
        super(KEY_VALUE_SEPARATOR);
        this.addParameters(Arrays.asList("-OUTORDER=ALIGNED", "-QUIET", "-STATS=stat.log"));
        this.setInput(this.inputFile);
        this.setOutput(this.outputFile);
        this.setError(this.errorFile);
    }

    public ClustalW setOutput(String string) {
        super.setOutput(string);
        this.cbuilder.setParam("-OUTFILE=" + string);
        return this;
    }

    public ClustalW setInput(String string) {
        super.setInput(string);
        this.cbuilder.setParam("-INFILE=" + string);
        return this;
    }

    @Override
    public Alignment getResults(String string) throws ResultNotAvailableException {
        try {
            return RunnerUtil.readClustalFile(string, this.getOutput());
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(fileNotFoundException.getMessage(), fileNotFoundException.getCause());
            throw new ResultNotAvailableException(fileNotFoundException);
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage(), iOException.getCause());
            throw new ResultNotAvailableException(iOException);
        }
        catch (UnknownFileFormatException unknownFileFormatException) {
            log.error(unknownFileFormatException.getMessage(), unknownFileFormatException.getCause());
            throw new ResultNotAvailableException(unknownFileFormatException);
        }
        catch (NullPointerException nullPointerException) {
            log.error(nullPointerException.getMessage(), nullPointerException.getCause());
            throw new ResultNotAvailableException(nullPointerException);
        }
    }

    @Override
    public List<String> getCreatedFiles() {
        return Arrays.asList(this.getOutput(), EXEC_STAT_FILE, this.convertInputNameToTreeName());
    }

    private String convertInputNameToTreeName() {
        assert (super.getInput() != null);
        int n = this.getInput().lastIndexOf(".");
        String string = "";
        if (n > 0) {
            string = this.getInput().substring(0, n);
        }
        return string + TREE_FILE_EXT;
    }

    public static String getStatFile() {
        return EXEC_STAT_FILE;
    }

    @Override
    public Class<ClustalW> getType() {
        return this.getClass();
    }
}

