/*
 * Decompiled with CFR 0.152.
 */
package compbio.runner.msa;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.engine.client.PipedExecutable;
import compbio.engine.client.SkeletalExecutable;
import compbio.metadata.ResultNotAvailableException;
import compbio.runner.RunnerUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class GLprobs
extends SkeletalExecutable<GLprobs>
implements PipedExecutable<GLprobs> {
    private static Logger log = Logger.getLogger(GLprobs.class);
    private static final String ANNOTATION = "annotation.txt";
    public static final String KEY_VALUE_SEPARATOR = " ";

    public GLprobs() {
        this.addParameters(Arrays.asList("-v", "-clustalw", "-annot", ANNOTATION));
    }

    @Override
    public Alignment getResults(String string) throws ResultNotAvailableException {
        try {
            return RunnerUtil.readClustalFile(string, this.getOutput());
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(fileNotFoundException.getMessage(), fileNotFoundException.getCause());
            throw new ResultNotAvailableException(fileNotFoundException);
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage(), iOException.getCause());
            throw new ResultNotAvailableException(iOException);
        }
        catch (UnknownFileFormatException unknownFileFormatException) {
            log.error(unknownFileFormatException.getMessage(), unknownFileFormatException.getCause());
            throw new ResultNotAvailableException(unknownFileFormatException);
        }
        catch (NullPointerException nullPointerException) {
            log.error(nullPointerException.getMessage(), nullPointerException.getCause());
            throw new ResultNotAvailableException(nullPointerException);
        }
    }

    @Override
    public List<String> getCreatedFiles() {
        return Arrays.asList(this.getOutput(), ANNOTATION, this.getError());
    }

    public GLprobs setInput(String string) {
        String string2 = this.getInput();
        super.setInput(string);
        this.cbuilder.setParam(string);
        return this;
    }

    @Override
    public Class<GLprobs> getType() {
        return this.getClass();
    }
}

