/*
 * Decompiled with CFR 0.152.
 */
package compbio.runner.msa;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.engine.client.PipedExecutable;
import compbio.engine.client.SkeletalExecutable;
import compbio.metadata.ResultNotAvailableException;
import compbio.runner.RunnerUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class Mafft
extends SkeletalExecutable<Mafft>
implements PipedExecutable<Mafft> {
    private static Logger log = Logger.getLogger(Mafft.class);
    private static String autoOption = "--auto";
    private final String MATRIX_PAR_NAME = "--aamatrix";
    public static final String KEY_VALUE_SEPARATOR = " ";

    public Mafft() {
        this.addParameters((List)Arrays.asList("--clustalout", autoOption));
    }

    @Override
    public Alignment getResults(String string) throws ResultNotAvailableException {
        try {
            return RunnerUtil.readClustalFile(string, this.getOutput());
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(fileNotFoundException.getMessage(), fileNotFoundException.getCause());
            throw new ResultNotAvailableException(fileNotFoundException);
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage(), iOException.getCause());
            throw new ResultNotAvailableException(iOException);
        }
        catch (UnknownFileFormatException unknownFileFormatException) {
            log.error(unknownFileFormatException.getMessage(), unknownFileFormatException.getCause());
            throw new ResultNotAvailableException(unknownFileFormatException);
        }
        catch (NullPointerException nullPointerException) {
            log.error(nullPointerException.getMessage(), nullPointerException.getCause());
            throw new ResultNotAvailableException(nullPointerException);
        }
    }

    public Mafft setInput(String string) {
        super.setInput(string);
        this.cbuilder.setLast(string);
        return this;
    }

    public Mafft addParameters(List<String> list) {
        this.cbuilder.addParams(list);
        this.cbuilder.removeParam(autoOption);
        return this;
    }

    @Override
    public Class<Mafft> getType() {
        return this.getClass();
    }
}

