/*
 * Decompiled with CFR 0.152.
 */
package compbio.runner.msa;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.engine.client.SkeletalExecutable;
import compbio.metadata.ResultNotAvailableException;
import compbio.runner.RunnerUtil;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlTransient;
import org.apache.log4j.Logger;

public class Muscle
extends SkeletalExecutable<Muscle> {
    @XmlTransient
    private static Logger log = Logger.getLogger(Muscle.class);
    private static final String EXEC_STAT_FILE = "stat.log";
    public static final String KEY_VALUE_SEPARATOR = " ";

    public Muscle() {
        this.addParameters(Arrays.asList("-clwstrict", "-quiet", "-verbose", "-nocore"));
        this.cbuilder.setParam("-log", EXEC_STAT_FILE);
    }

    public Muscle setOutput(String string) {
        super.setOutput(string);
        this.cbuilder.setParam("-out", string);
        return this;
    }

    public Muscle setInput(String string) {
        super.setInput(string);
        this.cbuilder.setParam("-in", string);
        return this;
    }

    @Override
    public Alignment getResults(String string) throws ResultNotAvailableException {
        try {
            return RunnerUtil.readClustalFile(string, this.getOutput());
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(fileNotFoundException.getMessage(), fileNotFoundException.getCause());
            throw new ResultNotAvailableException(fileNotFoundException);
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage(), iOException.getCause());
            throw new ResultNotAvailableException(iOException);
        }
        catch (UnknownFileFormatException unknownFileFormatException) {
            log.error(unknownFileFormatException.getMessage(), unknownFileFormatException.getCause());
            throw new ResultNotAvailableException(unknownFileFormatException);
        }
        catch (NullPointerException nullPointerException) {
            log.error(nullPointerException.getMessage(), nullPointerException.getCause());
            throw new ResultNotAvailableException(nullPointerException);
        }
    }

    @Override
    public List<String> getCreatedFiles() {
        return Arrays.asList(this.getOutput(), EXEC_STAT_FILE);
    }

    public static String getStatFile() {
        return EXEC_STAT_FILE;
    }

    @Override
    public Class<Muscle> getType() {
        return this.getClass();
    }
}

