/*
 * Decompiled with CFR 0.152.
 */
package compbio.runner.msa;

import compbio.data.sequence.Alignment;
import compbio.data.sequence.UnknownFileFormatException;
import compbio.engine.client.CommandBuilder;
import compbio.engine.client.Executable;
import compbio.engine.client.PipedExecutable;
import compbio.engine.client.SkeletalExecutable;
import compbio.engine.conf.PropertyHelperManager;
import compbio.metadata.ResultNotAvailableException;
import compbio.runner.RunnerUtil;
import compbio.util.PropertyHelper;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;

public class Tcoffee
extends SkeletalExecutable<Tcoffee>
implements PipedExecutable<Tcoffee> {
    private static Logger log = Logger.getLogger(Tcoffee.class);
    private static PropertyHelper ph = PropertyHelperManager.getPropertyHelper();
    public static final String KEY_VALUE_SEPARATOR = "=";
    private int ncoreNumber = 0;
    private static final String ncorePrm = "-n_core";

    public Tcoffee() {
        super(KEY_VALUE_SEPARATOR);
        this.addParameters(Arrays.asList("-output=clustalw"));
        this.setInput(this.inputFile);
    }

    public Tcoffee setInput(String string) {
        super.setInput(string);
        this.cbuilder.setParam("-seq", string);
        return this;
    }

    @Override
    public Alignment getResults(String string) throws ResultNotAvailableException {
        try {
            return RunnerUtil.readClustalFile(string, this.getOutput());
        }
        catch (FileNotFoundException fileNotFoundException) {
            log.error(fileNotFoundException.getMessage(), fileNotFoundException.getCause());
            throw new ResultNotAvailableException(fileNotFoundException);
        }
        catch (IOException iOException) {
            log.error(iOException.getMessage(), iOException.getCause());
            throw new ResultNotAvailableException(iOException);
        }
        catch (UnknownFileFormatException unknownFileFormatException) {
            log.error(unknownFileFormatException.getMessage(), unknownFileFormatException.getCause());
            throw new ResultNotAvailableException(unknownFileFormatException);
        }
        catch (NullPointerException nullPointerException) {
            log.error(nullPointerException.getMessage(), nullPointerException.getCause());
            throw new ResultNotAvailableException(nullPointerException);
        }
    }

    @Override
    public List<String> getCreatedFiles() {
        return Arrays.asList(this.getOutput());
    }

    public void setNCore(int n) {
        if (n < 1 || n > 100) {
            throw new IndexOutOfBoundsException("Number of cores must be within 1 and 100 ");
        }
        this.ncoreNumber = n;
        this.cbuilder.setParam(ncorePrm, Integer.toString(this.getNCore()));
    }

    int getNCore() {
        return this.ncoreNumber;
    }

    @Override
    public CommandBuilder<Tcoffee> getParameters(Executable.ExecProvider execProvider) {
        int n;
        if (this.ncoreNumber == 0) {
            this.setNCore(1);
        }
        if (execProvider == Executable.ExecProvider.Cluster && (n = SkeletalExecutable.getClusterCpuNum(this.getType())) != 0) {
            this.setNCore(n);
        }
        return super.getParameters(execProvider);
    }

    @Override
    public Class<Tcoffee> getType() {
        return this.getClass();
    }
}

