/*
 * Decompiled with CFR 0.152.
 */
package compbio.stat.collector;

import compbio.stat.collector.JobStat;
import compbio.ws.client.Services;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class StatProcessor {
    List<JobStat> stats;

    public StatProcessor(List<JobStat> list) {
        this.stats = list;
    }

    public List<JobStat> getClusterJobs() {
        return this.getJobSubset(true);
    }

    public List<JobStat> getLocalJobs() {
        return this.getJobSubset(false);
    }

    private List<JobStat> getJobSubset(boolean bl) {
        ArrayList<JobStat> arrayList = new ArrayList<JobStat>();
        for (JobStat jobStat : this.stats) {
            if (bl) {
                if (!jobStat.isClusterJob()) continue;
                arrayList.add(jobStat);
                continue;
            }
            if (jobStat.isClusterJob()) continue;
            arrayList.add(jobStat);
        }
        return arrayList;
    }

    public List<JobStat> getAbandonedJobs() {
        ArrayList<JobStat> arrayList = new ArrayList<JobStat>();
        for (JobStat jobStat : this.stats) {
            if (jobStat.isCollected || jobStat.isCancelled || !jobStat.hasResult()) continue;
            arrayList.add(jobStat);
        }
        return arrayList;
    }

    public List<JobStat> getFailedJobs() {
        ArrayList<JobStat> arrayList = new ArrayList<JobStat>();
        for (JobStat jobStat : this.stats) {
            if (!jobStat.hasStarted() || !jobStat.getIsFinished() || jobStat.hasResult()) continue;
            arrayList.add(jobStat);
        }
        return arrayList;
    }

    public List<JobStat> getCancelledJobs() {
        ArrayList<JobStat> arrayList = new ArrayList<JobStat>();
        for (JobStat jobStat : this.stats) {
            if (!jobStat.isCancelled) continue;
            arrayList.add(jobStat);
        }
        return arrayList;
    }

    public List<JobStat> sortByRuntime() {
        ArrayList<JobStat> arrayList = new ArrayList<JobStat>(this.stats);
        Collections.sort(arrayList, JobStat.RUNTIME);
        return arrayList;
    }

    public List<JobStat> sortByStartTime() {
        ArrayList<JobStat> arrayList = new ArrayList<JobStat>(this.stats);
        Collections.sort(arrayList, JobStat.STARTTIME);
        return arrayList;
    }

    public List<JobStat> sortByResultSize() {
        ArrayList<JobStat> arrayList = new ArrayList<JobStat>(this.stats);
        Collections.sort(arrayList, JobStat.RESULTSIZE);
        return arrayList;
    }

    public int getJobNumber() {
        return this.stats.size();
    }

    public List<JobStat> getJobs() {
        return this.stats;
    }

    public StatProcessor getSingleWSStat(Services services) {
        ArrayList<JobStat> arrayList = new ArrayList<JobStat>();
        for (JobStat jobStat : this.stats) {
            if (jobStat.webService != services) continue;
            arrayList.add(jobStat);
        }
        return new StatProcessor(arrayList);
    }

    public long getTotalRuntime() {
        long l = 0L;
        for (JobStat jobStat : this.stats) {
            int n = jobStat.getRuntime();
            if (n == -1) continue;
            l += (long)n;
        }
        return l;
    }

    public List<JobStat> getIncompleteJobs() {
        ArrayList<JobStat> arrayList = new ArrayList<JobStat>();
        for (JobStat jobStat : this.stats) {
            if (jobStat.hasResult() || jobStat.getIsCancelled()) continue;
            arrayList.add(jobStat);
        }
        return arrayList;
    }

    public String reportStat() {
        String string = "Total Jobs: " + this.getJobNumber() + "\n";
        string = string + "Abandoned Jobs: " + this.getAbandonedJobs().size() + "\n";
        string = string + "Cancelled Jobs: " + this.getCancelledJobs().size() + "\n";
        string = string + "Total Runtime (s): " + this.getTotalRuntime() + "\n";
        string = string + "Unsuccessful Jobs: " + this.getIncompleteJobs().size() + "\n";
        string = this.sortByRuntime().size() > 10 ? string + "10 longest jobs: \n\n" + this.sortByRuntime().subList(0, 9) + "\n" : string + "longest jobs: \n\n" + this.sortByRuntime() + "\n";
        string = this.sortByResultSize().size() > 10 ? string + "10 biggest jobs: \n\n" + this.sortByResultSize().subList(0, 9) + "\n" : string + "biggest jobs: \n\n" + this.sortByResultSize() + "\n";
        return string;
    }

    public String toString() {
        return this.reportStat();
    }
}

