/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.data.msa.MsaWS;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Program;
import compbio.engine.AsyncExecutor;
import compbio.engine.Configurator;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.metadata.ChunkHolder;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.RunnerConfig;
import compbio.metadata.WrongParameterException;
import compbio.runner.RunnerUtil;
import compbio.runner.msa.ClustalW;
import compbio.ws.server.WSUtil;
import java.io.File;
import java.util.List;
import javax.jws.WebService;
import org.apache.log4j.Logger;

@WebService(endpointInterface="compbio.data.msa.MsaWS", targetNamespace="http://msa.data.compbio/01/01/2010/", serviceName="ClustalWS")
public class ClustalWS
implements MsaWS<ClustalW> {
    private static Logger log = Logger.getLogger(ClustalWS.class);
    private static final RunnerConfig<ClustalW> clustalOptions = RunnerUtil.getSupportedOptions(ClustalW.class);
    private static final PresetManager<ClustalW> clustalPresets = RunnerUtil.getPresets(ClustalW.class);
    private static final LimitsManager<ClustalW> limitMan = EngineUtil.getLimits(new ClustalW().getType());

    @Override
    public String align(List<FastaSequence> list) throws JobSubmissionException {
        WSUtil.validateFastaInput(list);
        ConfiguredExecutable<ClustalW> configuredExecutable = this.init(list);
        return WSUtil.align(list, configuredExecutable, log, "align", this.getLimit(""));
    }

    ConfiguredExecutable<ClustalW> init(List<FastaSequence> list) throws JobSubmissionException {
        ClustalW clustalW = new ClustalW();
        clustalW.setInput("input.txt");
        clustalW.setOutput("result.txt");
        clustalW.setError("error.txt");
        ConfiguredExecutable<ClustalW> configuredExecutable = Configurator.configureExecutable(clustalW, list);
        return configuredExecutable;
    }

    @Override
    public String presetAlign(List<FastaSequence> list, Preset<ClustalW> preset) throws JobSubmissionException, WrongParameterException {
        WSUtil.validateFastaInput(list);
        if (preset == null) {
            throw new WrongParameterException("Preset must be provided!");
        }
        Limit<ClustalW> limit = this.getLimit(preset.getName());
        ConfiguredExecutable<ClustalW> configuredExecutable = this.init(list);
        configuredExecutable.addParameters(preset.getOptions());
        return WSUtil.align(list, configuredExecutable, log, "presetAlign", limit);
    }

    @Override
    public String customAlign(List<FastaSequence> list, List<Option<ClustalW>> list2) throws JobSubmissionException, WrongParameterException {
        WSUtil.validateFastaInput(list);
        ConfiguredExecutable<ClustalW> configuredExecutable = this.init(list);
        List<String> list3 = WSUtil.getCommands(list2, "=");
        configuredExecutable.addParameters(list3);
        log.info("Setting parameters: " + list3);
        return WSUtil.align(list, configuredExecutable, log, "customAlign", this.getLimit(""));
    }

    @Override
    public RunnerConfig<ClustalW> getRunnerOptions() {
        return clustalOptions;
    }

    @Override
    public Alignment getResult(String string) throws ResultNotAvailableException {
        WSUtil.validateJobId(string);
        AsyncExecutor asyncExecutor = Configurator.getAsyncEngine(string);
        ConfiguredExecutable<?> configuredExecutable = asyncExecutor.getResults(string);
        Alignment alignment = (Alignment)configuredExecutable.getResults();
        return new Alignment(alignment.getSequences(), Program.CLUSTAL, '-');
    }

    @Override
    public Limit<ClustalW> getLimit(String string) {
        if (limitMan == null) {
            return null;
        }
        Limit<ClustalW> limit = limitMan.getLimitByName(string);
        return limit;
    }

    @Override
    public LimitsManager<ClustalW> getLimits() {
        return limitMan;
    }

    @Override
    public boolean cancelJob(String string) {
        WSUtil.validateJobId(string);
        boolean bl = WSUtil.cancelJob(string);
        return bl;
    }

    @Override
    public JobStatus getJobStatus(String string) {
        WSUtil.validateJobId(string);
        JobStatus jobStatus = WSUtil.getJobStatus(string);
        return jobStatus;
    }

    @Override
    public PresetManager<ClustalW> getPresets() {
        return clustalPresets;
    }

    @Override
    public ChunkHolder pullExecStatistics(String string, long l) {
        WSUtil.validateJobId(string);
        String string2 = Configurator.getWorkDirectory(string) + File.separator + ClustalW.getStatFile();
        ChunkHolder chunkHolder = WSUtil.pullFile(string2, l);
        return chunkHolder;
    }
}

