/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.data.msa.MsaWS;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Program;
import compbio.engine.AsyncExecutor;
import compbio.engine.Configurator;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.metadata.ChunkHolder;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.RunnerConfig;
import compbio.metadata.WrongParameterException;
import compbio.runner.RunnerUtil;
import compbio.runner.msa.Muscle;
import compbio.ws.server.WSUtil;
import java.io.File;
import java.util.List;
import javax.jws.WebService;
import org.apache.log4j.Logger;

@WebService(endpointInterface="compbio.data.msa.MsaWS", targetNamespace="http://msa.data.compbio/01/01/2010/", serviceName="MuscleWS")
public class MuscleWS
implements MsaWS<Muscle> {
    private static Logger log = Logger.getLogger(MuscleWS.class);
    private static final RunnerConfig<Muscle> muscleOptions = RunnerUtil.getSupportedOptions(Muscle.class);
    private static final PresetManager<Muscle> musclePresets = RunnerUtil.getPresets(Muscle.class);
    private static final LimitsManager<Muscle> limitMan = EngineUtil.getLimits(new Muscle().getType());

    @Override
    public String align(List<FastaSequence> list) throws JobSubmissionException {
        WSUtil.validateFastaInput(list);
        ConfiguredExecutable<Muscle> configuredExecutable = this.init(list);
        return WSUtil.align(list, configuredExecutable, log, "align", this.getLimit(""));
    }

    ConfiguredExecutable<Muscle> init(List<FastaSequence> list) throws JobSubmissionException {
        Muscle muscle = new Muscle();
        muscle.setInput("input.txt").setOutput("result.txt").setError("error.txt");
        return Configurator.configureExecutable(muscle, list);
    }

    @Override
    public String customAlign(List<FastaSequence> list, List<Option<Muscle>> list2) throws JobSubmissionException, WrongParameterException {
        WSUtil.validateFastaInput(list);
        ConfiguredExecutable<Muscle> configuredExecutable = this.init(list);
        List<String> list3 = WSUtil.getCommands(list2, " ");
        configuredExecutable.addParameters(list3);
        return WSUtil.align(list, configuredExecutable, log, "customAlign", this.getLimit(""));
    }

    @Override
    public String presetAlign(List<FastaSequence> list, Preset<Muscle> preset) throws JobSubmissionException, WrongParameterException {
        WSUtil.validateFastaInput(list);
        if (preset == null) {
            throw new WrongParameterException("Preset must be provided!");
        }
        ConfiguredExecutable<Muscle> configuredExecutable = this.init(list);
        configuredExecutable.addParameters(preset.getOptions());
        Limit<Muscle> limit = this.getLimit(preset.getName());
        return WSUtil.align(list, configuredExecutable, log, "presetAlign", limit);
    }

    @Override
    public Alignment getResult(String string) throws ResultNotAvailableException {
        WSUtil.validateJobId(string);
        AsyncExecutor asyncExecutor = Configurator.getAsyncEngine(string);
        ConfiguredExecutable<?> configuredExecutable = asyncExecutor.getResults(string);
        Alignment alignment = (Alignment)configuredExecutable.getResults();
        return new Alignment(alignment.getSequences(), Program.Muscle, '-');
    }

    @Override
    public Limit<Muscle> getLimit(String string) {
        if (limitMan == null) {
            return null;
        }
        return limitMan.getLimitByName(string);
    }

    @Override
    public LimitsManager<Muscle> getLimits() {
        return limitMan;
    }

    @Override
    public ChunkHolder pullExecStatistics(String string, long l) {
        WSUtil.validateJobId(string);
        String string2 = Configurator.getWorkDirectory(string) + File.separator + Muscle.getStatFile();
        return WSUtil.pullFile(string2, l);
    }

    @Override
    public boolean cancelJob(String string) {
        WSUtil.validateJobId(string);
        return WSUtil.cancelJob(string);
    }

    @Override
    public JobStatus getJobStatus(String string) {
        WSUtil.validateJobId(string);
        return WSUtil.getJobStatus(string);
    }

    @Override
    public PresetManager<Muscle> getPresets() {
        return musclePresets;
    }

    @Override
    public RunnerConfig<Muscle> getRunnerOptions() {
        return muscleOptions;
    }
}

