/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.data.msa.Category;
import compbio.data.msa.JABAService;
import compbio.ws.client.Services;
import compbio.ws.client.WSTester;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Resource;
import javax.jws.WebService;
import javax.servlet.http.HttpServletRequest;
import javax.xml.ws.WebServiceContext;
import javax.xml.ws.handler.MessageContext;
import org.apache.log4j.Logger;

@WebService(endpointInterface="compbio.data.msa.RegistryWS", targetNamespace="http://msa.data.compbio/01/12/2010/", serviceName="RegistryWS")
public class RegistryWS
implements compbio.data.msa.RegistryWS,
JABAService {
    @Resource
    WebServiceContext wsContext;
    private static Logger log = Logger.getLogger(RegistryWS.class);
    private static final Map<Services, Date> operating = new ConcurrentHashMap<Services, Date>();
    private static final Map<Services, Date> nonoperating = new ConcurrentHashMap<Services, Date>();
    private static boolean allTested = false;

    @Override
    public Set<Services> getSupportedServices() {
        this.init();
        return operating.keySet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        if (this.timeToTest()) {
            Map<Services, Date> map = operating;
            synchronized (map) {
                if (this.timeToTest()) {
                    this.testAllServices();
                    allTested = true;
                }
            }
        }
    }

    private boolean timeToTest() {
        if (!allTested) {
            return true;
        }
        return this.getLongestUntestedServiceTime() > 86400;
    }

    private int getLongestUntestedServiceTime() {
        int n = 0;
        for (Services services : operating.keySet()) {
            int n2 = this.getLastTested(services);
            if (n >= n2) continue;
            n = n2;
        }
        return n;
    }

    @Override
    public int getLastTested(Services services) {
        Date date = this.getLastTestedOn(services);
        if (date != null) {
            return (int)((System.currentTimeMillis() - date.getTime()) / 1000L);
        }
        return 0;
    }

    @Override
    public Date getLastTestedOn(Services services) {
        if (operating.containsKey((Object)services)) {
            return operating.get((Object)services);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String testAllServices() {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        WSTester wSTester = new WSTester(this.getServicePath(), printWriter);
        Map<Services, Date> map = operating;
        synchronized (map) {
            for (Services services : Services.values()) {
                try {
                    if (wSTester.checkService(services)) {
                        operating.put(services, new Date());
                        continue;
                    }
                    nonoperating.put(services, new Date());
                }
                catch (Exception exception) {
                    log.info(exception, exception.getCause());
                    String string = "Fails to connect to a web service: " + (Object)((Object)services) + " with";
                    printWriter.println(string + exception.getLocalizedMessage() + "\nDetails: ");
                    exception.printStackTrace(printWriter);
                }
            }
        }
        printWriter.close();
        return ((Object)stringWriter).toString();
    }

    private String getServicePath() {
        assert (this.wsContext != null) : "WS context injection failed!";
        MessageContext messageContext = this.wsContext.getMessageContext();
        HttpServletRequest httpServletRequest = (HttpServletRequest)messageContext.get((Object)"javax.xml.ws.servlet.request");
        StringBuffer stringBuffer = httpServletRequest.getRequestURL();
        stringBuffer = stringBuffer.delete(stringBuffer.lastIndexOf("/"), stringBuffer.length());
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String testService(Services services) {
        String string = this.getServicePath();
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter((Writer)stringWriter, true);
        WSTester wSTester = new WSTester(string, printWriter);
        try {
            Map<Services, Date> map = operating;
            synchronized (map) {
                boolean bl = wSTester.checkService(services);
                if (bl) {
                    operating.put(services, new Date());
                }
            }
        }
        catch (Exception exception) {
            log.info(exception, exception.getCause());
            printWriter.println("Fails to connect to a web service: " + (Object)((Object)services) + " With " + exception.getLocalizedMessage() + "\nDetails: ");
            exception.printStackTrace(printWriter);
        }
        finally {
            printWriter.close();
        }
        return ((Object)stringWriter).toString();
    }

    @Override
    public boolean isOperating(Services services) {
        this.init();
        return operating.containsKey((Object)services);
    }

    @Override
    public String getServiceDescription(Services services) {
        return services.getServiceInfo();
    }

    @Override
    public Set<Category> getServiceCategories() {
        return Category.getCategories();
    }
}

