/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.data.msa.MsaWS;
import compbio.data.sequence.Alignment;
import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.Program;
import compbio.engine.AsyncExecutor;
import compbio.engine.Configurator;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.engine.client.Executable;
import compbio.engine.client.SkeletalExecutable;
import compbio.metadata.ChunkHolder;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import compbio.metadata.LimitsManager;
import compbio.metadata.Option;
import compbio.metadata.Preset;
import compbio.metadata.PresetManager;
import compbio.metadata.ResultNotAvailableException;
import compbio.metadata.RunnerConfig;
import compbio.metadata.WrongParameterException;
import compbio.runner.RunnerUtil;
import compbio.runner.msa.Tcoffee;
import compbio.ws.server.WSUtil;
import java.io.File;
import java.util.List;
import javax.jws.WebService;
import org.apache.log4j.Logger;

@WebService(endpointInterface="compbio.data.msa.MsaWS", targetNamespace="http://msa.data.compbio/01/01/2010/", serviceName="TcoffeeWS")
public class TcoffeeWS
implements MsaWS<Tcoffee> {
    private static Logger log = Logger.getLogger(TcoffeeWS.class);
    private static final RunnerConfig<Tcoffee> tcoffeeOptions = RunnerUtil.getSupportedOptions(Tcoffee.class);
    private static final PresetManager<Tcoffee> tcoffeePresets = RunnerUtil.getPresets(Tcoffee.class);
    private static final LimitsManager<Tcoffee> limitMan = EngineUtil.getLimits(new Tcoffee().getType());

    @Override
    public String align(List<FastaSequence> list) throws JobSubmissionException {
        WSUtil.validateFastaInput(list);
        ConfiguredExecutable<Tcoffee> configuredExecutable = this.init(list);
        return WSUtil.align(list, configuredExecutable, log, "align", this.getLimit(""));
    }

    ConfiguredExecutable<Tcoffee> init(List<FastaSequence> list) throws JobSubmissionException {
        int n;
        Tcoffee tcoffee = new Tcoffee();
        tcoffee.setInput("input.txt").setOutput("result.txt").setError("error.txt");
        ConfiguredExecutable<Tcoffee> configuredExecutable = Configurator.configureExecutable(tcoffee, list);
        if (configuredExecutable.getExecProvider() == Executable.ExecProvider.Cluster && (n = SkeletalExecutable.getClusterCpuNum(Tcoffee.class)) != 0) {
            tcoffee.setNCore(n);
        }
        return configuredExecutable;
    }

    @Override
    public String customAlign(List<FastaSequence> list, List<Option<Tcoffee>> list2) throws JobSubmissionException, WrongParameterException {
        WSUtil.validateFastaInput(list);
        ConfiguredExecutable<Tcoffee> configuredExecutable = this.init(list);
        List<String> list3 = WSUtil.getCommands(list2, "=");
        log.info("Setting parameters:" + list3);
        configuredExecutable.addParameters(list3);
        return WSUtil.align(list, configuredExecutable, log, "customAlign", this.getLimit(""));
    }

    @Override
    public String presetAlign(List<FastaSequence> list, Preset<Tcoffee> preset) throws JobSubmissionException, WrongParameterException {
        WSUtil.validateFastaInput(list);
        if (preset == null) {
            throw new WrongParameterException("Preset must be provided!");
        }
        ConfiguredExecutable<Tcoffee> configuredExecutable = this.init(list);
        configuredExecutable.addParameters(preset.getOptions());
        Limit<Tcoffee> limit = this.getLimit(preset.getName());
        return WSUtil.align(list, configuredExecutable, log, "presetAlign", limit);
    }

    @Override
    public Alignment getResult(String string) throws ResultNotAvailableException {
        WSUtil.validateJobId(string);
        AsyncExecutor asyncExecutor = Configurator.getAsyncEngine(string);
        ConfiguredExecutable<?> configuredExecutable = asyncExecutor.getResults(string);
        Alignment alignment = (Alignment)configuredExecutable.getResults();
        return new Alignment(alignment.getSequences(), Program.Tcoffee, '-');
    }

    @Override
    public Limit<Tcoffee> getLimit(String string) {
        if (limitMan == null) {
            return null;
        }
        return limitMan.getLimitByName(string);
    }

    @Override
    public LimitsManager<Tcoffee> getLimits() {
        return limitMan;
    }

    @Override
    public ChunkHolder pullExecStatistics(String string, long l) {
        WSUtil.validateJobId(string);
        String string2 = Configurator.getWorkDirectory(string) + File.separator + new Tcoffee().getError();
        return WSUtil.pullFile(string2, l);
    }

    @Override
    public boolean cancelJob(String string) {
        WSUtil.validateJobId(string);
        return WSUtil.cancelJob(string);
    }

    @Override
    public JobStatus getJobStatus(String string) {
        WSUtil.validateJobId(string);
        return WSUtil.getJobStatus(string);
    }

    @Override
    public PresetManager<Tcoffee> getPresets() {
        return tcoffeePresets;
    }

    @Override
    public RunnerConfig<Tcoffee> getRunnerOptions() {
        return tcoffeeOptions;
    }
}

