/*
 * Decompiled with CFR 0.152.
 */
package compbio.ws.server;

import compbio.data.sequence.FastaSequence;
import compbio.data.sequence.ScoreManager;
import compbio.engine.AsyncExecutor;
import compbio.engine.Configurator;
import compbio.engine.ProgressGetter;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import compbio.metadata.ChunkHolder;
import compbio.metadata.JobStatus;
import compbio.metadata.JobSubmissionException;
import compbio.metadata.Limit;
import compbio.metadata.LimitExceededException;
import compbio.metadata.Option;
import compbio.metadata.ResultNotAvailableException;
import compbio.runner.RunnerUtil;
import compbio.ws.client.Services;
import compbio.ws.client.ServicesUtil;
import compbio.ws.server.GAUtils;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.log4j.Logger;

public final class WSUtil {
    public static final void validateJobId(String string) throws InvalidParameterException {
        if (!EngineUtil.isValidJobId(string)) {
            throw new InvalidParameterException("JobId is not provided or cannot be recognised! Given value: " + string);
        }
    }

    public static final void validateFastaInput(List<FastaSequence> list) throws JobSubmissionException {
        if (list == null || list.isEmpty()) {
            throw new JobSubmissionException("List of fasta sequences required but not provided! ");
        }
        HashSet<String> hashSet = new HashSet<String>();
        for (FastaSequence fastaSequence : list) {
            boolean bl = hashSet.add(fastaSequence.getId());
            if (!bl) {
                throw new JobSubmissionException("Input sequences must have unique names! \nSequence " + fastaSequence.getId() + " is a duplicate!");
            }
            if (fastaSequence.getLength() != 0) continue;
            throw new JobSubmissionException("Sequence must not be empty! Sequence: " + fastaSequence.getId() + " was empty");
        }
    }

    public static JobStatus getJobStatus(String string) {
        AsyncExecutor asyncExecutor = Configurator.getAsyncEngine(string);
        return asyncExecutor.getJobStatus(string);
    }

    public static ChunkHolder pullFile(String string, long l) {
        return ProgressGetter.pull(string, l);
    }

    public static byte getProgress(String string) {
        throw new UnsupportedOperationException();
    }

    public static AsyncExecutor getEngine(ConfiguredExecutable<?> configuredExecutable) {
        assert (configuredExecutable != null);
        return Configurator.getAsyncEngine(configuredExecutable);
    }

    public static boolean cancelJob(String string) {
        AsyncExecutor asyncExecutor = Configurator.getAsyncEngine(string);
        return asyncExecutor.cancelJob(string);
    }

    public static <T> String align(List<FastaSequence> list, ConfiguredExecutable<T> configuredExecutable, Logger logger, String string, Limit<T> limit) throws LimitExceededException, JobSubmissionException {
        if (limit != null && limit.isExceeded(list)) {
            throw LimitExceededException.newLimitExceeded(limit, list);
        }
        RunnerUtil.writeInput(list, configuredExecutable);
        AsyncExecutor asyncExecutor = Configurator.getAsyncEngine(configuredExecutable);
        String string2 = asyncExecutor.submitJob(configuredExecutable);
        WSUtil.reportUsage(configuredExecutable, logger);
        return string2;
    }

    static <T> void reportUsage(ConfiguredExecutable<T> configuredExecutable, Logger logger) {
        if (GAUtils.IS_GA_ENABLED) {
            Services services = ServicesUtil.getServiceByRunner(configuredExecutable.getExecutable().getClass());
            GAUtils.reportUsage(services);
            logger.info("Reporting GA usage for " + (Object)((Object)services));
        }
    }

    public static <T> String analize(List<FastaSequence> list, ConfiguredExecutable<T> configuredExecutable, Logger logger, String string, Limit<T> limit) throws JobSubmissionException {
        if (limit != null && limit.isExceeded(list)) {
            throw LimitExceededException.newLimitExceeded(limit, list);
        }
        RunnerUtil.writeInput(list, configuredExecutable);
        AsyncExecutor asyncExecutor = Configurator.getAsyncEngine(configuredExecutable);
        String string2 = asyncExecutor.submitJob(configuredExecutable);
        WSUtil.reportUsage(configuredExecutable, logger);
        return string2;
    }

    public static <T> String fold(List<FastaSequence> list, ConfiguredExecutable<T> configuredExecutable, Logger logger, String string, Limit<T> limit) throws JobSubmissionException {
        if (limit != null && limit.isExceeded(list)) {
            throw LimitExceededException.newLimitExceeded(limit, list);
        }
        RunnerUtil.writeClustalInput(list, configuredExecutable, '-');
        AsyncExecutor asyncExecutor = Configurator.getAsyncEngine(configuredExecutable);
        String string2 = asyncExecutor.submitJob(configuredExecutable);
        WSUtil.reportUsage(configuredExecutable, logger);
        return string2;
    }

    public static final <T> List<String> getCommands(List<Option<T>> list, String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Option<T> option : list) {
            arrayList.add(option.toCommand(string));
        }
        return arrayList;
    }

    public static void validateAAConInput(List<FastaSequence> list) throws JobSubmissionException {
        WSUtil.validateFastaInput(list);
        int n = 0;
        for (FastaSequence fastaSequence : list) {
            if (n == 0) {
                n = fastaSequence.getLength();
                continue;
            }
            if (fastaSequence.getLength() == n) continue;
            throw new JobSubmissionException("All sequences must be of the same length. Please align the sequences  prior to submission! The first sequence length is : " + n + " but the sequence '" + fastaSequence.getId() + "' length is " + fastaSequence.getLength());
        }
    }

    public static <T> ScoreManager getAnnotation(String string, Logger logger) throws ResultNotAvailableException {
        WSUtil.validateJobId(string);
        AsyncExecutor asyncExecutor = Configurator.getAsyncEngine(string);
        ConfiguredExecutable<?> configuredExecutable = asyncExecutor.getResults(string);
        ScoreManager scoreManager = (ScoreManager)configuredExecutable.getResults();
        logger.trace(string + " getConservation : " + scoreManager);
        return scoreManager;
    }
}

