/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine;

import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.PathValidator;
import compbio.util.Util;
import java.io.File;
import java.util.List;
import org.apache.log4j.Logger;

public class Cleaner {
    private static final Logger log = Logger.getLogger(Cleaner.class);

    public static boolean deleteFiles(ConfiguredExecutable<?> configuredExecutable) {
        if (configuredExecutable == null) {
            throw new IllegalArgumentException("Executable must be provided!");
        }
        List<String> list = configuredExecutable.getCreatedFiles();
        for (String string : list) {
            assert (PathValidator.isAbsolutePath(string)) : " Absolute path must be provided but got: " + string;
            Cleaner.removeFile(string);
        }
        Cleaner.removeFile(configuredExecutable.getWorkDirectory() + File.separator + "procOutput.txt");
        Cleaner.removeFile(configuredExecutable.getWorkDirectory() + File.separator + "procError.txt");
        return Cleaner.removeFile(configuredExecutable.getWorkDirectory());
    }

    static boolean removeFile(String string) {
        File file = new File(string);
        boolean bl = false;
        if (file.exists()) {
            String string2 = file.isDirectory() ? "Directory " : "File ";
            bl = file.delete();
            if (bl) {
                log.trace(string2 + string + " was successfully removed");
            } else {
                log.debug("Could not remove " + string2 + ": " + string + " reportedly created by executable. Insufficient access right?");
            }
        } else {
            log.debug("File: " + string + " does not appear ro exist. Could have been removed?");
        }
        return bl;
    }

    public static boolean deleteAllFiles(String string) {
        if (Util.isEmpty(string)) {
            throw new NullPointerException("Directory must be provided! ");
        }
        File file = new File(string);
        if (!file.exists()) {
            log.error("Directory " + string + " does not exist. Have been deleted already?");
            return false;
        }
        if (!file.isDirectory()) {
            log.error("Directory is expected by file given! Skipping... ");
            return false;
        }
        File[] fileArray = file.listFiles();
        int n = 0;
        for (File file2 : fileArray) {
            if (file2.isDirectory()) {
                log.error("Cannot delete subdirectories! Skipping...");
                continue;
            }
            if (file2.delete()) {
                ++n;
                log.debug("file " + file2.getName() + " removed");
                continue;
            }
            log.debug("file " + file2.getName() + " is not removed");
        }
        file.delete();
        return n == fileArray.length;
    }

    public static boolean deleteDirectory(String string) {
        if (Cleaner.deleteAllFiles(string)) {
            File file = new File(string);
            return file.delete();
        }
        return false;
    }
}

