/*
 * Decompiled with CFR 0.152.
 */
package compbio.engine;

import compbio.engine.ClusterJobId;
import compbio.engine.client.ConfiguredExecutable;
import compbio.engine.client.EngineUtil;
import java.util.List;

public final class Job {
    private final ClusterJobId jobId;
    private final String taskId;
    private final ConfiguredExecutable<?> cexecutable;

    public Job(String string, String string2, ConfiguredExecutable<?> configuredExecutable) {
        if (!EngineUtil.isValidJobId(string)) {
            throw new IllegalArgumentException("TaskId " + string + " is not valid!");
        }
        if (string2 == null) {
            throw new NullPointerException("Cluster JobId must be provided!");
        }
        if (configuredExecutable == null) {
            throw new NullPointerException("ConfiguredExecutable must be provided!");
        }
        this.jobId = new ClusterJobId(string2);
        this.taskId = string;
        this.cexecutable = configuredExecutable;
    }

    public ClusterJobId getJobId() {
        return this.jobId;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public ConfiguredExecutable<?> getConfExecutable() {
        return this.cexecutable;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + (this.jobId == null ? 0 : this.jobId.hashCode());
        n = 31 * n + (this.taskId == null ? 0 : this.taskId.hashCode());
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Job job = (Job)object;
        if (this.jobId == null ? job.jobId != null : !this.jobId.equals(job.jobId)) {
            return false;
        }
        return !(this.taskId == null ? job.taskId != null : !this.taskId.equals(job.taskId));
    }

    public String toString() {
        return "Job [cexecutable=" + this.cexecutable + ", jobId=" + this.jobId + ", taskId=" + this.taskId + "]";
    }

    public static Job getByTaskId(String string, List<Job> list) {
        for (Job job : list) {
            if (!string.equals(job.getTaskId())) continue;
            return job;
        }
        return null;
    }

    public static Job getByJobId(String string, List<Job> list) {
        for (Job job : list) {
            if (!string.equals(job.getJobId())) continue;
            return job;
        }
        return null;
    }
}

